/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.parser;

import java.util.Iterator;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.BlockComment;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.CommentBody;
import org.eclipse.acceleo.Documentation;
import org.eclipse.acceleo.ErrorMetamodel;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleDocumentation;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleElementDocumentation;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.ProtectedArea;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.query.parser.AstSerializer;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.ecore.EObject;

public class AcceleoAstSerializer
extends AcceleoSwitch<Object> {
    private static final String INDENTATION_SPACE = "  ";
    private static final String SPACE = " ";
    private static final char NEW_LINE = '\n';
    private static final Object DUMMY = new Object();
    private AstSerializer querySerializer = new AstSerializer();
    private IndentedStringBuilder builder;
    private String bindingSeparator;

    public String serialize(ASTNode node) {
        this.builder = new IndentedStringBuilder();
        this.doSwitch(node);
        return this.builder.toString();
    }

    @Override
    public Object caseBinding(Binding binding) {
        this.builder.append(binding.getName());
        this.builder.append(" : ");
        if (binding.getType() != null) {
            this.builder.append(this.querySerializer.serialize(binding.getType().getAst()));
        }
        this.builder.append(SPACE);
        this.builder.append(this.bindingSeparator);
        this.builder.append(SPACE);
        this.doSwitch(binding.getInitExpression());
        return DUMMY;
    }

    @Override
    public Object caseBlock(Block block) {
        for (Statement statement : block.getStatements()) {
            this.doSwitch(statement);
        }
        return DUMMY;
    }

    @Override
    public Object caseBlockComment(BlockComment blockComment) {
        this.builder.append("[comment]");
        this.doSwitch(blockComment.getBody());
        this.builder.append("[/comment]");
        return DUMMY;
    }

    @Override
    public Object caseComment(Comment comment) {
        this.builder.append('\n');
        this.builder.append("[comment ");
        this.doSwitch(comment.getBody());
        this.builder.append("/]");
        return DUMMY;
    }

    @Override
    public Object caseCommentBody(CommentBody commentBody) {
        this.builder.append(commentBody.getValue());
        return DUMMY;
    }

    @Override
    public Object caseDocumentation(Documentation documentation) {
        this.builder.append("[**");
        this.doSwitch(documentation.getBody());
        this.builder.append("/]");
        return DUMMY;
    }

    @Override
    public Object caseExpression(Expression expression) {
        this.builder.append(this.querySerializer.serialize(expression.getAst().getAst()));
        return DUMMY;
    }

    @Override
    public Object caseExpressionStatement(ExpressionStatement expressionStatement) {
        this.builder.append("[");
        this.doSwitch(expressionStatement.getExpression());
        this.builder.append("/]");
        return DUMMY;
    }

    @Override
    public Object caseFileStatement(FileStatement fileStatement) {
        this.builder.append("[file ");
        this.builder.append("(");
        this.doSwitch(fileStatement.getUrl());
        this.builder.append(",");
        this.builder.append(SPACE);
        this.builder.append(fileStatement.getMode().getName());
        if (fileStatement.getCharset() != null) {
            this.builder.append(",");
            this.builder.append(SPACE);
            this.doSwitch(fileStatement.getCharset());
        }
        this.builder.append(")");
        this.builder.append("]");
        this.generateBlock(fileStatement.getBody());
        this.builder.append("[/file]");
        return DUMMY;
    }

    @Override
    public Object caseForStatement(ForStatement forStatement) {
        this.builder.append("[for ");
        this.builder.append("(");
        this.bindingSeparator = "|";
        if (forStatement.getBinding() != null) {
            this.doSwitch(forStatement.getBinding());
        }
        this.builder.append(")");
        if (forStatement.getSeparator() != null) {
            this.builder.append(SPACE);
            this.builder.append("separator(");
            this.doSwitch(forStatement.getSeparator());
            this.builder.append(")");
        }
        this.builder.append("]");
        this.generateBlock(forStatement.getBody());
        this.builder.append("[/for]");
        return DUMMY;
    }

    @Override
    public Object caseIfStatement(IfStatement ifStatement) {
        this.builder.append("[if ");
        this.builder.append("(");
        this.doSwitch(ifStatement.getCondition());
        this.builder.append(")");
        this.builder.append("]");
        if (ifStatement.getThen() != null) {
            this.generateBlock(ifStatement.getThen());
        }
        if (ifStatement.getElse() != null) {
            Block elseBlock = ifStatement.getElse();
            this.generateElse(elseBlock);
        }
        this.builder.append("[/if]");
        return DUMMY;
    }

    private void generateElse(Block block) {
        if (block.getStatements().size() == 1 && block.getStatements().get(0) instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)block.getStatements().get(0);
            this.builder.append("[elseif ");
            this.builder.append("(");
            this.doSwitch(ifStatement.getCondition());
            this.builder.append(")");
            this.builder.append("]");
            this.generateBlock(ifStatement.getThen());
            if (ifStatement.getElse() != null) {
                Block elseBlock = ifStatement.getElse();
                this.generateElse(elseBlock);
            }
        } else {
            this.builder.append("[else]");
            this.generateBlock(block);
        }
    }

    @Override
    public Object caseImport(Import imp) {
        this.builder.append("[import ");
        this.doSwitch(imp.getModule());
        this.builder.append("/]");
        this.builder.append('\n');
        return DUMMY;
    }

    @Override
    public Object caseLetStatement(LetStatement letStatement) {
        this.builder.append("[let ");
        if (!letStatement.getVariables().isEmpty()) {
            IndentedStringBuilder previousBuilder = this.builder;
            try {
                this.builder = new IndentedStringBuilder();
                this.bindingSeparator = "=";
                for (Binding binding : letStatement.getVariables()) {
                    this.doSwitch(binding);
                    this.builder.append(",");
                    this.builder.append(SPACE);
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append("]");
        this.generateBlock(letStatement.getBody());
        this.builder.append("[/let]");
        return DUMMY;
    }

    @Override
    public Object caseErrorMetamodel(ErrorMetamodel object) {
        return DUMMY;
    }

    @Override
    public Object caseMetamodel(Metamodel metamodel) {
        this.builder.append("'");
        this.builder.append(metamodel.getReferencedPackage().getNsURI());
        this.builder.append("'");
        return DUMMY;
    }

    @Override
    public Object caseModule(Module module) {
        if (module.getDocumentation() != null) {
            this.doSwitch(module.getDocumentation());
        }
        this.builder.append("[module ");
        this.builder.append(module.getName());
        this.builder.append("(");
        if (!module.getMetamodels().isEmpty()) {
            IndentedStringBuilder previousBuilder = this.builder;
            try {
                this.builder = new IndentedStringBuilder();
                for (Object metamodel : module.getMetamodels()) {
                    this.doSwitch((EObject)metamodel);
                    this.builder.append(",");
                    this.builder.append(SPACE);
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append(")");
        if (module.getExtends() != null) {
            this.builder.append(SPACE);
            this.builder.append("extends ");
            this.doSwitch(module.getExtends());
        }
        this.builder.append("/]");
        if (!module.getModuleElements().isEmpty() || !module.getImports().isEmpty()) {
            this.builder.append('\n');
        }
        for (Import importedModule : module.getImports()) {
            this.doSwitch(importedModule);
        }
        Iterator iterator = module.getModuleElements().iterator();
        while (iterator.hasNext()) {
            ModuleElement moduleElement = (ModuleElement)iterator.next();
            if (moduleElement instanceof Query || moduleElement instanceof Template) {
                this.builder.append('\n');
                this.doSwitch(moduleElement);
                if (!iterator.hasNext()) continue;
                this.builder.append('\n');
                continue;
            }
            this.doSwitch(moduleElement);
        }
        return DUMMY;
    }

    @Override
    public Object caseModuleDocumentation(ModuleDocumentation moduleDocumentation) {
        this.builder.append("[**");
        this.doSwitch(moduleDocumentation.getBody());
        this.builder.append("/]");
        this.builder.append('\n');
        return DUMMY;
    }

    @Override
    public Object caseModuleElementDocumentation(ModuleElementDocumentation moduleElementDocumentation) {
        this.builder.append("[**");
        this.doSwitch(moduleElementDocumentation.getBody());
        this.builder.append("/]");
        this.builder.append('\n');
        return DUMMY;
    }

    @Override
    public Object caseModuleReference(ModuleReference moduleReference) {
        this.builder.append(moduleReference.getQualifiedName());
        return DUMMY;
    }

    @Override
    public Object caseProtectedArea(ProtectedArea protectedArea) {
        this.builder.append("[protected ");
        this.builder.append("(");
        this.doSwitch(protectedArea.getId());
        this.builder.append(")");
        this.builder.append("]");
        this.doSwitch(protectedArea.getBody());
        this.builder.append("[/protected]");
        return DUMMY;
    }

    @Override
    public Object caseQuery(Query query) {
        if (query.getDocumentation() != null) {
            this.doSwitch(query.getDocumentation());
        }
        this.builder.append("[query ");
        this.builder.append((Object)query.getVisibility());
        this.builder.append(SPACE);
        this.builder.append(query.getName());
        this.builder.append("(");
        if (!query.getParameters().isEmpty()) {
            IndentedStringBuilder previousBuilder = this.builder;
            try {
                this.builder = new IndentedStringBuilder();
                for (Variable parameter : query.getParameters()) {
                    this.doSwitch(parameter);
                    this.builder.append(",");
                    this.builder.append(SPACE);
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append(")");
        this.builder.append(SPACE);
        if (query.getType() != null) {
            this.builder.append(":");
            this.builder.append(SPACE);
            this.builder.append(this.querySerializer.serialize(query.getType().getAst()));
            this.builder.append(SPACE);
        }
        this.builder.append("=");
        this.builder.append(SPACE);
        this.doSwitch(query.getBody());
        this.builder.append("/]");
        return DUMMY;
    }

    @Override
    public Object caseTemplate(Template template) {
        if (template.getDocumentation() != null) {
            this.doSwitch(template.getDocumentation());
        }
        this.builder.append("[template ");
        this.builder.append((Object)template.getVisibility());
        this.builder.append(SPACE);
        this.builder.append(template.getName());
        this.builder.append("(");
        if (!template.getParameters().isEmpty()) {
            IndentedStringBuilder previousBuilder = this.builder;
            try {
                this.builder = new IndentedStringBuilder();
                for (Variable parameter : template.getParameters()) {
                    this.doSwitch(parameter);
                    this.builder.append(",");
                    this.builder.append(SPACE);
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append(")");
        if (template.getGuard() != null) {
            this.builder.append(SPACE);
            this.builder.append("?");
            this.builder.append(SPACE);
            this.builder.append("(");
            this.doSwitch(template.getGuard());
            this.builder.append(")");
        }
        if (template.getPost() != null) {
            this.builder.append(SPACE);
            this.builder.append("post(");
            this.doSwitch(template.getPost());
            this.builder.append(")");
        }
        this.builder.append("]");
        this.generateBlock(template.getBody());
        this.builder.append("[/template]");
        return DUMMY;
    }

    private void generateBlock(Block block) {
        if (!block.getStatements().isEmpty()) {
            this.builder.indent();
            EObject container = block.eContainer();
            if (container instanceof Template || this.isNewLineStatement(container)) {
                this.builder.append('\n');
            }
            Statement lastStatement = (Statement)block.getStatements().get(block.getStatements().size() - 1);
            for (Statement statement : block.getStatements()) {
                this.doSwitch(statement);
                if (statement.equals(lastStatement)) {
                    this.builder.deindent();
                }
                if (!this.isNewLineStatement(statement) && !(statement instanceof IfStatement)) continue;
                this.builder.append('\n');
            }
        }
    }

    private boolean isNewLineStatement(EObject eObject) {
        boolean res = false;
        switch (eObject.eClass().getClassifierID()) {
            case 48: {
                res = true;
                break;
            }
            case 46: {
                res = true;
                break;
            }
            case 42: {
                res = true;
                break;
            }
            case 40: {
                res = true;
                break;
            }
        }
        return res;
    }

    @Override
    public Object caseTextStatement(TextStatement textStatement) {
        this.builder.append(textStatement);
        return DUMMY;
    }

    @Override
    public Object caseVariable(Variable variable) {
        this.builder.append(variable.getName());
        this.builder.append(SPACE);
        this.builder.append(":");
        this.builder.append(SPACE);
        this.builder.append(this.querySerializer.serialize(variable.getType().getAst()));
        return DUMMY;
    }

    private class IndentedStringBuilder {
        private boolean enabled = true;
        private int indentation;
        private StringBuilder stringBuilder = new StringBuilder();

        private IndentedStringBuilder() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void append(Object o) {
            if (o instanceof TextStatement) {
                boolean isLastOfABlock;
                String value = ((TextStatement)o).getValue();
                EObject eContainer = ((TextStatement)o).eContainer();
                boolean bl = isLastOfABlock = eContainer instanceof Block && !(eContainer.eContainer() instanceof ProtectedArea) && ((Block)eContainer).getStatements().indexOf(o) == ((Block)eContainer).getStatements().size() - 1;
                if (!value.isEmpty() && value.charAt(value.length() - 1) == '\n' && isLastOfABlock) {
                    this.append(value.substring(0, value.length() - 1));
                    this.stringBuilder.append('\n');
                    this.stringBuilder.append(this.getIndentationString(this.indentation - 1));
                } else {
                    this.append(value);
                }
            } else if (o instanceof Character) {
                this.append(((Character)o).charValue());
            } else {
                String s = String.valueOf(o);
                int i = 0;
                while (i < s.length()) {
                    this.append(s.charAt(i));
                    ++i;
                }
            }
        }

        public void append(char c) {
            this.stringBuilder.append(c);
            if ('\n' == c) {
                this.stringBuilder.append(this.getIndentationString(this.indentation));
            }
        }

        private String getIndentationString(int count) {
            if (!this.enabled) {
                return "";
            }
            StringBuilder res = new StringBuilder();
            int i = 0;
            while (i < count) {
                res.append(AcceleoAstSerializer.INDENTATION_SPACE);
                ++i;
            }
            return res.toString();
        }

        public int length() {
            return this.stringBuilder.length();
        }

        public String substring(int i, int j) {
            return this.stringBuilder.substring(i, j);
        }

        public String toString() {
            return this.stringBuilder.toString();
        }

        public void indent() {
            ++this.indentation;
        }

        public void deindent() {
            --this.indentation;
        }
    }
}

