/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.workspace;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoWorkspace;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;

public class AcceleoProject {
    private final Map<URI, AcceleoTextDocument> acceleoTextDocumentsIndex = new TreeMap<URI, AcceleoTextDocument>();
    private AcceleoWorkspace workspace;
    private String label;
    private IAcceleoEnvironment acceleoEnvironment;

    public AcceleoProject(String label, IAcceleoEnvironment acceleoEnvironment) {
        this.label = Objects.requireNonNull(label);
        this.acceleoEnvironment = Objects.requireNonNull(acceleoEnvironment);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public AcceleoLanguageServer getLanguageServer() {
        if (this.getWorkspace() != null) {
            return this.getWorkspace().getOwner();
        }
        return null;
    }

    public void setWorkspace(AcceleoWorkspace acceleoWorkspace) {
        this.workspace = acceleoWorkspace;
        this.getTextDocuments().forEach(textDocument -> textDocument.environmentChanged());
    }

    public IAcceleoEnvironment getAcceleoEnvironment() {
        return this.acceleoEnvironment;
    }

    public List<AcceleoTextDocument> getTextDocuments() {
        return Collections.unmodifiableList(new ArrayList<AcceleoTextDocument>(this.acceleoTextDocumentsIndex.values()));
    }

    public void setAcceleoEnvironment(IAcceleoEnvironment newAcceleoEnvironment) {
        this.acceleoEnvironment = newAcceleoEnvironment;
        this.getTextDocuments().forEach(textDocument -> textDocument.environmentChanged());
    }

    public void addTextDocument(AcceleoTextDocument textDocumentToAdd) {
        if (this.acceleoTextDocumentsIndex.containsKey(textDocumentToAdd.getUri())) {
            throw new IllegalArgumentException("There was an issue while trying to add text document " + textDocumentToAdd.getUri() + " to project " + this.getLabel() + ": there is already a known text document with this URI.");
        }
        textDocumentToAdd.setProject(this);
        this.acceleoTextDocumentsIndex.put(textDocumentToAdd.getUri(), textDocumentToAdd);
        this.workspace.documentSaved(textDocumentToAdd);
    }

    public void removeTextDocument(AcceleoTextDocument textDocumentToRemove) {
        if (!this.acceleoTextDocumentsIndex.containsKey(textDocumentToRemove.getUri())) {
            throw new IllegalArgumentException("There was an issue while trying to remove text document " + textDocumentToRemove.getUri() + " from project " + this.getLabel() + ": there is no known text document with this URI.");
        }
        textDocumentToRemove.setProject(null);
        this.acceleoTextDocumentsIndex.remove(textDocumentToRemove.getUri());
        this.workspace.documentRemoved(textDocumentToRemove);
    }

    public AcceleoTextDocument getTextDocument(URI uri) {
        return this.acceleoTextDocumentsIndex.get(uri);
    }

    public AcceleoWorkspace getWorkspace() {
        return this.workspace;
    }

    public void documentSaved(AcceleoTextDocument savedTextDocument) {
        String qualifiedNameOfSavedModule = savedTextDocument.getModuleQualifiedName();
        IQualifiedNameLookupEngine lookupEngine = this.getAcceleoEnvironment().getQueryEnvironment().getLookupEngine();
        lookupEngine.clearContext(qualifiedNameOfSavedModule);
        lookupEngine.getResolver().clear(qualifiedNameOfSavedModule);
        lookupEngine.getResolver().register(qualifiedNameOfSavedModule, (Object)savedTextDocument.getAcceleoAstResult().getModule());
        Set<AcceleoTextDocument> consumers = this.getTextDocumentsThatDependOn(qualifiedNameOfSavedModule);
        for (AcceleoTextDocument consumer : consumers) {
            consumer.environmentChanged();
        }
        if (this.getTextDocuments().contains(savedTextDocument) && this.getWorkspace() != null) {
            this.getWorkspace().documentSaved(savedTextDocument);
        }
    }

    public void documentRemoved(AcceleoTextDocument removedTextDocument) {
        IQualifiedNameLookupEngine lookupEngine = this.getAcceleoEnvironment().getQueryEnvironment().getLookupEngine();
        String removedModuleQualifiedName = lookupEngine.getResolver().getQualifiedName(removedTextDocument.getUrl());
        lookupEngine.getResolver().clear(removedModuleQualifiedName);
        lookupEngine.clearContext(removedModuleQualifiedName);
        Set<AcceleoTextDocument> consumers = this.getTextDocumentsThatDependOn(removedModuleQualifiedName);
        for (AcceleoTextDocument consumer : consumers) {
            consumer.environmentChanged();
        }
    }

    private Set<AcceleoTextDocument> getTextDocumentsThatDependOn(String moduleQualifiedName) {
        HashSet<AcceleoTextDocument> res = new HashSet<AcceleoTextDocument>();
        for (AcceleoTextDocument acceleoTextDocument : this.getTextDocuments()) {
            if (moduleQualifiedName.equals(acceleoTextDocument.getModuleQualifiedName()) || !AcceleoProject.dependsOn(acceleoTextDocument.getAcceleoAstResult().getModule(), moduleQualifiedName)) continue;
            res.add(acceleoTextDocument);
        }
        return res;
    }

    private static boolean dependsOn(Module module, String moduleQualifiedName) {
        boolean res = false;
        if (module.getExtends() != null && moduleQualifiedName.equals(module.getExtends().getQualifiedName())) {
            res = true;
        } else {
            for (Import imp : module.getImports()) {
                if (!moduleQualifiedName.equals(imp.getModule().getQualifiedName())) continue;
                res = true;
                break;
            }
        }
        return res;
    }
}

