/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.List;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.Positions;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;

public class AstResult {
    private final Expression ast;
    private final List<Error> errors;
    private final Positions positions;
    private Diagnostic diagnostic;

    public AstResult(Expression ast, Positions positions, List<Error> errors, Diagnostic diagnostic) {
        this.ast = ast;
        this.positions = positions;
        this.errors = errors;
        this.diagnostic = diagnostic;
    }

    public Expression getAst() {
        return this.ast;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public int getStartPosition(Expression expression) {
        return this.getInternalStartPosition(expression);
    }

    public int getStartPosition(VariableDeclaration declaration) {
        return this.getInternalStartPosition(declaration);
    }

    private int getInternalStartPosition(EObject object) {
        Integer position = this.positions.getStartPositions(object);
        int res = position != null ? position : -1;
        return res;
    }

    public int getStartLine(Expression expression) {
        return this.getInternalStartLine(expression);
    }

    public int getStartLine(VariableDeclaration declaration) {
        return this.getInternalStartLine(declaration);
    }

    private int getInternalStartLine(EObject object) {
        Integer line = this.positions.getStartLines(object);
        int res = line != null ? line : -1;
        return res;
    }

    public int getStartColumn(Expression expression) {
        return this.getInternalStartColumn(expression);
    }

    public int getStartColumn(VariableDeclaration declaration) {
        return this.getInternalStartColumn(declaration);
    }

    private int getInternalStartColumn(EObject object) {
        Integer column = this.positions.getStartColumns(object);
        int res = column != null ? column : -1;
        return res;
    }

    public int getEndPosition(Expression expression) {
        return this.getInternalEndPosition(expression);
    }

    public int getEndPosition(VariableDeclaration declaration) {
        return this.getInternalEndPosition(declaration);
    }

    private int getInternalEndPosition(EObject object) {
        Integer position = this.positions.getEndPositions(object);
        int res = position != null ? position : -1;
        return res;
    }

    public int getEndLine(Expression expression) {
        return this.getInternalEndLine(expression);
    }

    public int getEndLine(VariableDeclaration declaration) {
        return this.getInternalEndLine(declaration);
    }

    private int getInternalEndLine(EObject object) {
        Integer line = this.positions.getEndLines(object);
        int res = line != null ? line : -1;
        return res;
    }

    public int getEndColumn(Expression expression) {
        return this.getInternalEndColumn(expression);
    }

    public int getEndColumn(VariableDeclaration declaration) {
        return this.getInternalEndColumn(declaration);
    }

    private int getInternalEndColumn(EObject object) {
        Integer column = this.positions.getEndColumns(object);
        int res = column != null ? column : -1;
        return res;
    }

    public void addAllPositonsTo(Positions pos, int offsetPosition, int offsetLine, int offsetColumn) {
        pos.addAll(this.positions, offsetPosition, offsetLine, offsetColumn);
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public AstResult subResult(Expression subAst) {
        return new AstResult(subAst, this.positions, this.errors, this.diagnostic);
    }

    public EObject getAstNode(int position) {
        return this.positions.getNodeAt(this.ast, position);
    }

    public EObject getAstNode(int line, int column) {
        return this.positions.getNodeAt(this.ast, line, column);
    }
}

