/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.resolver.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;

public class ClassLoaderQualifiedNameResolver
implements IQualifiedNameResolver {
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private final ClassLoader classLoader;
    private final AcceleoParser parser;
    private final Map<String, URL> qualifiedNameToURL = new HashMap<String, URL>();
    private final Map<URL, String> urlToQualifiedName = new HashMap<URL, String>();

    public ClassLoaderQualifiedNameResolver(ClassLoader classLoader, IReadOnlyQueryEnvironment queryEnvironment) {
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(queryEnvironment);
        this.classLoader = classLoader;
        this.parser = new AcceleoParser(queryEnvironment);
    }

    @Override
    public Module resolveModule(String qualifiedName) throws IOException {
        Module res;
        Throwable throwable = null;
        Object var4_4 = null;
        try (InputStream input = this.classLoader.getResourceAsStream(this.getModuleResourceName(qualifiedName));){
            res = input != null ? this.parser.parse(input, StandardCharsets.UTF_8, qualifiedName).getModule() : null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res;
    }

    protected String getModuleResourceName(String qualifiedName) {
        return String.valueOf(qualifiedName.replace("::", SLASH)) + DOT + "mtl";
    }

    @Override
    public Class<?> resolveClass(String qualifiedName) throws ClassNotFoundException {
        return this.classLoader.loadClass(this.getClassName(qualifiedName));
    }

    private String getClassName(String qualifiedName) {
        return qualifiedName.replace("::", DOT);
    }

    @Override
    public URL getModuleURL(String qualifiedName) {
        return this.qualifiedNameToURL.computeIfAbsent(qualifiedName, key -> this.classLoader.getResource(this.getModuleResourceName((String)key)));
    }

    @Override
    public URL getModuleSourceURL(String qualifiedName) {
        return this.getModuleURL(qualifiedName);
    }

    @Override
    public String getQualifierName(URL resource) {
        return this.urlToQualifiedName.computeIfAbsent(resource, key -> {
            String res = null;
            String filePath = resource.getFile();
            String[] segments = filePath.substring(0, filePath.length() - ("mtl".length() + 1)).split(SLASH);
            StringBuilder moduleQualifiedNameBuilder = new StringBuilder();
            int i = segments.length - 1;
            while (i >= 0) {
                moduleQualifiedNameBuilder.insert(0, segments[i]);
                String qualifiedName = moduleQualifiedNameBuilder.toString();
                if (this.getModuleURL(qualifiedName) != null) {
                    res = qualifiedName;
                }
                moduleQualifiedNameBuilder.insert(0, "::");
                --i;
            }
            return res;
        });
    }

    @Override
    public Set<String> getAvailableQualifiedNames() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        try {
            if (this.classLoader instanceof URLClassLoader) {
                URL[] uRLArray = ((URLClassLoader)this.classLoader).getURLs();
                int n = uRLArray.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url = uRLArray[n2];
                    res.addAll(this.getQualifiedNamesFromURL(url));
                    ++n2;
                }
            } else {
                Enumeration<URL> rootResources = this.classLoader.getResources("");
                while (rootResources.hasMoreElements()) {
                    URL url = rootResources.nextElement();
                    res.addAll(this.getQualifiedNamesFromURL(url));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    protected Set<String> getQualifiedNamesFromURL(URL url) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        if ("file".equals(url.getProtocol())) {
            try {
                File file = new File(url.toURI());
                if (file.isDirectory()) {
                    res.addAll(this.getQualifiedNameFromFolder(file, ""));
                } else if (file.isFile()) {
                    res.addAll(this.getQualifiedNameFromJar(file));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return res;
    }

    protected Set<String> getQualifiedNameFromJar(File file) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (ZipFile jarFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName().replace(SLASH, "::");
                    if (!name.endsWith(".class") && !name.endsWith(".mtl")) continue;
                    res.add(name.substring(0, name.lastIndexOf(DOT)));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    protected Set<String> getQualifiedNameFromFolder(File folder, String nameSpace) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        if (folder.exists() && folder.canRead()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    res.addAll(this.getQualifiedNameFromFolder(child, String.valueOf(nameSpace) + child.getName() + "::"));
                } else if (child.isFile() && (child.getName().endsWith(".class") || child.getName().endsWith(".mtl"))) {
                    res.add(String.valueOf(nameSpace) + child.getName().substring(0, child.getName().lastIndexOf(DOT)));
                }
                ++n2;
            }
        }
        return res;
    }
}

