/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.Error;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.ProtectedArea;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;

public class AcceleoEvaluator
extends AcceleoSwitch<Object> {
    private static final String ID = "org.eclipse.acceleo.aql";
    private static final String EMPTY_RESULT = "";
    private static final String NEW_LINE = "\n";
    private final IAcceleoEnvironment environment;
    private final IQueryEvaluationEngine aqlEngine;
    private final Deque<Map<String, Object>> variablesStack = new ArrayDeque<Map<String, Object>>();
    private final Deque<String> indentationStack = new ArrayDeque<String>();
    private String lastLineOfLastStatement;

    public AcceleoEvaluator(IAcceleoEnvironment environment) {
        this.environment = environment;
        environment.setEvaluator(this);
        IQueryEnvironment queryEnvironment = environment.getQueryEnvironment();
        this.aqlEngine = QueryEvaluation.newEngine((IQueryEnvironment)queryEnvironment);
    }

    public Object generate(ASTNode node, Map<String, Object> variables) {
        Object res;
        this.lastLineOfLastStatement = EMPTY_RESULT;
        this.pushVariables(variables);
        try {
            res = this.doSwitch(node);
        }
        finally {
            this.popVariables();
        }
        return res;
    }

    protected void pushVariables(Map<String, Object> variables) {
        this.variablesStack.addLast(variables);
    }

    protected Map<String, Object> peekVariables() {
        return this.variablesStack.peekLast();
    }

    protected Map<String, Object> popVariables() {
        return this.variablesStack.removeLast();
    }

    protected Deque<Map<String, Object>> getVariablesStack() {
        return this.variablesStack;
    }

    protected void pushIndentation(String indentation) {
        this.indentationStack.addLast(indentation);
    }

    protected String peekIndentation() {
        return this.indentationStack.peekLast();
    }

    protected String popIndentation() {
        return this.indentationStack.removeLast();
    }

    protected IQueryEvaluationEngine getAqlEngine() {
        return this.aqlEngine;
    }

    protected IAcceleoEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public Object caseExpression(Expression expression) {
        EvaluationResult evalResult;
        AstResult ast = expression.getAst();
        if (ast.getDiagnostic().getSeverity() == 4) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, ID, 0, "AQL parsing issue", new Object[]{expression});
            diagnostic.addAll(ast.getDiagnostic());
            this.environment.getGenerationResult().addDiagnostic((Diagnostic)diagnostic);
        }
        if ((evalResult = this.aqlEngine.eval(ast, this.peekVariables())).getDiagnostic().getSeverity() != 0) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(evalResult.getDiagnostic().getSeverity(), ID, 0, "AQL evaluation issue", new Object[]{expression, new HashMap<String, Object>(this.peekVariables())});
            diagnostic.addAll(evalResult.getDiagnostic());
            this.environment.getGenerationResult().addDiagnostic((Diagnostic)diagnostic);
        }
        return evalResult.getResult();
    }

    @Override
    public String caseExpressionStatement(ExpressionStatement expressionStatement) {
        String res;
        String expressionValue = this.toString(this.doSwitch(expressionStatement.getExpression()));
        boolean endsWithNewLine = expressionValue.endsWith(NEW_LINE);
        String indentation = this.peekIndentation();
        if (!indentation.isEmpty()) {
            expressionValue = expressionValue.replace(NEW_LINE, NEW_LINE + indentation);
            if (endsWithNewLine) {
                expressionValue = expressionValue.substring(0, expressionValue.length() - indentation.length());
            }
        }
        if (expressionStatement.isNewLineNeeded() && !endsWithNewLine) {
            res = this.lastLineOfLastStatement.isEmpty() ? String.valueOf(indentation) + expressionValue + NEW_LINE : String.valueOf(expressionValue) + NEW_LINE;
            this.lastLineOfLastStatement = EMPTY_RESULT;
        } else {
            res = this.lastLineOfLastStatement.isEmpty() ? String.valueOf(indentation) + expressionValue : expressionValue;
            int lastIndexOfNewLine = res.lastIndexOf(NEW_LINE);
            this.lastLineOfLastStatement = lastIndexOfNewLine != -1 ? res.substring(res.lastIndexOf(NEW_LINE) + NEW_LINE.length(), res.length()) : res;
        }
        return res;
    }

    @Override
    public Void caseModule(Module module) {
        for (ModuleElement element : module.getModuleElements()) {
            if (!(element instanceof Template) || !((Template)element).isMain()) continue;
            this.environment.pushImport(this.environment.getModuleQualifiedName(module), element);
            this.doSwitch(element);
        }
        return null;
    }

    @Override
    public String caseTemplate(Template template) {
        String res;
        block7: {
            this.pushIndentation(this.lastLineOfLastStatement);
            try {
                String templateText = (String)this.doSwitch(template.getBody());
                if (template.getPost() != null) {
                    HashMap<String, Object> variables = new HashMap<String, Object>(this.peekVariables());
                    variables.put(AcceleoUtil.getTemplateImplicitVariableName(), templateText);
                    this.pushVariables(variables);
                    try {
                        res = this.toString(this.doSwitch(template.getPost()));
                        break block7;
                    }
                    finally {
                        this.popVariables();
                    }
                }
                res = templateText;
            }
            finally {
                this.popIndentation();
            }
        }
        return res;
    }

    @Override
    public Object caseQuery(Query query) {
        Object res = this.doSwitch(query.getBody());
        return res;
    }

    @Override
    public String caseTextStatement(TextStatement textStatement) {
        String res;
        if (textStatement.isNewLineNeeded()) {
            res = this.lastLineOfLastStatement.isEmpty() ? String.valueOf(this.peekIndentation()) + textStatement.getValue() + NEW_LINE : String.valueOf(textStatement.getValue()) + NEW_LINE;
            this.lastLineOfLastStatement = EMPTY_RESULT;
        } else if (this.lastLineOfLastStatement.isEmpty()) {
            this.lastLineOfLastStatement = res = String.valueOf(this.peekIndentation()) + textStatement.getValue();
        } else {
            res = textStatement.getValue();
            this.lastLineOfLastStatement = String.valueOf(this.peekIndentation()) + res;
        }
        return res;
    }

    @Override
    public String caseBlock(Block block) {
        StringBuilder builder = new StringBuilder();
        for (Statement statement : block.getStatements()) {
            builder.append((String)this.doSwitch(statement));
        }
        return builder.toString();
    }

    @Override
    public String caseComment(Comment comment) {
        return EMPTY_RESULT;
    }

    @Override
    public String caseLetStatement(LetStatement letStatement) {
        String res;
        HashMap<String, Object> variables = new HashMap<String, Object>(this.peekVariables());
        for (Binding binding : letStatement.getVariables()) {
            String name = binding.getName();
            Object value = this.doSwitch(binding.getInitExpression());
            variables.put(name, value);
        }
        this.pushVariables(variables);
        this.pushIndentation(this.lastLineOfLastStatement);
        try {
            res = (String)this.doSwitch(letStatement.getBody());
        }
        finally {
            this.popIndentation();
            this.popVariables();
        }
        return res;
    }

    @Override
    public String caseFileStatement(FileStatement fileStatement) {
        String res;
        Object uriObject = this.doSwitch(fileStatement.getUrl());
        if (uriObject == null) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, ID, 0, "The URL can't be null", new Object[]{fileStatement.getUrl(), new HashMap<String, Object>(this.peekVariables())});
            this.environment.getGenerationResult().addDiagnostic((Diagnostic)diagnostic);
            res = EMPTY_RESULT;
        } else {
            OpenModeKind mode = fileStatement.getMode();
            Charset charset = this.getCharset(fileStatement);
            URI uri = URI.createURI((String)this.toString(uriObject), (boolean)true).resolve(this.environment.getDestination());
            try {
                this.environment.openWriter(uri, mode, charset, NEW_LINE);
                this.lastLineOfLastStatement = EMPTY_RESULT;
                this.pushIndentation(this.lastLineOfLastStatement);
                try {
                    String content = (String)this.doSwitch(fileStatement.getBody());
                    this.environment.write(content);
                }
                finally {
                    this.popIndentation();
                    this.environment.closeWriter();
                }
            }
            catch (IOException e) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, ID, 0, e.getMessage(), new Object[]{fileStatement, new HashMap<String, Object>(this.peekVariables())});
                this.environment.getGenerationResult().addDiagnostic((Diagnostic)diagnostic);
            }
            res = EMPTY_RESULT;
        }
        return res;
    }

    private Charset getCharset(FileStatement fileStatement) {
        Charset charset;
        if (fileStatement.getCharset() != null) {
            Object charsetValue = this.doSwitch(fileStatement.getCharset());
            if (charsetValue != null) {
                String charsetString = this.toString(charsetValue);
                Charset defaultCharset = StandardCharsets.UTF_8;
                try {
                    defaultCharset = Charset.forName(charsetString);
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                    BasicDiagnostic diagnostic = new BasicDiagnostic(2, ID, 0, String.valueOf(e.getMessage()) + " fallback to UTF-8", new Object[]{fileStatement.getUrl(), new HashMap<String, Object>(this.peekVariables())});
                    this.environment.getGenerationResult().addDiagnostic((Diagnostic)diagnostic);
                }
                charset = defaultCharset;
            } else {
                BasicDiagnostic diagnostic = new BasicDiagnostic(2, ID, 0, "The Charset can't be null, fallback to UTF-8", new Object[]{fileStatement.getUrl(), new HashMap<String, Object>(this.peekVariables())});
                this.environment.getGenerationResult().addDiagnostic((Diagnostic)diagnostic);
                charset = StandardCharsets.UTF_8;
            }
        } else {
            charset = StandardCharsets.UTF_8;
        }
        return charset;
    }

    @Override
    public String caseIfStatement(IfStatement ifStatement) {
        String res;
        Object condition = this.doSwitch(ifStatement.getCondition());
        if (condition instanceof Boolean) {
            this.pushIndentation(this.lastLineOfLastStatement);
            try {
                if (Boolean.TRUE.equals(condition)) {
                    res = (String)this.doSwitch(ifStatement.getThen());
                }
                if (ifStatement.getElse() != null) {
                    res = (String)this.doSwitch(ifStatement.getElse());
                }
                res = EMPTY_RESULT;
            }
            finally {
                this.popIndentation();
            }
        } else {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, ID, 0, "The expression must be evaluated to a boolean not: " + this.toString(condition), new Object[]{ifStatement.getCondition(), new HashMap<String, Object>(this.peekVariables())});
            this.environment.getGenerationResult().addDiagnostic((Diagnostic)diagnostic);
            res = EMPTY_RESULT;
        }
        return res;
    }

    @Override
    public String caseForStatement(ForStatement forStatement) {
        StringBuilder builder = new StringBuilder();
        ArrayList<Object> iteration = new ArrayList<Object>();
        Object value = this.doSwitch(forStatement.getBinding().getInitExpression());
        if (value instanceof Collection) {
            iteration.addAll((Collection)value);
        } else if (value != null) {
            iteration.add(value);
        } else {
            BasicDiagnostic diagnostic = new BasicDiagnostic(2, ID, 0, "The expression should not be null", new Object[]{forStatement.getBinding().getInitExpression(), new HashMap<String, Object>(this.peekVariables())});
            this.environment.getGenerationResult().addDiagnostic((Diagnostic)diagnostic);
        }
        if (!iteration.isEmpty()) {
            HashMap<String, Object> variables = new HashMap<String, Object>(this.peekVariables());
            String name = forStatement.getBinding().getName();
            this.pushVariables(variables);
            this.pushIndentation(this.lastLineOfLastStatement);
            try {
                Object firstValue = iteration.remove(0);
                variables.put(name, firstValue);
                builder.append(this.doSwitch(forStatement.getBody()));
                for (Object e : iteration) {
                    variables.put(name, e);
                    if (forStatement.getSeparator() != null) {
                        builder.append(this.toString(this.doSwitch(forStatement.getSeparator())));
                    }
                    builder.append(this.doSwitch(forStatement.getBody()));
                }
            }
            finally {
                this.popIndentation();
                this.popVariables();
            }
        }
        return builder.toString();
    }

    @Override
    public Object caseProtectedArea(ProtectedArea object) {
        return super.caseProtectedArea(object);
    }

    @Override
    public Object caseError(Error error) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(4, ID, 0, "Acceleo parsing error see validation for more details", new Object[]{error});
        this.environment.getGenerationResult().addDiagnostic((Diagnostic)diagnostic);
        return EMPTY_RESULT;
    }

    private String toString(Object object) {
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Collection) {
            Iterator childrenIterator = ((Collection)object).iterator();
            while (childrenIterator.hasNext()) {
                buffer.append(this.toString(childrenIterator.next()));
            }
        } else if (object != null) {
            buffer.append(object.toString());
        }
        return buffer.toString();
    }
}

