/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.debug.event.model;

import org.eclipse.acceleo.debug.event.IDSLDebugEvent;
import org.eclipse.acceleo.debug.event.IDSLDebugEventProcessor;
import org.eclipse.acceleo.debug.event.debugger.BreakpointReply;
import org.eclipse.acceleo.debug.event.debugger.DeleteVariableReply;
import org.eclipse.acceleo.debug.event.debugger.ResumingReply;
import org.eclipse.acceleo.debug.event.debugger.SetCurrentInstructionReply;
import org.eclipse.acceleo.debug.event.debugger.SetVariableValueReply;
import org.eclipse.acceleo.debug.event.debugger.SpawnRunningThreadReply;
import org.eclipse.acceleo.debug.event.debugger.StepIntoResumingReply;
import org.eclipse.acceleo.debug.event.debugger.StepOverResumingReply;
import org.eclipse.acceleo.debug.event.debugger.StepReturnResumingReply;
import org.eclipse.acceleo.debug.event.debugger.SteppedReply;
import org.eclipse.acceleo.debug.event.debugger.SuspendedReply;
import org.eclipse.acceleo.debug.event.debugger.TerminatedReply;
import org.eclipse.acceleo.debug.event.debugger.VariableReply;

public abstract class AbstractModelEventProcessor
implements IDSLDebugEventProcessor {
    public Object handleEvent(IDSLDebugEvent event) {
        Object res = null;
        if (event instanceof SuspendedReply) {
            this.handleSuspendReply((SuspendedReply)event);
        } else if (event instanceof TerminatedReply) {
            this.handleTerminatedReply((TerminatedReply)event);
        } else if (event instanceof SpawnRunningThreadReply) {
            this.notifyClientSpawnRunningThreadReply((SpawnRunningThreadReply)event);
        } else if (event instanceof ResumingReply) {
            this.handleResumingReply((ResumingReply)event);
        } else if (event instanceof VariableReply) {
            this.notifyClientVariableReply((VariableReply)event);
        } else if (event instanceof DeleteVariableReply) {
            this.notifyClientDeleteVariableReply((DeleteVariableReply)event);
        } else if (event instanceof SetCurrentInstructionReply) {
            this.notifyClientSetCurrentInstructionReply((SetCurrentInstructionReply)event);
        } else if (event instanceof SetVariableValueReply) {
            this.notifyClientSetVariableValueReply((SetVariableValueReply)event);
        }
        return res;
    }

    protected abstract void notifyClientSetVariableValueReply(SetVariableValueReply var1);

    protected abstract void notifyClientSetCurrentInstructionReply(SetCurrentInstructionReply var1);

    protected abstract void notifyClientDeleteVariableReply(DeleteVariableReply var1);

    protected abstract void notifyClientVariableReply(VariableReply var1);

    private void handleResumingReply(ResumingReply resumingReply) {
        if (resumingReply instanceof StepIntoResumingReply) {
            this.notifyClientStepIntoResumingReply((StepIntoResumingReply)resumingReply);
        } else if (resumingReply instanceof StepOverResumingReply) {
            this.notifyClientStepOverResumingReply((StepOverResumingReply)resumingReply);
        } else if (resumingReply instanceof StepReturnResumingReply) {
            this.notifyClientStepReturnResumingReply((StepReturnResumingReply)resumingReply);
        } else {
            this.notifyClientResumedReply(resumingReply);
        }
    }

    protected abstract void notifyClientStepIntoResumingReply(StepIntoResumingReply var1);

    protected abstract void notifyClientStepOverResumingReply(StepOverResumingReply var1);

    protected abstract void notifyClientStepReturnResumingReply(StepReturnResumingReply var1);

    protected abstract void notifyClientResumedReply(ResumingReply var1);

    protected abstract void notifyClientSpawnRunningThreadReply(SpawnRunningThreadReply var1);

    private void handleTerminatedReply(TerminatedReply terminatedReply) {
        this.notifyClientTerminatedReply(terminatedReply);
    }

    protected abstract void notifyClientTerminatedReply(TerminatedReply var1);

    private void handleSuspendReply(SuspendedReply suspendReply) {
        if (suspendReply instanceof SteppedReply) {
            this.notifyClientSteppedReply((SteppedReply)suspendReply);
        } else if (suspendReply instanceof BreakpointReply) {
            this.notifyClientBreakpointReply((BreakpointReply)suspendReply);
        } else {
            this.notifyClientSuspendedReply(suspendReply);
        }
    }

    protected abstract void notifyClientSteppedReply(SteppedReply var1);

    protected abstract void notifyClientBreakpointReply(BreakpointReply var1);

    protected abstract void notifyClientSuspendedReply(SuspendedReply var1);
}

