/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.textdocument;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.completion.AcceleoCompletor;
import org.eclipse.acceleo.aql.location.common.AbstractLocationLink;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerPositionUtils;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerServicesUtils;
import org.eclipse.acceleo.aql.ls.services.exceptions.LanguageServerProtocolException;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoLocationLinkResolver;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.outline.AcceleoOutliner;
import org.eclipse.acceleo.aql.parser.AcceleoAstUtils;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.TextDocumentService;

public class AcceleoTextDocumentService
implements TextDocumentService,
LanguageClientAware {
    private final Map<URI, AcceleoTextDocument> openedDocumentsIndex = new HashMap<URI, AcceleoTextDocument>();
    private final AcceleoLocationLinkResolver acceleoLocationLinkResolver = new AcceleoLocationLinkResolver(this);
    private final AcceleoLanguageServer server;
    private LanguageClient languageClient;

    public AcceleoTextDocumentService(AcceleoLanguageServer acceleoLanguageServer) {
        this.server = Objects.requireNonNull(acceleoLanguageServer);
    }

    public void connect(LanguageClient newLanguageClient) {
        this.languageClient = newLanguageClient;
        this.openedDocumentsIndex.clear();
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        URI openedDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument openedAcceleoTextDocument = this.server.getWorkspace().getTextDocument(openedDocumentUri);
        if (openedAcceleoTextDocument == null) {
            throw new IllegalStateException("Could not find the Acceleo Text Document at URI " + openedDocumentUri);
        }
        this.openedDocumentsIndex.put(openedDocumentUri, openedAcceleoTextDocument);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        URI changedDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        this.checkDocumentIsOpened(changedDocumentUri);
        List textDocumentContentchangeEvents = params.getContentChanges();
        AcceleoTextDocument changedAcceleoTextDocument = this.server.getWorkspace().getTextDocument(changedDocumentUri);
        changedAcceleoTextDocument.applyChanges(textDocumentContentchangeEvents);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        URI closedDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        this.checkDocumentIsOpened(closedDocumentUri);
        this.openedDocumentsIndex.remove(closedDocumentUri);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        URI savedDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument savedTextDocument = this.server.getWorkspace().getTextDocument(savedDocumentUri);
        savedTextDocument.documentSaved();
    }

    public void publishValidationResults(AcceleoTextDocument acceleoTextDocument) {
        if (this.languageClient != null) {
            IAcceleoValidationResult validationResults = acceleoTextDocument.getAcceleoValidationResults();
            List<Diagnostic> diagnosticsToPublish = AcceleoLanguageServerServicesUtils.transform(validationResults, acceleoTextDocument.getContents());
            this.languageClient.publishDiagnostics(new PublishDiagnosticsParams(acceleoTextDocument.getUri().toString(), diagnosticsToPublish));
        }
    }

    public AcceleoTextDocument findTextDocumentDefining(Module definedModule) {
        AcceleoTextDocument definingTextDocument = null;
        List<AcceleoTextDocument> allTextDocuments = this.server.getWorkspace().getAllTextDocuments();
        for (AcceleoTextDocument candidate : allTextDocuments) {
            if (!AcceleoTextDocumentService.documentDefinesModule(candidate, definedModule)) continue;
            definingTextDocument = candidate;
            break;
        }
        return definingTextDocument;
    }

    private static boolean documentDefinesModule(AcceleoTextDocument acceleoTextDocument, Module definedModule) {
        return AcceleoAstUtils.isEqualStructurally((ASTNode)acceleoTextDocument.getAcceleoAstResult().getModule(), (ASTNode)definedModule);
    }

    protected void checkDocumentIsOpened(URI documentUri) {
        if (!this.openedDocumentsIndex.containsKey(documentUri)) {
            throw new LanguageServerProtocolException("Received a notification for document \"" + documentUri + "\" but it has not previously been opened. This should never happen.");
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        this.checkDocumentIsOpened(textDocumentUri);
        AcceleoTextDocument acceleoTextDocument = this.openedDocumentsIndex.get(textDocumentUri);
        Position position = params.getPosition();
        return AcceleoTextDocumentService.completion(acceleoTextDocument, position);
    }

    private static CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(AcceleoTextDocument acceleoTextDocument, Position position) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            AcceleoCompletor acceleoCompletor = new AcceleoCompletor();
            IAcceleoEnvironment acceleoEnvironment = acceleoTextDocument.getAcceleoEnvironment();
            String source = acceleoTextDocument.getContents();
            int atIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(position, source);
            List completionProposals = acceleoCompletor.getProposals(acceleoEnvironment, acceleoTextDocument.getFileNameWithoutExtension(), source, atIndex);
            canceler.checkCanceled();
            List<CompletionItem> completionItems = AcceleoLanguageServerServicesUtils.transform(completionProposals);
            canceler.checkCanceled();
            return Either.forLeft(completionItems);
        });
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            return unresolved;
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> declaration(TextDocumentPositionParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        this.checkDocumentIsOpened(textDocumentUri);
        AcceleoTextDocument acceleoTextDocument = this.openedDocumentsIndex.get(textDocumentUri);
        Position position = params.getPosition();
        return this.declaration(acceleoTextDocument, position);
    }

    private CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> declaration(AcceleoTextDocument acceleoTextDocument, Position position) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            int atIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(position, acceleoTextDocument.getContents());
            List<AbstractLocationLink<?, ?>> declarationLocations = acceleoTextDocument.getDeclarationLocations(atIndex);
            canceler.checkCanceled();
            List locationLinks = declarationLocations.stream().map(this.acceleoLocationLinkResolver::transform).collect(Collectors.toList());
            canceler.checkCanceled();
            return Either.forRight(locationLinks);
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(TextDocumentPositionParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        this.checkDocumentIsOpened(textDocumentUri);
        AcceleoTextDocument acceleoTextDocument = this.openedDocumentsIndex.get(textDocumentUri);
        Position position = params.getPosition();
        return this.definition(acceleoTextDocument, position);
    }

    private CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(AcceleoTextDocument acceleoTextDocument, Position position) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            int atIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(position, acceleoTextDocument.getContents());
            List<AbstractLocationLink<?, ?>> definitionLocations = acceleoTextDocument.getDefinitionLocations(atIndex);
            canceler.checkCanceled();
            List locationLinks = definitionLocations.stream().map(this.acceleoLocationLinkResolver::transform).collect(Collectors.toList());
            canceler.checkCanceled();
            return Either.forRight(locationLinks);
        });
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        this.checkDocumentIsOpened(textDocumentUri);
        AcceleoTextDocument acceleoTextDocument = this.openedDocumentsIndex.get(textDocumentUri);
        return AcceleoTextDocumentService.documentSymbol(acceleoTextDocument);
    }

    private static CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(AcceleoTextDocument acceleoTextDocument) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            List<Object> documentSymbols = new ArrayList();
            if (acceleoTextDocument.getAcceleoValidationResults() != null) {
                AcceleoOutliner acceleoOutliner = new AcceleoOutliner();
                List acceleoSymbols = acceleoOutliner.getAllDeclaredSymbols(acceleoTextDocument.getAcceleoValidationResults());
                canceler.checkCanceled();
                documentSymbols = acceleoSymbols.stream().map(acceleoSymbol -> AcceleoLanguageServerServicesUtils.transform(acceleoSymbol, acceleoTextDocument.getContents())).map(Either::forRight).collect(Collectors.toList());
            }
            canceler.checkCanceled();
            return documentSymbols;
        });
    }
}

