/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;

public class AQLUtilsTests {
    @Test
    public void computeAvailableTypesNullURIsFalseFalseFalse() {
        List res = AQLUtils.computeAvailableTypes(null, (boolean)false, (boolean)false, (boolean)false);
        Assert.assertEquals((long)0L, (long)res.size());
    }

    @Test
    public void computeAvailableTypesNullURIsFalseFalseTrue() {
        List res = AQLUtils.computeAvailableTypes(null, (boolean)false, (boolean)false, (boolean)true);
        Assert.assertEquals((long)0L, (long)res.size());
    }

    @Test
    public void computeAvailableTypesNullURIsFalseTrueTrue() {
        List res = AQLUtils.computeAvailableTypes(null, (boolean)false, (boolean)true, (boolean)true);
        Assert.assertEquals((long)0L, (long)res.size());
    }

    @Test
    public void computeAvailableTypesNullURIsTrueTrueTrue() {
        List res = AQLUtils.computeAvailableTypes(null, (boolean)true, (boolean)true, (boolean)true);
        Assert.assertEquals((long)12L, (long)res.size());
        Assert.assertEquals((Object)"Boolean", res.get(0));
        Assert.assertEquals((Object)"Integer", res.get(1));
        Assert.assertEquals((Object)"OrderedSet(Boolean)", res.get(2));
        Assert.assertEquals((Object)"OrderedSet(Integer)", res.get(3));
        Assert.assertEquals((Object)"OrderedSet(Real)", res.get(4));
        Assert.assertEquals((Object)"OrderedSet(String)", res.get(5));
        Assert.assertEquals((Object)"Real", res.get(6));
        Assert.assertEquals((Object)"Sequence(Boolean)", res.get(7));
        Assert.assertEquals((Object)"Sequence(Integer)", res.get(8));
        Assert.assertEquals((Object)"Sequence(Real)", res.get(9));
        Assert.assertEquals((Object)"Sequence(String)", res.get(10));
        Assert.assertEquals((Object)"String", res.get(11));
    }

    @Test
    public void computeAvailableTypesNullURIsTrueTrueFalse() {
        List res = AQLUtils.computeAvailableTypes(null, (boolean)true, (boolean)true, (boolean)false);
        Assert.assertEquals((long)8L, (long)res.size());
        Assert.assertEquals((Object)"Boolean", res.get(0));
        Assert.assertEquals((Object)"Integer", res.get(1));
        Assert.assertEquals((Object)"Real", res.get(2));
        Assert.assertEquals((Object)"Sequence(Boolean)", res.get(3));
        Assert.assertEquals((Object)"Sequence(Integer)", res.get(4));
        Assert.assertEquals((Object)"Sequence(Real)", res.get(5));
        Assert.assertEquals((Object)"Sequence(String)", res.get(6));
        Assert.assertEquals((Object)"String", res.get(7));
    }

    @Test
    public void computeAvailableTypesNullURIsTrueFalseTrue() {
        List res = AQLUtils.computeAvailableTypes(null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((long)8L, (long)res.size());
        Assert.assertEquals((Object)"Boolean", res.get(0));
        Assert.assertEquals((Object)"Integer", res.get(1));
        Assert.assertEquals((Object)"OrderedSet(Boolean)", res.get(2));
        Assert.assertEquals((Object)"OrderedSet(Integer)", res.get(3));
        Assert.assertEquals((Object)"OrderedSet(Real)", res.get(4));
        Assert.assertEquals((Object)"OrderedSet(String)", res.get(5));
        Assert.assertEquals((Object)"Real", res.get(6));
        Assert.assertEquals((Object)"String", res.get(7));
    }

    @Test
    public void computeAvailableTypesEmptyURIsFalseFalseFalse() {
        ArrayList uris = new ArrayList();
        List res = AQLUtils.computeAvailableTypes(uris, (boolean)false, (boolean)false, (boolean)false);
        Assert.assertEquals((long)0L, (long)res.size());
    }

    @Test
    public void computeAvailableTypesEmptyURIsFalseFalseTrue() {
        ArrayList uris = new ArrayList();
        List res = AQLUtils.computeAvailableTypes(uris, (boolean)false, (boolean)false, (boolean)true);
        Assert.assertEquals((long)0L, (long)res.size());
    }

    @Test
    public void computeAvailableTypesEmptyURIsFalseTrueTrue() {
        ArrayList uris = new ArrayList();
        List res = AQLUtils.computeAvailableTypes(uris, (boolean)false, (boolean)true, (boolean)true);
        Assert.assertEquals((long)0L, (long)res.size());
    }

    @Test
    public void computeAvailableTypesEmptyURIsTrueTrueTrue() {
        ArrayList uris = new ArrayList();
        List res = AQLUtils.computeAvailableTypes(uris, (boolean)true, (boolean)true, (boolean)true);
        Assert.assertEquals((long)12L, (long)res.size());
        Assert.assertEquals((Object)"Boolean", res.get(0));
        Assert.assertEquals((Object)"Integer", res.get(1));
        Assert.assertEquals((Object)"OrderedSet(Boolean)", res.get(2));
        Assert.assertEquals((Object)"OrderedSet(Integer)", res.get(3));
        Assert.assertEquals((Object)"OrderedSet(Real)", res.get(4));
        Assert.assertEquals((Object)"OrderedSet(String)", res.get(5));
        Assert.assertEquals((Object)"Real", res.get(6));
        Assert.assertEquals((Object)"Sequence(Boolean)", res.get(7));
        Assert.assertEquals((Object)"Sequence(Integer)", res.get(8));
        Assert.assertEquals((Object)"Sequence(Real)", res.get(9));
        Assert.assertEquals((Object)"Sequence(String)", res.get(10));
        Assert.assertEquals((Object)"String", res.get(11));
    }

    @Test
    public void computeAvailableTypesEmptyURIsTrueTrueFalse() {
        ArrayList uris = new ArrayList();
        List res = AQLUtils.computeAvailableTypes(uris, (boolean)true, (boolean)true, (boolean)false);
        Assert.assertEquals((long)8L, (long)res.size());
        Assert.assertEquals((Object)"Boolean", res.get(0));
        Assert.assertEquals((Object)"Integer", res.get(1));
        Assert.assertEquals((Object)"Real", res.get(2));
        Assert.assertEquals((Object)"Sequence(Boolean)", res.get(3));
        Assert.assertEquals((Object)"Sequence(Integer)", res.get(4));
        Assert.assertEquals((Object)"Sequence(Real)", res.get(5));
        Assert.assertEquals((Object)"Sequence(String)", res.get(6));
        Assert.assertEquals((Object)"String", res.get(7));
    }

    @Test
    public void computeAvailableTypesEmptyURIsTrueFalseTrue() {
        ArrayList uris = new ArrayList();
        List res = AQLUtils.computeAvailableTypes(uris, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((long)8L, (long)res.size());
        Assert.assertEquals((Object)"Boolean", res.get(0));
        Assert.assertEquals((Object)"Integer", res.get(1));
        Assert.assertEquals((Object)"OrderedSet(Boolean)", res.get(2));
        Assert.assertEquals((Object)"OrderedSet(Integer)", res.get(3));
        Assert.assertEquals((Object)"OrderedSet(Real)", res.get(4));
        Assert.assertEquals((Object)"OrderedSet(String)", res.get(5));
        Assert.assertEquals((Object)"Real", res.get(6));
        Assert.assertEquals((Object)"String", res.get(7));
    }

    @Test
    public void computeAvailableTypesURIsFalseFalseFalse() {
        ArrayList<String> uris = new ArrayList<String>();
        uris.add(EcorePackage.eINSTANCE.getNsURI());
        List res = AQLUtils.computeAvailableTypes(uris, (boolean)false, (boolean)false, (boolean)false);
        Assert.assertEquals((long)53L, (long)res.size());
        Assert.assertEquals((Object)"ecore::EAnnotation", res.get(0));
        Assert.assertEquals((Object)"ecore::EAttribute", res.get(1));
        Assert.assertEquals((Object)"ecore::EBigDecimal", res.get(2));
        Assert.assertEquals((Object)"ecore::EBigInteger", res.get(3));
        Assert.assertEquals((Object)"ecore::EBoolean", res.get(4));
        Assert.assertEquals((Object)"ecore::EBooleanObject", res.get(5));
        Assert.assertEquals((Object)"ecore::EByte", res.get(6));
        Assert.assertEquals((Object)"ecore::EByteArray", res.get(7));
        Assert.assertEquals((Object)"ecore::EByteObject", res.get(8));
        Assert.assertEquals((Object)"ecore::EChar", res.get(9));
        Assert.assertEquals((Object)"ecore::ECharacterObject", res.get(10));
        Assert.assertEquals((Object)"ecore::EClass", res.get(11));
        Assert.assertEquals((Object)"ecore::EClassifier", res.get(12));
        Assert.assertEquals((Object)"ecore::EDataType", res.get(13));
        Assert.assertEquals((Object)"ecore::EDate", res.get(14));
        Assert.assertEquals((Object)"ecore::EDiagnosticChain", res.get(15));
        Assert.assertEquals((Object)"ecore::EDouble", res.get(16));
        Assert.assertEquals((Object)"ecore::EDoubleObject", res.get(17));
        Assert.assertEquals((Object)"ecore::EEList", res.get(18));
        Assert.assertEquals((Object)"ecore::EEnum", res.get(19));
        Assert.assertEquals((Object)"ecore::EEnumLiteral", res.get(20));
        Assert.assertEquals((Object)"ecore::EEnumerator", res.get(21));
        Assert.assertEquals((Object)"ecore::EFactory", res.get(22));
        Assert.assertEquals((Object)"ecore::EFeatureMap", res.get(23));
        Assert.assertEquals((Object)"ecore::EFeatureMapEntry", res.get(24));
        Assert.assertEquals((Object)"ecore::EFloat", res.get(25));
        Assert.assertEquals((Object)"ecore::EFloatObject", res.get(26));
        Assert.assertEquals((Object)"ecore::EGenericType", res.get(27));
        Assert.assertEquals((Object)"ecore::EInt", res.get(28));
        Assert.assertEquals((Object)"ecore::EIntegerObject", res.get(29));
        Assert.assertEquals((Object)"ecore::EInvocationTargetException", res.get(30));
        Assert.assertEquals((Object)"ecore::EJavaClass", res.get(31));
        Assert.assertEquals((Object)"ecore::EJavaObject", res.get(32));
        Assert.assertEquals((Object)"ecore::ELong", res.get(33));
        Assert.assertEquals((Object)"ecore::ELongObject", res.get(34));
        Assert.assertEquals((Object)"ecore::EMap", res.get(35));
        Assert.assertEquals((Object)"ecore::EModelElement", res.get(36));
        Assert.assertEquals((Object)"ecore::ENamedElement", res.get(37));
        Assert.assertEquals((Object)"ecore::EObject", res.get(38));
        Assert.assertEquals((Object)"ecore::EOperation", res.get(39));
        Assert.assertEquals((Object)"ecore::EPackage", res.get(40));
        Assert.assertEquals((Object)"ecore::EParameter", res.get(41));
        Assert.assertEquals((Object)"ecore::EReference", res.get(42));
        Assert.assertEquals((Object)"ecore::EResource", res.get(43));
        Assert.assertEquals((Object)"ecore::EResourceSet", res.get(44));
        Assert.assertEquals((Object)"ecore::EShort", res.get(45));
        Assert.assertEquals((Object)"ecore::EShortObject", res.get(46));
        Assert.assertEquals((Object)"ecore::EString", res.get(47));
        Assert.assertEquals((Object)"ecore::EStringToStringMapEntry", res.get(48));
        Assert.assertEquals((Object)"ecore::EStructuralFeature", res.get(49));
        Assert.assertEquals((Object)"ecore::ETreeIterator", res.get(50));
        Assert.assertEquals((Object)"ecore::ETypeParameter", res.get(51));
        Assert.assertEquals((Object)"ecore::ETypedElement", res.get(52));
    }

    @Test
    public void computeAvailableTypesURIsTrueTrueTrue() {
        ArrayList<String> uris = new ArrayList<String>();
        uris.add(EcorePackage.eINSTANCE.getNsURI());
        List res = AQLUtils.computeAvailableTypes(uris, (boolean)true, (boolean)true, (boolean)true);
        Assert.assertEquals((long)171L, (long)res.size());
        Assert.assertEquals((Object)"Boolean", res.get(0));
        Assert.assertEquals((Object)"Integer", res.get(1));
        Assert.assertEquals((Object)"OrderedSet(Boolean)", res.get(2));
        Assert.assertEquals((Object)"OrderedSet(Integer)", res.get(3));
        Assert.assertEquals((Object)"OrderedSet(Real)", res.get(4));
        Assert.assertEquals((Object)"OrderedSet(String)", res.get(5));
        Assert.assertEquals((Object)"OrderedSet(ecore::EAnnotation)", res.get(6));
        Assert.assertEquals((Object)"OrderedSet(ecore::EAttribute)", res.get(7));
        Assert.assertEquals((Object)"OrderedSet(ecore::EBigDecimal)", res.get(8));
        Assert.assertEquals((Object)"OrderedSet(ecore::EBigInteger)", res.get(9));
        Assert.assertEquals((Object)"OrderedSet(ecore::EBoolean)", res.get(10));
        Assert.assertEquals((Object)"OrderedSet(ecore::EBooleanObject)", res.get(11));
        Assert.assertEquals((Object)"OrderedSet(ecore::EByte)", res.get(12));
        Assert.assertEquals((Object)"OrderedSet(ecore::EByteArray)", res.get(13));
        Assert.assertEquals((Object)"OrderedSet(ecore::EByteObject)", res.get(14));
        Assert.assertEquals((Object)"OrderedSet(ecore::EChar)", res.get(15));
        Assert.assertEquals((Object)"OrderedSet(ecore::ECharacterObject)", res.get(16));
        Assert.assertEquals((Object)"OrderedSet(ecore::EClass)", res.get(17));
        Assert.assertEquals((Object)"OrderedSet(ecore::EClassifier)", res.get(18));
        Assert.assertEquals((Object)"OrderedSet(ecore::EDataType)", res.get(19));
        Assert.assertEquals((Object)"OrderedSet(ecore::EDate)", res.get(20));
        Assert.assertEquals((Object)"OrderedSet(ecore::EDiagnosticChain)", res.get(21));
        Assert.assertEquals((Object)"OrderedSet(ecore::EDouble)", res.get(22));
        Assert.assertEquals((Object)"OrderedSet(ecore::EDoubleObject)", res.get(23));
        Assert.assertEquals((Object)"OrderedSet(ecore::EEList)", res.get(24));
        Assert.assertEquals((Object)"OrderedSet(ecore::EEnum)", res.get(25));
        Assert.assertEquals((Object)"OrderedSet(ecore::EEnumLiteral)", res.get(26));
        Assert.assertEquals((Object)"OrderedSet(ecore::EEnumerator)", res.get(27));
        Assert.assertEquals((Object)"OrderedSet(ecore::EFactory)", res.get(28));
        Assert.assertEquals((Object)"OrderedSet(ecore::EFeatureMap)", res.get(29));
        Assert.assertEquals((Object)"OrderedSet(ecore::EFeatureMapEntry)", res.get(30));
        Assert.assertEquals((Object)"OrderedSet(ecore::EFloat)", res.get(31));
        Assert.assertEquals((Object)"OrderedSet(ecore::EFloatObject)", res.get(32));
        Assert.assertEquals((Object)"OrderedSet(ecore::EGenericType)", res.get(33));
        Assert.assertEquals((Object)"OrderedSet(ecore::EInt)", res.get(34));
        Assert.assertEquals((Object)"OrderedSet(ecore::EIntegerObject)", res.get(35));
        Assert.assertEquals((Object)"OrderedSet(ecore::EInvocationTargetException)", res.get(36));
        Assert.assertEquals((Object)"OrderedSet(ecore::EJavaClass)", res.get(37));
        Assert.assertEquals((Object)"OrderedSet(ecore::EJavaObject)", res.get(38));
        Assert.assertEquals((Object)"OrderedSet(ecore::ELong)", res.get(39));
        Assert.assertEquals((Object)"OrderedSet(ecore::ELongObject)", res.get(40));
        Assert.assertEquals((Object)"OrderedSet(ecore::EMap)", res.get(41));
        Assert.assertEquals((Object)"OrderedSet(ecore::EModelElement)", res.get(42));
        Assert.assertEquals((Object)"OrderedSet(ecore::ENamedElement)", res.get(43));
        Assert.assertEquals((Object)"OrderedSet(ecore::EObject)", res.get(44));
        Assert.assertEquals((Object)"OrderedSet(ecore::EOperation)", res.get(45));
        Assert.assertEquals((Object)"OrderedSet(ecore::EPackage)", res.get(46));
        Assert.assertEquals((Object)"OrderedSet(ecore::EParameter)", res.get(47));
        Assert.assertEquals((Object)"OrderedSet(ecore::EReference)", res.get(48));
        Assert.assertEquals((Object)"OrderedSet(ecore::EResource)", res.get(49));
        Assert.assertEquals((Object)"OrderedSet(ecore::EResourceSet)", res.get(50));
        Assert.assertEquals((Object)"OrderedSet(ecore::EShort)", res.get(51));
        Assert.assertEquals((Object)"OrderedSet(ecore::EShortObject)", res.get(52));
        Assert.assertEquals((Object)"OrderedSet(ecore::EString)", res.get(53));
        Assert.assertEquals((Object)"OrderedSet(ecore::EStringToStringMapEntry)", res.get(54));
        Assert.assertEquals((Object)"OrderedSet(ecore::EStructuralFeature)", res.get(55));
        Assert.assertEquals((Object)"OrderedSet(ecore::ETreeIterator)", res.get(56));
        Assert.assertEquals((Object)"OrderedSet(ecore::ETypeParameter)", res.get(57));
        Assert.assertEquals((Object)"OrderedSet(ecore::ETypedElement)", res.get(58));
        Assert.assertEquals((Object)"Real", res.get(59));
        Assert.assertEquals((Object)"Sequence(Boolean)", res.get(60));
        Assert.assertEquals((Object)"Sequence(Integer)", res.get(61));
        Assert.assertEquals((Object)"Sequence(Real)", res.get(62));
        Assert.assertEquals((Object)"Sequence(String)", res.get(63));
        Assert.assertEquals((Object)"Sequence(ecore::EAnnotation)", res.get(64));
        Assert.assertEquals((Object)"Sequence(ecore::EAttribute)", res.get(65));
        Assert.assertEquals((Object)"Sequence(ecore::EBigDecimal)", res.get(66));
        Assert.assertEquals((Object)"Sequence(ecore::EBigInteger)", res.get(67));
        Assert.assertEquals((Object)"Sequence(ecore::EBoolean)", res.get(68));
        Assert.assertEquals((Object)"Sequence(ecore::EBooleanObject)", res.get(69));
        Assert.assertEquals((Object)"Sequence(ecore::EByte)", res.get(70));
        Assert.assertEquals((Object)"Sequence(ecore::EByteArray)", res.get(71));
        Assert.assertEquals((Object)"Sequence(ecore::EByteObject)", res.get(72));
        Assert.assertEquals((Object)"Sequence(ecore::EChar)", res.get(73));
        Assert.assertEquals((Object)"Sequence(ecore::ECharacterObject)", res.get(74));
        Assert.assertEquals((Object)"Sequence(ecore::EClass)", res.get(75));
        Assert.assertEquals((Object)"Sequence(ecore::EClassifier)", res.get(76));
        Assert.assertEquals((Object)"Sequence(ecore::EDataType)", res.get(77));
        Assert.assertEquals((Object)"Sequence(ecore::EDate)", res.get(78));
        Assert.assertEquals((Object)"Sequence(ecore::EDiagnosticChain)", res.get(79));
        Assert.assertEquals((Object)"Sequence(ecore::EDouble)", res.get(80));
        Assert.assertEquals((Object)"Sequence(ecore::EDoubleObject)", res.get(81));
        Assert.assertEquals((Object)"Sequence(ecore::EEList)", res.get(82));
        Assert.assertEquals((Object)"Sequence(ecore::EEnum)", res.get(83));
        Assert.assertEquals((Object)"Sequence(ecore::EEnumLiteral)", res.get(84));
        Assert.assertEquals((Object)"Sequence(ecore::EEnumerator)", res.get(85));
        Assert.assertEquals((Object)"Sequence(ecore::EFactory)", res.get(86));
        Assert.assertEquals((Object)"Sequence(ecore::EFeatureMap)", res.get(87));
        Assert.assertEquals((Object)"Sequence(ecore::EFeatureMapEntry)", res.get(88));
        Assert.assertEquals((Object)"Sequence(ecore::EFloat)", res.get(89));
        Assert.assertEquals((Object)"Sequence(ecore::EFloatObject)", res.get(90));
        Assert.assertEquals((Object)"Sequence(ecore::EGenericType)", res.get(91));
        Assert.assertEquals((Object)"Sequence(ecore::EInt)", res.get(92));
        Assert.assertEquals((Object)"Sequence(ecore::EIntegerObject)", res.get(93));
        Assert.assertEquals((Object)"Sequence(ecore::EInvocationTargetException)", res.get(94));
        Assert.assertEquals((Object)"Sequence(ecore::EJavaClass)", res.get(95));
        Assert.assertEquals((Object)"Sequence(ecore::EJavaObject)", res.get(96));
        Assert.assertEquals((Object)"Sequence(ecore::ELong)", res.get(97));
        Assert.assertEquals((Object)"Sequence(ecore::ELongObject)", res.get(98));
        Assert.assertEquals((Object)"Sequence(ecore::EMap)", res.get(99));
        Assert.assertEquals((Object)"Sequence(ecore::EModelElement)", res.get(100));
        Assert.assertEquals((Object)"Sequence(ecore::ENamedElement)", res.get(101));
        Assert.assertEquals((Object)"Sequence(ecore::EObject)", res.get(102));
        Assert.assertEquals((Object)"Sequence(ecore::EOperation)", res.get(103));
        Assert.assertEquals((Object)"Sequence(ecore::EPackage)", res.get(104));
        Assert.assertEquals((Object)"Sequence(ecore::EParameter)", res.get(105));
        Assert.assertEquals((Object)"Sequence(ecore::EReference)", res.get(106));
        Assert.assertEquals((Object)"Sequence(ecore::EResource)", res.get(107));
        Assert.assertEquals((Object)"Sequence(ecore::EResourceSet)", res.get(108));
        Assert.assertEquals((Object)"Sequence(ecore::EShort)", res.get(109));
        Assert.assertEquals((Object)"Sequence(ecore::EShortObject)", res.get(110));
        Assert.assertEquals((Object)"Sequence(ecore::EString)", res.get(111));
        Assert.assertEquals((Object)"Sequence(ecore::EStringToStringMapEntry)", res.get(112));
        Assert.assertEquals((Object)"Sequence(ecore::EStructuralFeature)", res.get(113));
        Assert.assertEquals((Object)"Sequence(ecore::ETreeIterator)", res.get(114));
        Assert.assertEquals((Object)"Sequence(ecore::ETypeParameter)", res.get(115));
        Assert.assertEquals((Object)"Sequence(ecore::ETypedElement)", res.get(116));
        Assert.assertEquals((Object)"String", res.get(117));
        Assert.assertEquals((Object)"ecore::EAnnotation", res.get(118));
        Assert.assertEquals((Object)"ecore::EAttribute", res.get(119));
        Assert.assertEquals((Object)"ecore::EBigDecimal", res.get(120));
        Assert.assertEquals((Object)"ecore::EBigInteger", res.get(121));
        Assert.assertEquals((Object)"ecore::EBoolean", res.get(122));
        Assert.assertEquals((Object)"ecore::EBooleanObject", res.get(123));
        Assert.assertEquals((Object)"ecore::EByte", res.get(124));
        Assert.assertEquals((Object)"ecore::EByteArray", res.get(125));
        Assert.assertEquals((Object)"ecore::EByteObject", res.get(126));
        Assert.assertEquals((Object)"ecore::EChar", res.get(127));
        Assert.assertEquals((Object)"ecore::ECharacterObject", res.get(128));
        Assert.assertEquals((Object)"ecore::EClass", res.get(129));
        Assert.assertEquals((Object)"ecore::EClassifier", res.get(130));
        Assert.assertEquals((Object)"ecore::EDataType", res.get(131));
        Assert.assertEquals((Object)"ecore::EDate", res.get(132));
        Assert.assertEquals((Object)"ecore::EDiagnosticChain", res.get(133));
        Assert.assertEquals((Object)"ecore::EDouble", res.get(134));
        Assert.assertEquals((Object)"ecore::EDoubleObject", res.get(135));
        Assert.assertEquals((Object)"ecore::EEList", res.get(136));
        Assert.assertEquals((Object)"ecore::EEnum", res.get(137));
        Assert.assertEquals((Object)"ecore::EEnumLiteral", res.get(138));
        Assert.assertEquals((Object)"ecore::EEnumerator", res.get(139));
        Assert.assertEquals((Object)"ecore::EFactory", res.get(140));
        Assert.assertEquals((Object)"ecore::EFeatureMap", res.get(141));
        Assert.assertEquals((Object)"ecore::EFeatureMapEntry", res.get(142));
        Assert.assertEquals((Object)"ecore::EFloat", res.get(143));
        Assert.assertEquals((Object)"ecore::EFloatObject", res.get(144));
        Assert.assertEquals((Object)"ecore::EGenericType", res.get(145));
        Assert.assertEquals((Object)"ecore::EInt", res.get(146));
        Assert.assertEquals((Object)"ecore::EIntegerObject", res.get(147));
        Assert.assertEquals((Object)"ecore::EInvocationTargetException", res.get(148));
        Assert.assertEquals((Object)"ecore::EJavaClass", res.get(149));
        Assert.assertEquals((Object)"ecore::EJavaObject", res.get(150));
        Assert.assertEquals((Object)"ecore::ELong", res.get(151));
        Assert.assertEquals((Object)"ecore::ELongObject", res.get(152));
        Assert.assertEquals((Object)"ecore::EMap", res.get(153));
        Assert.assertEquals((Object)"ecore::EModelElement", res.get(154));
        Assert.assertEquals((Object)"ecore::ENamedElement", res.get(155));
        Assert.assertEquals((Object)"ecore::EObject", res.get(156));
        Assert.assertEquals((Object)"ecore::EOperation", res.get(157));
        Assert.assertEquals((Object)"ecore::EPackage", res.get(158));
        Assert.assertEquals((Object)"ecore::EParameter", res.get(159));
        Assert.assertEquals((Object)"ecore::EReference", res.get(160));
        Assert.assertEquals((Object)"ecore::EResource", res.get(161));
        Assert.assertEquals((Object)"ecore::EResourceSet", res.get(162));
        Assert.assertEquals((Object)"ecore::EShort", res.get(163));
        Assert.assertEquals((Object)"ecore::EShortObject", res.get(164));
        Assert.assertEquals((Object)"ecore::EString", res.get(165));
        Assert.assertEquals((Object)"ecore::EStringToStringMapEntry", res.get(166));
        Assert.assertEquals((Object)"ecore::EStructuralFeature", res.get(167));
        Assert.assertEquals((Object)"ecore::ETreeIterator", res.get(168));
        Assert.assertEquals((Object)"ecore::ETypeParameter", res.get(169));
        Assert.assertEquals((Object)"ecore::ETypedElement", res.get(170));
    }

    @Test
    public void getAqlTypeStringNull() {
        String res = AQLUtils.getAqlTypeString(null);
        Assert.assertEquals((Object)"", (Object)res);
    }

    @Test
    public void getAqlTypeStringString() {
        ClassType type = new ClassType(null, String.class);
        String res = AQLUtils.getAqlTypeString((IType)type);
        Assert.assertEquals((Object)"String", (Object)res);
    }

    @Test
    public void getAqlTypeStringInteger() {
        ClassType type = new ClassType(null, Integer.class);
        String res = AQLUtils.getAqlTypeString((IType)type);
        Assert.assertEquals((Object)"Integer", (Object)res);
    }

    @Test
    public void getAqlTypeStringReal() {
        ClassType type = new ClassType(null, Double.class);
        String res = AQLUtils.getAqlTypeString((IType)type);
        Assert.assertEquals((Object)"Real", (Object)res);
    }

    @Test
    public void getAqlTypeStringBoolean() {
        ClassType type = new ClassType(null, Boolean.class);
        String res = AQLUtils.getAqlTypeString((IType)type);
        Assert.assertEquals((Object)"Boolean", (Object)res);
    }

    @Test
    public void getAqlTypeStringEClassifier() {
        EClassifierType type = new EClassifierType(null, (EClassifier)EcorePackage.eINSTANCE.getEPackage());
        String res = AQLUtils.getAqlTypeString((IType)type);
        Assert.assertEquals((Object)"ecore::EPackage", (Object)res);
    }

    @Test
    public void getAqlTypeStringSequence() {
        EClassifierType type = new EClassifierType(null, (EClassifier)EcorePackage.eINSTANCE.getEPackage());
        String res = AQLUtils.getAqlTypeString((IType)new SequenceType(null, (IType)type));
        Assert.assertEquals((Object)"Sequence(ecore::EPackage)", (Object)res);
    }

    @Test
    public void getAqlTypeStringOrderedSet() {
        EClassifierType type = new EClassifierType(null, (EClassifier)EcorePackage.eINSTANCE.getEPackage());
        String res = AQLUtils.getAqlTypeString((IType)new SetType(null, (IType)type));
        Assert.assertEquals((Object)"OrderedSet(ecore::EPackage)", (Object)res);
    }

    @Test
    public void getAqlTypeStringEClassifierSetLiteral() {
        LinkedHashSet<Object> eClassifiers = new LinkedHashSet<Object>();
        eClassifiers.add(EcorePackage.eINSTANCE.getEPackage());
        eClassifiers.add(EcorePackage.eINSTANCE.getEString());
        eClassifiers.add(EcorePackage.eINSTANCE.getEOperation());
        EClassifierSetLiteralType type = new EClassifierSetLiteralType(null, eClassifiers);
        String res = AQLUtils.getAqlTypeString((IType)type);
        Assert.assertEquals((Object)"{ecore::EPackage | ecore::EString | ecore::EOperation}", (Object)res);
    }
}

