/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;

public class AcceleoDynamicMetamodelResourceSetImpl
extends ResourceSetImpl {
    public static final ResourceSet DYNAMIC_METAMODEL_RESOURCE_SET = new AcceleoDynamicMetamodelResourceSetImpl();

    public AcceleoDynamicMetamodelResourceSetImpl() {
        if (this.loadOptions == null) {
            this.loadOptions = new HashMap();
        }
        this.loadOptions.put("URI_HANDLER", new AcceleoDynamicURIHandler());
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        URIConverter converter = this.getURIConverter();
        if (converter != null && EMFPlugin.IS_ECLIPSE_RUNNING) {
            for (Resource resource : this.resources) {
                URI resourceURI = resource.getURI();
                for (Resource resource2 : this.resources) {
                    URI resourceURI2 = resource2.getURI();
                    Path path = new Path(resourceURI.path());
                    Path path2 = new Path(resourceURI2.path());
                    if (resourceURI.path().equals(resourceURI2.path()) || !AcceleoDynamicMetamodelResourceSetImpl.makeRelativeTo((IPath)path2, path.removeLastSegments(1)).toString().equals(uri.toString())) continue;
                    return resource2;
                }
            }
        }
        return super.delegatedGetResource(uri, loadOnDemand);
    }

    public static IPath makeRelativeTo(IPath path1, IPath path2) {
        IPath path = path1;
        if (path1.getDevice() == path2.getDevice() || path1.getDevice() != null && path1.getDevice().equalsIgnoreCase(path2.getDevice())) {
            int commonLength = path1.matchingFirstSegments(path2);
            int differenceLength = path2.segmentCount() - commonLength;
            int newSegmentLength = differenceLength + path1.segmentCount() - commonLength;
            if (newSegmentLength == 0) {
                return Path.EMPTY;
            }
            path = new Path("");
            Object[] newSegments = new String[newSegmentLength];
            Arrays.fill(newSegments, 0, differenceLength, "..");
            System.arraycopy(path1.segments(), commonLength, newSegments, differenceLength, newSegmentLength - differenceLength);
            Object[] objectArray = newSegments;
            int n = newSegments.length;
            int n2 = 0;
            while (n2 < n) {
                Object segment = objectArray[n2];
                path = path.append((IPath)new Path((String)segment));
                ++n2;
            }
        }
        return path;
    }

    public class AcceleoDynamicURIHandler
    extends URIHandlerImpl.PlatformSchemeAware {
        public URI deresolve(URI uri) {
            return super.deresolve(uri);
        }

        public URI resolve(URI uri) {
            Map map = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
            URI trimmedURI = uri.trimFragment();
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                URI dummyValue = (URI)entry.getValue();
                String dummy = dummyValue.toString();
                if (dummy.endsWith("genmodel")) {
                    dummy = dummy.substring(0, dummy.length() - "genmodel".length());
                    dummy = String.valueOf(dummy) + "ecore";
                }
                if (!dummy.equals(trimmedURI.toString())) continue;
                URI newURI = URI.createURI((String)((String)entry.getKey()));
                newURI = newURI.appendFragment(uri.fragment());
                return newURI;
            }
            return super.resolve(uri);
        }
    }
}

