/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.rules;

import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class OCLExpressionRule
implements ISequenceRule {
    private final String[] previousWords;
    private final char endingDelimiter;
    private final IToken token;

    public OCLExpressionRule(String[] previousWords, char endingDelimiter, IToken token) {
        this.previousWords = previousWords;
        this.endingDelimiter = endingDelimiter;
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.read(scanner) > 0) {
            return this.token;
        }
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    @Override
    public int read(ICharacterScanner scanner) {
        int column = scanner.getColumn();
        if (!this.validatePreviousWords(scanner)) {
            return 0;
        }
        assert (scanner.getColumn() == column);
        boolean matchParenthesis = this.endingDelimiter == ')';
        boolean result = true;
        boolean readNext = true;
        int shift = 0;
        int openParenthesis = 0;
        while (result && readNext) {
            int c = scanner.read();
            if (matchParenthesis && c == 40) {
                ++openParenthesis;
            } else if (matchParenthesis && c == 41) {
                if (openParenthesis > 0) {
                    --openParenthesis;
                } else {
                    readNext = false;
                }
            } else if (c == this.endingDelimiter || c == 93 || c == 39 || c == -1) {
                readNext = false;
            }
            if (readNext) {
                ++shift;
                continue;
            }
            scanner.unread();
        }
        if (!result) {
            while (shift > 0) {
                scanner.unread();
                --shift;
            }
        }
        return shift;
    }

    protected boolean validatePreviousWords(ICharacterScanner scanner) {
        boolean valid = true;
        int shift = 0;
        int i = this.previousWords.length - 1;
        while (valid && i >= 0) {
            int n = this.unreadPreviousWord(scanner, this.previousWords[i]);
            if (n == 0) {
                valid = false;
            } else {
                shift += n;
            }
            --i;
        }
        while (shift < 0) {
            scanner.read();
            ++shift;
        }
        return valid;
    }

    private int unreadPreviousWord(ICharacterScanner scanner, String previousWord) {
        assert (previousWord.length() > 0);
        boolean valid = false;
        int shift = 0;
        if (scanner.getColumn() >= previousWord.length()) {
            int c;
            do {
                c = this.unreadChar(scanner);
                --shift;
            } while (Character.isWhitespace(c));
            if ("*".equals(previousWord)) {
                while (Character.isJavaIdentifierPart(c) && scanner.getColumn() > 0) {
                    valid = true;
                    c = this.unreadChar(scanner);
                    --shift;
                }
            } else if (scanner.getColumn() >= previousWord.length() - 1) {
                valid = true;
                int i = previousWord.length() - 1;
                while (valid && i >= 0) {
                    if (previousWord.charAt(i) != c) {
                        valid = false;
                    } else if (i > 0) {
                        c = this.unreadChar(scanner);
                        --shift;
                    }
                    --i;
                }
            }
        }
        if (!valid) {
            while (shift < 0) {
                scanner.read();
                ++shift;
            }
        }
        return shift;
    }

    private int unreadChar(ICharacterScanner scanner) {
        scanner.unread();
        int c = scanner.read();
        scanner.unread();
        return c;
    }
}

