/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.cst.utils;

import org.eclipse.acceleo.internal.parser.cst.utils.ISequence;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.internal.parser.cst.utils.SequenceBlock;

public final class ParserUtils {
    private ParserUtils() {
    }

    public static SequenceBlock createAcceleoSequenceBlock(boolean headerOnly, String name, SequenceBlock[] inhibsHeader, SequenceBlock[] inhibsBody) {
        Sequence beginHeader = new Sequence("[", name);
        Sequence endHeaderOnly = new Sequence("]");
        Sequence endHeaderBody = new Sequence("/", "]");
        Sequence endBody = headerOnly ? null : new Sequence("[", "/", name, "]");
        return new SequenceBlock(beginHeader, endHeaderOnly, endHeaderBody, inhibsHeader, endBody, null, inhibsBody);
    }

    public static int getNextSequence(StringBuffer buffer, int posBegin, int posEnd, ISequence[] pElements, Region[] pElementsPositions) {
        assert (pElements.length == pElementsPositions.length);
        int i = 0;
        while (i < pElements.length) {
            if (pElementsPositions[i].b() != -1 && posBegin > pElementsPositions[i].b()) {
                ISequence pModuleElement = pElements[i];
                pElementsPositions[i] = pModuleElement.search(buffer, posBegin, posEnd);
            }
            ++i;
        }
        int positionMin = posEnd;
        int iPositionMin = -1;
        int i2 = 0;
        while (i2 < pElementsPositions.length) {
            if (pElementsPositions[i2].b() > -1 && pElementsPositions[i2].b() < positionMin) {
                iPositionMin = i2;
                positionMin = pElementsPositions[i2].b();
            }
            ++i2;
        }
        if (iPositionMin > -1 && iPositionMin < pElements.length) {
            return iPositionMin;
        }
        return -1;
    }

    public static int getNextSequence(StringBuffer buffer, int posBegin, int posEnd, ISequence[] pElements, Region[] pElementsPositions, SequenceBlock[] pInhibs, Region[] pInhibsPositions) {
        int currentPosBegin = posBegin;
        while (currentPosBegin > -1 && currentPosBegin < posEnd) {
            int i = ParserUtils.getNextSequence(buffer, currentPosBegin, posEnd, pElements, pElementsPositions);
            int j = ParserUtils.getNextSequence(buffer, currentPosBegin, posEnd, pInhibs, pInhibsPositions);
            if (j == -1 || i == -1 || pElementsPositions[i].b() < pInhibsPositions[j].b()) {
                return i;
            }
            SequenceBlock pInhib = pInhibs[j];
            currentPosBegin = pInhib.searchEndBodyAtBeginHeader(buffer, pInhibsPositions[j], posEnd).e();
        }
        return -1;
    }

    public static int shiftKeyword(StringBuffer buffer, int posBegin, int posEnd, String keyword, boolean wholeWord) {
        return ParserUtils.shiftKeyword(buffer, posBegin, posEnd, keyword, false, wholeWord);
    }

    public static int shiftKeyword(StringBuffer buffer, int posBegin, int posEnd, String keyword, boolean ignoreCase, boolean wholeWord) {
        int e;
        if (keyword == null || keyword.length() == 0) {
            return posBegin;
        }
        int b = posBegin;
        while (b < posEnd && Character.isWhitespace(buffer.charAt(b))) {
            ++b;
        }
        int result = b + keyword.length() <= posEnd ? (!(b == (e = ParserUtils.strictlyReadKeyword(buffer, b, keyword, ignoreCase)) || e != posEnd && wholeWord && Character.isJavaIdentifierStart(buffer.charAt(e))) ? e : posBegin) : posBegin;
        return result;
    }

    private static int strictlyReadKeyword(StringBuffer buffer, int posBegin, String keyword, boolean ignoreCase) {
        int e = posBegin;
        int i = 0;
        while (i < keyword.length()) {
            char bufferChar;
            char keywordChar = keyword.charAt(i);
            if (!ParserUtils.similarCharacters(keywordChar, bufferChar = buffer.charAt(e), ignoreCase)) {
                return posBegin;
            }
            ++e;
            ++i;
        }
        return e;
    }

    private static boolean similarCharacters(char c1, char c2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toUpperCase(c1) == Character.toUpperCase(c2);
        }
        return c1 == c2;
    }

    public static int shiftIdentifier(StringBuffer buffer, int posBegin, int posEnd) {
        int b = posBegin;
        while (b < posEnd && Character.isWhitespace(buffer.charAt(b))) {
            ++b;
        }
        if (b < posEnd && Character.isJavaIdentifierStart(buffer.charAt(b))) {
            int e = b + 1;
            while (e < posEnd && Character.isJavaIdentifierPart(buffer.charAt(e))) {
                ++e;
            }
            return e;
        }
        return posBegin;
    }

    public static boolean isIdentifier(String text) {
        if (text != null && text.length() > 0 && Character.isJavaIdentifierStart(text.charAt(0))) {
            int i = 1;
            while (i < text.length() && Character.isJavaIdentifierPart(text.charAt(i))) {
                ++i;
            }
            return i == text.length();
        }
        return false;
    }
}

