/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.notifications;

import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;

public class AcceleoLogListener
implements ILogListener {
    private static int errors;
    private static int cancels;
    private static int warnings;
    private static int infos;

    public static void resetCounters() {
        errors = 0;
        cancels = 0;
        warnings = 0;
        infos = 0;
    }

    public static int getErrors() {
        return errors;
    }

    public static int getWarnings() {
        return warnings;
    }

    public static int getCancels() {
        return cancels;
    }

    public static int getInfos() {
        return infos;
    }

    public void logging(final IStatus status, final String plugin) {
        if (AcceleoPreferences.areNotificationsEnabled() && !AcceleoPreferences.areNotificationsForcedDisabled()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    AcceleoLogListener.delegateLog(status, plugin);
                }
            });
        }
    }

    private static void delegateLog(IStatus status, String plugin) {
        if (AcceleoPreferences.areNotificationsForcedDisabled() || !AcceleoPreferences.areNotificationsEnabled()) {
            return;
        }
        int severity = status.getSeverity();
        switch (severity) {
            case 8: {
                if (!AcceleoPreferences.areCancelNotificationsEnabled()) break;
                ++cancels;
                break;
            }
            case 2: {
                if (!AcceleoPreferences.areWarningNotificationsEnabled()) break;
                ++warnings;
                break;
            }
            case 4: {
                if (!AcceleoPreferences.areErrorNotificationsEnabled()) break;
                ++errors;
                break;
            }
            case 1: {
                if (!AcceleoPreferences.areInfoNotificationsEnabled()) break;
                ++infos;
                break;
            }
            default: {
                if (!AcceleoPreferences.areErrorNotificationsEnabled()) break;
                ++errors;
            }
        }
    }
}

