/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.model;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.debug.core.ITemplateDebugger;
import org.eclipse.acceleo.internal.ide.ui.debug.core.ITemplateDebuggerListener;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AbstractDebugElement;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoDebugProcess;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoLineBreakpoint;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoThread;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;

public final class AcceleoDebugTarget
extends AbstractDebugElement
implements IDebugTarget,
IBreakpointManagerListener {
    protected AcceleoThread thread;
    private AcceleoDebugProcess process;
    private ILaunch launch;
    private ITemplateDebugger debugger;
    private boolean terminated;
    private ITemplateDebuggerListener debuggerListener;

    public AcceleoDebugTarget(ILaunch aLaunch, ITemplateDebugger aTemplateDebugger) {
        super(null);
        this.launch = aLaunch;
        this.debugger = aTemplateDebugger;
        this.process = new AcceleoDebugProcess(this);
        this.launch.addProcess((IProcess)this.process);
        this.thread = new AcceleoThread(this);
        IBreakpointManager breakpointManager = this.getBreakpointManager();
        breakpointManager.addBreakpointListener((IBreakpointListener)this);
        breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        IBreakpoint[] breakpoints = this.getBreakpointManager().getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof AcceleoLineBreakpoint) {
                AcceleoLineBreakpoint lineBreakpoint = (AcceleoLineBreakpoint)breakpoints[i];
                try {
                    if (lineBreakpoint.isEnabled()) {
                        this.debugger.addBreakpoint(lineBreakpoint.getASTFragment());
                    }
                }
                catch (CoreException e) {
                    AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                }
            }
            ++i;
        }
        this.debuggerListener = new TemplateDebuggerListener();
        this.debugger.addListener(this.debuggerListener);
    }

    public ITemplateDebugger getDebugger() {
        return this.debugger;
    }

    public void stepInto() {
        this.debugger.stepInto();
    }

    public void stepOver() {
        this.debugger.stepOver();
    }

    public void stepReturn() {
        this.debugger.stepReturn();
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getName() throws DebugException {
        return this.process.getLabel();
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() throws DebugException {
        IThread[] ret = this.thread != null ? new IThread[]{this.thread} : new IThread[]{};
        return ret;
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return true;
    }

    public boolean canTerminate() {
        return !this.terminated;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        this.thread = null;
        this.terminated = true;
        this.debugger.terminate();
        this.fireTerminateEvent();
        this.debugger.removeListener(this.debuggerListener);
        IBreakpointManager breakpointManager = this.getBreakpointManager();
        breakpointManager.removeBreakpointListener((IBreakpointListener)this);
        breakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public boolean canResume() {
        return !this.isTerminated();
    }

    public boolean canSuspend() {
        return !this.isTerminated();
    }

    public boolean isSuspended() {
        return !this.isTerminated() && this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.debugger.resume();
    }

    public void suspend() throws DebugException {
        this.debugger.suspend();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (breakpoint instanceof AcceleoLineBreakpoint) {
            AcceleoLineBreakpoint acceleoLineBreakpoint = (AcceleoLineBreakpoint)breakpoint;
            this.debugger.addBreakpoint(acceleoLineBreakpoint.getASTFragment());
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof AcceleoLineBreakpoint) {
            AcceleoLineBreakpoint acceleoLineBreakpoint = (AcceleoLineBreakpoint)breakpoint;
            try {
                if (acceleoLineBreakpoint.isEnabled()) {
                    this.debugger.addBreakpoint(acceleoLineBreakpoint.getASTFragment());
                } else {
                    this.debugger.removeBreakpoint(acceleoLineBreakpoint.getASTFragment());
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof AcceleoLineBreakpoint) {
            AcceleoLineBreakpoint acceleoLineBreakpoint = (AcceleoLineBreakpoint)breakpoint;
            this.debugger.removeBreakpoint(acceleoLineBreakpoint.getASTFragment());
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints = this.getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            if (enabled) {
                this.breakpointAdded(breakpoints[i]);
            } else {
                this.breakpointRemoved(breakpoints[i], null);
            }
            ++i;
        }
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this;
    }

    protected class TemplateDebuggerListener
    implements ITemplateDebuggerListener {
        protected TemplateDebuggerListener() {
        }

        @Override
        public void resumeClient() {
            AcceleoDebugTarget.this.thread.setSuspended(false);
            AcceleoDebugTarget.this.thread.setStepping(false);
            AcceleoDebugTarget.this.thread.fireResumeEvent(32);
        }

        @Override
        public void suspendBreakpoint() {
            AcceleoDebugTarget.this.thread.setSuspended(true);
            AcceleoDebugTarget.this.thread.setStepping(false);
            AcceleoDebugTarget.this.thread.fireSuspendEvent(16);
        }

        @Override
        public void resumeStep() {
            AcceleoDebugTarget.this.thread.setSuspended(false);
            AcceleoDebugTarget.this.thread.setStepping(true);
            AcceleoDebugTarget.this.thread.fireResumeEvent(2);
        }

        @Override
        public void suspendStep() {
            AcceleoDebugTarget.this.thread.setSuspended(true);
            AcceleoDebugTarget.this.thread.setStepping(false);
            AcceleoDebugTarget.this.thread.fireSuspendEvent(8);
        }

        @Override
        public void start() {
            AcceleoDebugTarget.this.thread.fireCreationEvent();
        }

        @Override
        public void end() {
            try {
                AcceleoDebugTarget.this.terminate();
            }
            catch (DebugException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
    }
}

