/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;

public class AcceleoDocAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text != null) {
            if (command.length == 0) {
                String[] lineDelimiters = document.getLegalLineDelimiters();
                int index = TextUtilities.endsWith((String[])lineDelimiters, (String)command.text);
                if (index > -1 && lineDelimiters[index].equals(command.text)) {
                    this.indentAfterNewLine(document, command);
                } else if (index > -1) {
                    return;
                }
            }
            if ("]".equals(command.text)) {
                this.indentAfterCommentEnd(document, command);
                return;
            }
        }
    }

    private void indentAfterNewLine(IDocument d, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = -1;
            p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            Assert.isTrue((firstNonWS >= lineOffset ? 1 : 0) != 0, (String)AcceleoUIMessages.getString("AcceleoDocAutoIndentStrategy.InvalidIndentation"));
            StringBuffer buf = new StringBuffer(c.text);
            IRegion prefix = this.findPrefixRange(d, line);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            if (firstNonWS < offset && d.getChar(firstNonWS) == '[') {
                buf.append(" * ");
                if (this.isNewComment(d, offset)) {
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + buf.length();
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                    int eolOffset = lineOffset + line.getLength();
                    int replacementLength = eolOffset - p;
                    String restOfLine = d.get(p, replacementLength);
                    String endTag = String.valueOf(lineDelimiter) + indentation + "*" + "/" + "]";
                    d.replace(offset, replacementLength, endTag);
                    buf.append(restOfLine);
                }
            }
            if (lengthToAdd < prefix.getLength()) {
                c.caretOffset = offset + prefix.getLength() - lengthToAdd;
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.getChar(indentEnd) == '*') {
            ++indentEnd;
            while (indentEnd < lineEnd && document.getChar(indentEnd) == ' ') {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private boolean isNewComment(IDocument document, int commandOffset) {
        boolean result = false;
        try {
            String comment;
            int lineIndex = document.getLineOfOffset(commandOffset) + 1;
            if (lineIndex >= document.getNumberOfLines()) {
                result = true;
            }
            IRegion line = document.getLineInformation(lineIndex);
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"__ACCELEO_documentation", (int)commandOffset, (boolean)false);
            int partitionEnd = partition.getOffset() + partition.getLength();
            if (line.getOffset() >= partitionEnd) {
                result = false;
            }
            if (document.getLength() == partitionEnd) {
                result = true;
            }
            if ((comment = document.get(partition.getOffset(), partition.getLength())).indexOf("[**", 2) != -1) {
                result = true;
            }
        }
        catch (BadLocationException badLocationException) {
            result = false;
        }
        return result;
    }

    private void indentAfterCommentEnd(IDocument d, DocumentCommand c) {
        if (c.offset < 3 || d.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(d.get(c.offset - 3, 3))) {
                ++c.length;
                --c.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

