/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.equinox.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.acceleo.engine.service.AbstractAcceleoGenerator;
import org.eclipse.acceleo.equinox.internal.AcceleoEquinoxLauncherPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public class AcceleoGeneratorRunner {
    private File output;
    private String[] generatorParameters = new String[0];

    public AcceleoGeneratorRunner(File output, String[] generatorParameters) {
        this.output = output;
        this.generatorParameters = generatorParameters;
    }

    public void launchAcceleoGenerator(Monitor monitor, List<URI> modelURIS, String generatorsFullName) {
        int pluginClassSep = generatorsFullName.indexOf(47);
        if (pluginClassSep != -1 && pluginClassSep < generatorsFullName.length()) {
            String plugin = generatorsFullName.substring(0, pluginClassSep);
            String qualifiedClassName = generatorsFullName.substring(pluginClassSep + 1);
            Bundle bnd = Platform.getBundle((String)plugin);
            if (bnd != null) {
                try {
                    Class generatorClass = bnd.loadClass(qualifiedClassName);
                    try {
                        AbstractAcceleoGenerator generatorInstance = (AbstractAcceleoGenerator)generatorClass.newInstance();
                        for (URI modelURI : modelURIS) {
                            try {
                                generatorInstance.initialize(modelURI, this.output, this.buildParametersList());
                                generatorInstance.doGenerate(monitor);
                            }
                            catch (IOException e) {
                                this.error("Error launching the generator : " + qualifiedClassName, e);
                            }
                        }
                    }
                    catch (ClassCastException e) {
                        this.error("Class " + generatorClass + " has to be a subclass of AbstractAcceleoGenerator.", e);
                    }
                    catch (InstantiationException e) {
                        this.error("Could not instantiate " + generatorClass, e);
                    }
                    catch (IllegalAccessException e) {
                        AcceleoEquinoxLauncherPlugin.INSTANCE.log(e);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.error("Could not find the generator class : " + qualifiedClassName + " in the plugin :" + bnd.getSymbolicName(), e);
                }
            } else {
                this.error("Could not find the plugin: " + plugin, null);
            }
        } else {
            this.error("unexpected format for a generator : " + generatorsFullName + " pluginID/qualifiedClassName is expected", null);
        }
    }

    private void error(String message, Throwable e) {
        if (e != null) {
            AcceleoEquinoxLauncherPlugin.INSTANCE.log(new Status(4, AcceleoEquinoxLauncherPlugin.INSTANCE.getSymbolicName(), message, e));
        } else {
            AcceleoEquinoxLauncherPlugin.INSTANCE.log(new Status(4, AcceleoEquinoxLauncherPlugin.INSTANCE.getSymbolicName(), message));
        }
    }

    private List<String> buildParametersList() {
        return Arrays.asList(this.generatorParameters);
    }
}

