/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;

public class FilterService
extends JavaMethodService {
    final int filterIndex;

    public FilterService(Method serviceMethod, Object serviceInstance) {
        this(serviceMethod, serviceInstance, 1);
    }

    public FilterService(Method serviceMethod, Object serviceInstance, int filterIndex) {
        super(serviceMethod, serviceInstance);
        this.filterIndex = filterIndex;
    }

    @Override
    public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            for (IType possibleType : entry.getValue()) {
                IType rawType = possibleType instanceof ICollectionType ? ((ICollectionType)possibleType).getCollectionType() : possibleType;
                if (rawType instanceof NothingType) {
                    builder.append("\n");
                    builder.append(((NothingType)rawType).getMessage());
                    continue;
                }
                result.add(possibleType);
            }
        }
        if (result.isEmpty()) {
            NothingType nothing = services.nothing("Nothing will be left after calling %s:" + builder.toString(), this.getName());
            if (List.class.isAssignableFrom(this.getMethod().getReturnType())) {
                result.add(new SequenceType(queryEnvironment, nothing));
            } else if (Set.class.isAssignableFrom(this.getMethod().getReturnType())) {
                result.add(new SetType(queryEnvironment, nothing));
            } else {
                result.add(nothing);
            }
        }
        return result;
    }
}

