/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoModule;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoModuleElement;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.wizards.module.AcceleoModuleComposite;
import org.eclipse.acceleo.internal.ide.ui.wizards.module.IAcceleoModuleCompositeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class AcceleoModulesCreationPage
extends WizardPage
implements IAcceleoModuleCompositeListener {
    private final List<AcceleoModule> acceleoModules = new ArrayList<AcceleoModule>();
    private TreeViewer treeViewer;
    private Button addButton;
    private Button removeButton;
    private Composite root;
    private AcceleoModuleComposite acceleoModuleComposite;
    private String container;

    public AcceleoModulesCreationPage() {
        super(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Name"));
        this.setTitle(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Title1"));
        this.setDescription(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Description", "mtl"));
        this.setImageDescriptor(AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif"));
    }

    public void setContainer(String container) {
        this.container = container;
        if (this.acceleoModuleComposite != null) {
            this.acceleoModuleComposite.setModuleContainer(container);
        }
    }

    public void createControl(Composite parent) {
        this.root = new Composite(parent, 0);
        GridLayout rootContainerLayout = new GridLayout();
        rootContainerLayout.numColumns = 3;
        this.root.setLayout((Layout)rootContainerLayout);
        GridData gridData = new GridData(1808);
        this.root.setLayoutData((Object)gridData);
        this.createModuleGroup(this.root);
        this.createModuleComposite(this.root);
        this.setControl((Control)this.root);
        this.treeViewer.setInput(this.acceleoModules);
    }

    private void createModuleGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Template"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = 1;
        GridData gridData = new GridData(1040);
        gridData.widthHint = 150;
        gridData.minimumWidth = 150;
        gridData.heightHint = 500;
        gridData.minimumHeight = 500;
        group.setLayoutData((Object)gridData);
        this.createTreeViewer(group);
        this.createButtons(group);
    }

    private void createTreeViewer(Group group) {
        this.treeViewer = new TreeViewer((Composite)group);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 500;
        gridData.widthHint = 150;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        this.treeViewer.setContentProvider((IContentProvider)new ModulesTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return AcceleoUIActivator.getDefault().getImage("icons/AcceleoEditor.gif");
            }

            public String getText(Object element) {
                if (element instanceof AcceleoModule) {
                    return ((AcceleoModule)element).getName();
                }
                return null;
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AcceleoModulesCreationPage.this.moduleSelectionChanged(event.getSelection());
            }
        });
    }

    private void moduleSelectionChanged(ISelection selection) {
        IStructuredSelection structuredSelection;
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof AcceleoModule) {
            AcceleoModule acceleoModule = (AcceleoModule)firstElement;
            this.acceleoModuleComposite.setAcceleoModuleWithoutUpdate(acceleoModule);
        }
    }

    private void createButtons(Group group) {
        Composite buttonGroup = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.addButton = new Button(buttonGroup, 0);
        Image addImage = AcceleoUIActivator.getDefault().getImage("icons/add_obj.gif");
        this.addButton.setImage(addImage);
        this.addButton.setToolTipText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.AddButton.Tooltip"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModulesCreationPage.this.addModule(AcceleoModulesCreationPage.this.treeViewer.getSelection());
                AcceleoModulesCreationPage.this.treeViewer.refresh();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        gridData.verticalAlignment = 128;
        this.addButton.setLayoutData((Object)gridData);
        this.removeButton = new Button(buttonGroup, 0);
        Image removeImage = AcceleoUIActivator.getDefault().getImage("icons/delete_obj.gif");
        this.removeButton.setImage(removeImage);
        this.removeButton.setToolTipText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.RemoveButton.Tooltip"));
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModulesCreationPage.this.removeModule(AcceleoModulesCreationPage.this.treeViewer.getSelection());
                AcceleoModulesCreationPage.this.treeViewer.refresh();
            }
        });
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)gridData);
    }

    private void addModule(ISelection selection) {
        AcceleoModule acceleoModule = AcceleowizardmodelFactory.eINSTANCE.createAcceleoModule();
        acceleoModule.setName("generate");
        AcceleoModuleElement acceleoModuleElement = AcceleowizardmodelFactory.eINSTANCE.createAcceleoModuleElement();
        acceleoModuleElement.setName("generateElement");
        acceleoModule.setModuleElement(acceleoModuleElement);
        this.acceleoModules.add(acceleoModule);
        this.acceleoModuleComposite.setAcceleoModuleWithoutUpdate(acceleoModule);
        TreeItem[] items = this.treeViewer.getTree().getItems();
        this.treeViewer.getTree().setSelection(items[items.length - 1]);
    }

    private void removeModule(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.acceleoModules.removeAll(structuredSelection.toList());
        }
    }

    private void createModuleComposite(Composite parent) {
        this.acceleoModuleComposite = new AcceleoModuleComposite(parent, this);
        if (this.container != null) {
            this.acceleoModuleComposite.setModuleContainer(this.container);
        }
        AcceleoModule acceleoModule = AcceleowizardmodelFactory.eINSTANCE.createAcceleoModule();
        acceleoModule.setName("generate");
        AcceleoModuleElement acceleoModuleElement = AcceleowizardmodelFactory.eINSTANCE.createAcceleoModuleElement();
        acceleoModuleElement.setName("generateElement");
        acceleoModule.setModuleElement(acceleoModuleElement);
        this.acceleoModules.add(acceleoModule);
        this.acceleoModuleComposite.setAcceleoModule(acceleoModule);
    }

    @Override
    public void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message != null && message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setMessage(message, 0);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            case 2: {
                this.setMessage(message, 2);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            case 1: {
                this.setMessage(message, 1);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            default: {
                this.setMessage(null);
                this.setErrorMessage(message);
                this.setPageComplete(false);
            }
        }
        this.checkDuplicates();
        this.treeViewer.refresh();
    }

    private void checkDuplicates() {
        int i = 0;
        while (i < this.acceleoModules.size()) {
            AcceleoModule acceleoModule = this.acceleoModules.get(i);
            int j = 0;
            while (j < this.acceleoModules.size()) {
                String moduleName2;
                String moduleName;
                AcceleoModule acceleoModule2 = this.acceleoModules.get(j);
                if (i != j && (moduleName = String.valueOf(acceleoModule.getParentFolder()) + acceleoModule.getName()).equals(moduleName2 = String.valueOf(acceleoModule2.getParentFolder()) + acceleoModule2.getName())) {
                    this.setMessage(null);
                    this.setErrorMessage(AcceleoUIMessages.getString("AcceleoModuleCreationPage.TwoIdenticalModule"));
                    this.setPageComplete(false);
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public List<AcceleoModule> getAllModules() {
        return this.acceleoModules;
    }

    private class ModulesTreeContentProvider
    implements ITreeContentProvider {
        private ModulesTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                ArrayList<AcceleoModule> modules = new ArrayList<AcceleoModule>();
                List list = (List)parentElement;
                for (Object object : list) {
                    if (!(object instanceof AcceleoModule)) continue;
                    modules.add((AcceleoModule)object);
                }
                return modules.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

