/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.proposals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.views.proposals.patterns.IAcceleoPatternProposal;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class AcceleoPatternProposalsUtils {
    private static List<IAcceleoPatternProposal> patternProposals;

    private AcceleoPatternProposalsUtils() {
    }

    public static List<IAcceleoPatternProposal> getPatternProposals() {
        if (patternProposals == null) {
            patternProposals = new ArrayList<IAcceleoPatternProposal>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.acceleo.ide.ui.proposal");
            if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] members = extension.getConfigurationElements();
                    int j = 0;
                    while (j < members.length) {
                        IConfigurationElement member = members[j];
                        String patternClass = member.getAttribute("class");
                        if (patternClass != null) {
                            Status status;
                            try {
                                Bundle bundle = Platform.getBundle((String)member.getNamespaceIdentifier());
                                Class c = bundle.loadClass(patternClass);
                                IAcceleoPatternProposal patternProposal = (IAcceleoPatternProposal)c.newInstance();
                                patternProposals.add(patternProposal);
                            }
                            catch (ClassNotFoundException e) {
                                status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                            }
                            catch (InstantiationException e) {
                                status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                            }
                            catch (IllegalAccessException e) {
                                status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                            }
                        } else {
                            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, AcceleoUIMessages.getString("AcceleoPatternProposalsUtils.MissingPatternClass", "org.eclipse.acceleo.ide.ui.proposal"), null);
                            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return patternProposals;
    }
}

