/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.profiler.presentation;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.profiler.ProfileEntry;
import org.eclipse.acceleo.profiler.ProfilerPackage;
import org.eclipse.acceleo.profiler.presentation.ProfilerEditorPlugin;
import org.eclipse.acceleo.profiler.presentation.ProfilerOutlineContentProvider;
import org.eclipse.acceleo.profiler.presentation.ProfilerSortAction;
import org.eclipse.acceleo.profiler.presentation.ProfilerSortStatus;
import org.eclipse.acceleo.profiler.provider.ProfilerItemProviderAdapterFactorySpec;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public final class ProfilerEditor
extends EcoreEditor {
    private static final ProfilerPackage PKG = ProfilerPackage.eINSTANCE;
    protected ProfilerSortStatus sortStatus = new ProfilerSortStatus();

    public ProfilerEditor() {
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ProfilerItemProviderAdapterFactorySpec());
    }

    public void createPages() {
        super.createPages();
        this.selectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selected = ((TreeSelection)event.getSelection()).getFirstElement();
                boolean cfr_ignored_0 = selected instanceof ProfileEntry;
            }
        });
        this.selectionViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int ret = 0;
                if (e1 instanceof ProfileEntry && e2 instanceof ProfileEntry) {
                    ProfileEntry entry1 = (ProfileEntry)e1;
                    ProfileEntry entry2 = (ProfileEntry)e2;
                    switch (ProfilerEditor.this.sortStatus.getSortOrder()) {
                        case 0: {
                            ret = (int)(entry1.getCreateTime() - entry2.getCreateTime());
                            break;
                        }
                        case 1: {
                            ret = (int)(entry2.getDuration() - entry1.getDuration());
                            break;
                        }
                    }
                }
                return ret;
            }
        });
        this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getChildren(Object object) {
                if (object instanceof ProfileEntry) {
                    return ((ProfileEntry)object).getCallees().toArray();
                }
                return super.getChildren(object);
            }

            public Object[] getElements(Object object) {
                return this.getChildren(object);
            }
        });
        IToolBarManager toolBarManager = this.getActionBars().getToolBarManager();
        toolBarManager.add((IAction)new ProfilerSortAction(this.sortStatus, this.selectionViewer));
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    ProfilerEditor.this.contentOutlineViewer = this.getTreeViewer();
                    ProfilerEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    ProfilerEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new ProfilerOutlineContentProvider((AdapterFactory)ProfilerEditor.this.adapterFactory));
                    ProfilerEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)ProfilerEditor.this.adapterFactory));
                    ProfilerEditor.this.contentOutlineViewer.setInput((Object)ProfilerEditor.this.editingDomain.getResourceSet());
                    ProfilerEditor.this.createContextMenuFor((StructuredViewer)ProfilerEditor.this.contentOutlineViewer);
                    if (!ProfilerEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        ProfilerEditor.this.contentOutlineViewer.setSelection((ISelection)StructuredSelection.EMPTY, true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    ProfilerEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    ProfilerEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ProfilerEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = null;
        statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(ProfilerEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(ProfilerEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        Iterator it = collection.iterator();
                        double percentage = 0.0;
                        long duration = 0L;
                        long count = 0L;
                        while (it.hasNext()) {
                            Object select = it.next();
                            if (!(select instanceof ProfileEntry)) continue;
                            ProfileEntry entry = (ProfileEntry)select;
                            percentage += entry.getPercentage();
                            duration += entry.getDuration();
                            count += entry.getCount();
                        }
                        DecimalFormat format = new DecimalFormat();
                        ((NumberFormat)format).setMaximumIntegerDigits(3);
                        ((NumberFormat)format).setMaximumFractionDigits(2);
                        String statusString = String.valueOf(Integer.toString(collection.size())) + " [" + format.format(percentage) + "% / " + duration + "ms / " + count + " times]";
                        statusLineManager.setMessage(ProfilerEditor.getString("_UI_MultiObjectSelected", statusString));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return ProfilerEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return EcoreEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ChangementListener();
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            if (this.currentViewer == null) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.setSelection(this.currentViewer.getSelection());
            }
        }
    }

    protected boolean showOutlineView() {
        return true;
    }

    private final class ChangementListener
    implements ISelectionChangedListener {
        private ChangementListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ProfilerEditor.this.setSelection(selectionChangedEvent.getSelection());
            if (ProfilerEditor.this.currentViewer != ProfilerEditor.this.contentOutlineViewer && ProfilerEditor.this.contentOutlineViewer != null && !ProfilerEditor.this.contentOutlineViewer.getControl().isDisposed()) {
                if (ProfilerEditor.this.contentOutlineViewer.getContentProvider() == null) {
                    ProfilerEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new ProfilerOutlineContentProvider((AdapterFactory)ProfilerEditor.this.adapterFactory));
                }
                ProfilerEditor.this.contentOutlineViewer.setInput(((TreeSelection)selectionChangedEvent.getSelection()).getFirstElement());
            }
        }
    }
}

