/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation.strategy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.generation.strategy.AbstractGenerationStrategy;
import org.eclipse.acceleo.engine.generation.writers.AbstractAcceleoWriter;
import org.eclipse.acceleo.engine.generation.writers.AcceleoStringWriter;

public class PreviewStrategy
extends AbstractGenerationStrategy {
    private static final int DEFAULT_BUFFER_SIZE = 1024;

    @Override
    public Map<String, StringWriter> createLostFile(String originalPath, Map<String, String> lostCode) {
        StringWriter writer;
        File lostFile;
        StringBuilder lostContent;
        block17: {
            lostContent = new StringBuilder();
            for (String lostAreaContent : lostCode.values()) {
                lostContent.append(lostAreaContent);
                lostContent.append(LINE_SEPARATOR);
            }
            lostFile = new File(originalPath.concat(".lost"));
            writer = new StringWriter(1024);
            if (lostFile.exists() && lostFile.canRead()) {
                BufferedReader lostFileReader = null;
                try {
                    try {
                        lostFileReader = new BufferedReader(new FileReader(lostFile));
                        String line = lostFileReader.readLine();
                        while (line != null) {
                            writer.append(line);
                            line = lostFileReader.readLine();
                        }
                    }
                    catch (IOException iOException) {
                        String errorMessage = AcceleoEngineMessages.getString("AcceleoEvaluationContext.LostContent", originalPath, lostContent);
                        AcceleoEnginePlugin.log(errorMessage, false);
                        if (lostFileReader != null) {
                            try {
                                lostFileReader.close();
                            }
                            catch (IOException e) {
                                AcceleoEnginePlugin.log(e, true);
                            }
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (lostFileReader != null) {
                        try {
                            lostFileReader.close();
                        }
                        catch (IOException e) {
                            AcceleoEnginePlugin.log(e, true);
                        }
                    }
                    throw throwable;
                }
                if (lostFileReader != null) {
                    try {
                        lostFileReader.close();
                    }
                    catch (IOException e) {
                        AcceleoEnginePlugin.log(e, true);
                    }
                }
            }
        }
        writer.append(LINE_SEPARATOR).append(Calendar.getInstance().getTime().toString()).append(LINE_SEPARATOR);
        writer.append("================================================================================");
        writer.append(LINE_SEPARATOR);
        writer.append(lostContent);
        writer.flush();
        HashMap<String, StringWriter> result = new HashMap<String, StringWriter>(1);
        result.put(lostFile.getPath(), writer);
        return result;
    }

    @Override
    public AbstractAcceleoWriter createWriterFor(File file, AbstractAcceleoWriter previous, boolean appendMode, boolean hasJMergeTags) throws IOException {
        return this.createWriterFor(file, previous, appendMode, hasJMergeTags, null);
    }

    @Override
    public AbstractAcceleoWriter createWriterFor(File file, AbstractAcceleoWriter previous, boolean appendMode, boolean hasJMergeTags, String charset) throws IOException {
        AbstractAcceleoWriter writer;
        if (file.isDirectory()) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FileNameIsDirectory", file));
        }
        if (appendMode && previous != null) {
            writer = previous;
            writer.append(LINE_SEPARATOR);
        } else if (!appendMode && hasJMergeTags) {
            writer = previous;
            writer.reinit();
        } else if (charset != null) {
            if (Charset.isSupported(charset)) {
                writer = new AcceleoStringWriter(file, appendMode, hasJMergeTags, charset);
            } else {
                String message = AcceleoEngineMessages.getString("AcceleoGenerationStrategy.UnsupportedCharset", charset);
                AcceleoEnginePlugin.log(message, false);
                writer = new AcceleoStringWriter(file, appendMode, hasJMergeTags);
            }
        } else {
            writer = new AcceleoStringWriter(file, appendMode, hasJMergeTags);
        }
        return writer;
    }

    @Override
    public Map<String, String> preparePreview(Map<String, Writer> currentWriters) {
        Map<String, String> preview = super.preparePreview(currentWriters);
        for (Map.Entry<String, Writer> entry : currentWriters.entrySet()) {
            try {
                entry.getValue().flush();
            }
            catch (IOException e) {
                AcceleoEnginePlugin.log(e, true);
            }
            preview.put(entry.getKey(), entry.getValue().toString());
        }
        return preview;
    }

    @Override
    public boolean willReturnPreview() {
        return true;
    }
}

