/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEnvironmentListener;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.InvalidAcceleoPackageException;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.acceleo.query.runtime.lookup.basic.BasicLookupEngine;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

public class QueryEnvironment
implements IQueryEnvironment {
    private BasicLookupEngine lookupEngine;
    private EPackageProvider ePackageProvider;
    private List<IQueryEnvironmentListener> listeners = new ArrayList<IQueryEnvironmentListener>();

    public QueryEnvironment(CrossReferenceProvider crossReferencer) {
        this(crossReferencer, null);
    }

    public QueryEnvironment(CrossReferenceProvider crossReferencer, IRootEObjectProvider rootProvider) {
        this.ePackageProvider = new EPackageProvider();
        this.lookupEngine = new BasicLookupEngine(this, crossReferencer, rootProvider);
    }

    @Override
    public ServiceRegistrationResult registerServicePackage(Class<?> services) throws InvalidAcceleoPackageException {
        ServiceRegistrationResult result = this.lookupEngine.registerServices(services);
        if (!result.getRegistered().isEmpty()) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.servicePackageRegistered(result, services);
            }
        }
        return result;
    }

    @Override
    public boolean isRegisteredServicePackage(Class<?> cls) {
        return this.lookupEngine.isRegisteredService(cls);
    }

    @Override
    public void removeServicePackage(Class<?> services) {
        Class<?> removedClass = this.lookupEngine.removeServices(services);
        if (removedClass != null) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.servicePackageRemoved(removedClass);
            }
        }
    }

    @Override
    public void registerEPackage(EPackage ePackage) {
        EPackage registeredEPackage = this.ePackageProvider.registerPackage(ePackage);
        if (registeredEPackage != null) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.ePackageRegistered(ePackage);
            }
        }
    }

    @Override
    public void removeEPackage(String name) {
        EPackage ePackage = this.ePackageProvider.removePackage(name);
        if (ePackage != null) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.ePackageRemoved(ePackage);
            }
        }
    }

    @Override
    public void registerCustomClassMapping(EClassifier eClassifier, Class<?> cls) {
        this.ePackageProvider.registerCustomClassMapping(eClassifier, cls);
        for (IQueryEnvironmentListener listener : this.getListeners()) {
            listener.customClassMappingRegistered(eClassifier, cls);
        }
    }

    @Override
    public BasicLookupEngine getLookupEngine() {
        return this.lookupEngine;
    }

    @Override
    public EPackageProvider getEPackageProvider() {
        return this.ePackageProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQueryEnvironmentListener(IQueryEnvironmentListener listener) {
        if (listener != null) {
            List<IQueryEnvironmentListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        } else {
            throw new IllegalArgumentException("IQueryEnvironmentListener can't be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueryEnvironmentListener(IQueryEnvironmentListener listener) {
        if (listener != null) {
            List<IQueryEnvironmentListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IQueryEnvironmentListener> getListeners() {
        ArrayList<IQueryEnvironmentListener> result;
        List<IQueryEnvironmentListener> list = this.listeners;
        synchronized (list) {
            result = new ArrayList<IQueryEnvironmentListener>(this.listeners);
        }
        return result;
    }
}

