/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Map;

public class ScopedEnvironment {
    private List<Map<String, Object>> scopes = new ArrayList<Map<String, Object>>();

    public void pushScope(Map<String, Object> scope) {
        this.scopes.add(scope);
    }

    public Map<String, Object> popScope() {
        if (this.scopes.size() > 0) {
            return this.scopes.remove(this.scopes.size() - 1);
        }
        throw new EmptyStackException();
    }

    public Object getVariableValue(String variableName) {
        int i = this.scopes.size() - 1;
        while (i >= 0) {
            Object result = this.scopes.get(i).get(variableName);
            if (result != null) {
                return result;
            }
            --i;
        }
        return null;
    }

    public Object defineVariable(String variableName, Object value) {
        if (this.scopes.size() == 0) {
            throw new EmptyStackException();
        }
        return this.scopes.get(this.scopes.size() - 1).put(variableName, value);
    }

    public ScopedEnvironment copy() {
        ScopedEnvironment copy = new ScopedEnvironment();
        for (Map<String, Object> scope : this.scopes) {
            copy.pushScope(Maps.newHashMap(scope));
        }
        return copy;
    }
}

