/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IEPackageProvider;
import org.eclipse.acceleo.query.runtime.IEPackageProvider2;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class EPackageProvider
implements IEPackageProvider,
IEPackageProvider2 {
    private Map<String, EPackage> ePackages = new LinkedHashMap<String, EPackage>();
    private final Map<Class<?>, Set<EClassifier>> class2classifiers = new HashMap();
    private final Map<EClassifier, Class<?>> classifier2class = new HashMap();
    private final Map<Integer, Map<String, List<EOperation>>> eOperations = new HashMap<Integer, Map<String, List<EOperation>>>();
    private final List<EOperation> eOperationsList = new ArrayList<EOperation>();
    private final Map<EClass, Set<EStructuralFeature>> containingFeaturesForOneClassHierarchy = new HashMap<EClass, Set<EStructuralFeature>>();
    private final Map<EClass, Set<EStructuralFeature>> containingFeatures = new HashMap<EClass, Set<EStructuralFeature>>();
    private final Map<EClass, Set<EStructuralFeature>> allContainingFeatures = new HashMap<EClass, Set<EStructuralFeature>>();
    private final Map<EClass, Set<EStructuralFeature>> inverseFeatures = new HashMap<EClass, Set<EStructuralFeature>>();
    private final Map<EClass, Set<EClass>> subTypes = new HashMap<EClass, Set<EClass>>();

    @Override
    public EPackage getEPackage(String name) {
        return this.ePackages.get(name);
    }

    public void removePackage(String name) {
        EPackage ePackage = this.ePackages.remove(name);
        if (ePackage != null) {
            for (EClassifier eCls : ePackage.getEClassifiers()) {
                this.removeEClassifierClass(eCls);
                if (!(eCls instanceof EClass)) continue;
                this.removeEOperations((EClass)eCls);
                this.removeFeatures((EClass)eCls);
                this.removeSubType((EClass)eCls);
            }
            for (EPackage childPkg : ePackage.getESubpackages()) {
                this.removePackage(childPkg.getName());
            }
            this.containingFeatures.clear();
            this.allContainingFeatures.clear();
        }
    }

    private void removeSubType(EClass eCls) {
        for (EClass superECls : eCls.getESuperTypes()) {
            Set<EClass> types = this.subTypes.get(superECls);
            if (types == null || !types.remove(eCls) || types.size() != 0) continue;
            types = new LinkedHashSet<EClass>();
            this.subTypes.remove(superECls);
        }
    }

    private void removeFeatures(EClass eCls) {
        for (EStructuralFeature feature : eCls.getEStructuralFeatures()) {
            Set<EStructuralFeature> possibleContainementFeatures;
            if (!(feature.getEType() instanceof EClass)) continue;
            Set<EStructuralFeature> possibleInverseFeatures = this.inverseFeatures.get(feature.getEType());
            if (possibleInverseFeatures != null && possibleInverseFeatures.remove(feature) && possibleInverseFeatures.size() == 0) {
                this.inverseFeatures.remove(feature.getEType());
            }
            if (!this.isContainingEStructuralFeature(feature) || (possibleContainementFeatures = this.containingFeaturesForOneClassHierarchy.get(feature.getEType())) == null || !possibleContainementFeatures.remove(feature) || possibleContainementFeatures.size() != 0) continue;
            this.containingFeaturesForOneClassHierarchy.remove(feature.getEType());
        }
    }

    private boolean isContainingEStructuralFeature(EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isContainment() || feature instanceof EAttribute;
    }

    private void removeEOperations(EClass eCls) {
        for (EOperation eOperation : eCls.getEOperations()) {
            List<EOperation> multiEOperation = this.getMultiEOperation(eOperation.getName(), eOperation.getEParameters().size());
            if (multiEOperation != null && multiEOperation.remove(eOperation) && multiEOperation.size() == 0) {
                this.eOperations.get(eOperation.getEParameters().size()).remove(eOperation.getName());
            }
            this.eOperationsList.remove(eOperation);
        }
    }

    private void removeEClassifierClass(EClassifier eCls) {
        Class<?> instanceClass = this.getClass(eCls);
        Set<EClassifier> classifiers = this.class2classifiers.get(instanceClass);
        if (classifiers != null) {
            if (classifiers.size() == 1) {
                this.class2classifiers.remove(instanceClass);
            } else {
                classifiers.remove(eCls);
            }
        }
        this.classifier2class.remove(eCls);
    }

    public void registerPackage(EPackage ePackage) {
        if (!"ecore".equals(ePackage.getName()) || "http://www.eclipse.org/emf/2002/Ecore".equals(ePackage.getNsURI())) {
            if (ePackage.getName() != null) {
                this.ePackages.put(ePackage.getName(), ePackage);
                for (EClassifier eCls : ePackage.getEClassifiers()) {
                    this.registerEClassifierClass(eCls);
                    if (!(eCls instanceof EClass)) continue;
                    this.registerEOperations((EClass)eCls);
                    this.registerFeatures((EClass)eCls);
                    this.registerSubTypes((EClass)eCls);
                }
                for (EPackage childPkg : ePackage.getESubpackages()) {
                    this.registerPackage(childPkg);
                }
                this.containingFeatures.clear();
                this.allContainingFeatures.clear();
            } else {
                throw new IllegalStateException("Couldn't register package " + ePackage.getName() + " because it's name is null.");
            }
        }
    }

    private void registerSubTypes(EClass eCls) {
        for (EClass superECls : eCls.getESuperTypes()) {
            Set<EClass> types = this.subTypes.get(superECls);
            if (types == null) {
                types = new LinkedHashSet<EClass>();
                this.subTypes.put(superECls, types);
            }
            types.add(eCls);
        }
    }

    private void registerFeatures(EClass eCls) {
        for (EStructuralFeature feature : eCls.getEStructuralFeatures()) {
            if (!(feature.getEType() instanceof EClass)) continue;
            Set<EStructuralFeature> possibleInverseFeatures = this.inverseFeatures.get(feature.getEType());
            if (possibleInverseFeatures == null) {
                possibleInverseFeatures = new LinkedHashSet<EStructuralFeature>();
                this.inverseFeatures.put((EClass)feature.getEType(), possibleInverseFeatures);
            }
            possibleInverseFeatures.add(feature);
            if (!this.isContainingEStructuralFeature(feature)) continue;
            Set<EStructuralFeature> possibleContainementFeatures = this.containingFeaturesForOneClassHierarchy.get(feature.getEType());
            if (possibleContainementFeatures == null) {
                possibleContainementFeatures = new LinkedHashSet<EStructuralFeature>();
                this.containingFeaturesForOneClassHierarchy.put((EClass)feature.getEType(), possibleContainementFeatures);
            }
            possibleContainementFeatures.add(feature);
        }
    }

    private void registerEClassifierClass(EClassifier eCls) {
        Class instanceClass;
        Class customClass = this.classifier2class.get(eCls);
        if (customClass != null) {
            instanceClass = customClass;
        } else {
            instanceClass = eCls.getInstanceClass();
            this.classifier2class.put(eCls, instanceClass);
        }
        Set<EClassifier> classifiers = this.class2classifiers.get(instanceClass);
        if (classifiers == null) {
            classifiers = new LinkedHashSet<EClassifier>();
            this.class2classifiers.put(instanceClass, classifiers);
        }
        classifiers.add(eCls);
    }

    private void registerEOperations(EClass eCls) {
        for (EOperation eOperation : eCls.getEOperations()) {
            List<EOperation> multiEOperation = this.getOrCreateMultimethod(eOperation.getName(), eOperation.getEParameters().size());
            multiEOperation.add(eOperation);
            this.eOperationsList.add(eOperation);
        }
    }

    @Override
    public EOperation lookupEOperation(EClass receiverEClass, String eOperationName, List<EParameter> parameterTypes) {
        EOperation result;
        List<EOperation> multiEOperations = this.getMultiEOperation(eOperationName, parameterTypes.size());
        if (multiEOperations != null) {
            EOperation compatibleEOperation = null;
            Iterator<EOperation> itOp = multiEOperations.iterator();
            while (itOp.hasNext() && compatibleEOperation == null) {
                EOperation eOperation = itOp.next();
                if (!eOperation.getEContainingClass().isSuperTypeOf(receiverEClass)) continue;
                boolean parametersAreCompatibles = parameterTypes.size() == eOperation.getEParameters().size();
                Iterator<EParameter> itParamType = parameterTypes.iterator();
                Iterator itOperationParam = eOperation.getEParameters().iterator();
                while (parametersAreCompatibles && itOperationParam.hasNext() && itParamType.hasNext()) {
                    parametersAreCompatibles = this.isCompatibleType((EParameter)itOperationParam.next(), itParamType.next());
                }
                if (!parametersAreCompatibles) continue;
                compatibleEOperation = eOperation;
            }
            result = compatibleEOperation;
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Set<EOperation> getEOperations(Set<EClass> receiverTypes) {
        LinkedHashSet<EOperation> result = new LinkedHashSet<EOperation>();
        for (EClass eCls : receiverTypes) {
            for (EOperation eOperation : this.eOperationsList) {
                if (!eOperation.getEContainingClass().isSuperTypeOf(eCls)) continue;
                result.add(eOperation);
            }
        }
        return result;
    }

    private boolean isCompatibleType(EParameter parameter, EParameter passedParameter) {
        boolean result = parameter.isMany() == passedParameter.isMany() ? (parameter.getEType() instanceof EClass && passedParameter.getEType() instanceof EClass ? ((EClass)parameter.getEType()).isSuperTypeOf((EClass)passedParameter.getEType()) : (passedParameter.getEType() != null ? parameter.getEType() == passedParameter.getEType() : true)) : false;
        return result;
    }

    @Override
    public EClassifier getType(String name, String classifierName) {
        EPackage ePackage = this.ePackages.get(name);
        if (ePackage != null) {
            return ePackage.getEClassifier(classifierName);
        }
        return null;
    }

    @Override
    public EClassifier getType(String classifierName) {
        EClassifier result = null;
        for (EPackage ePackage : this.ePackages.values()) {
            EClassifier foundClassifier = ePackage.getEClassifier(classifierName);
            if (foundClassifier == null) continue;
            if (result == null) {
                result = foundClassifier;
                continue;
            }
            String firstFullyQualifiedName = String.valueOf(result.getEPackage().getName()) + "." + result.getName();
            String secondFullyQualifiedName = String.valueOf(foundClassifier.getEPackage().getName()) + "." + foundClassifier.getName();
            String message = "Ambiguous classifier request. At least two classifiers matches %s : %s and %s";
            throw new IllegalStateException(String.format(message, classifierName, firstFullyQualifiedName, secondFullyQualifiedName));
        }
        return result;
    }

    @Override
    public EEnumLiteral getEnumLiteral(String name, String enumName, String literalName) {
        EEnumLiteral result;
        EPackage ePackage = this.ePackages.get(name);
        if (ePackage != null) {
            EClassifier eClassifier = ePackage.getEClassifier(enumName);
            result = this.getEnumLiteral(eClassifier, literalName);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public EEnumLiteral getEnumLiteral(String enumName, String literalName) {
        EClassifier eClassifier = this.getType(enumName);
        if (eClassifier == null) {
            return null;
        }
        return this.getEnumLiteral(eClassifier, literalName);
    }

    private EEnumLiteral getEnumLiteral(EClassifier eClassifier, String literalName) {
        EEnumLiteral result = eClassifier instanceof EEnum ? ((EEnum)eClassifier).getEEnumLiteral(literalName) : null;
        return result;
    }

    @Override
    public Set<EClassifier> getEClass(Class<?> cls) {
        return this.class2classifiers.get(cls);
    }

    @Override
    public Class<?> getClass(EClassifier eCls) {
        return this.classifier2class.get(eCls);
    }

    void registerCustomClassMapping(EClassifier eClassifier, Class<?> cls) {
        Set<EClassifier> eClassifiers;
        Class<?> oldClass = this.classifier2class.remove(eClassifier);
        if (oldClass != null && (eClassifiers = this.class2classifiers.get(oldClass)).remove(eClassifier) && eClassifiers.isEmpty()) {
            this.class2classifiers.remove(oldClass);
        }
        this.classifier2class.put(eClassifier, cls);
        eClassifiers = this.class2classifiers.get(cls);
        if (eClassifiers == null) {
            eClassifiers = new LinkedHashSet<EClassifier>();
            this.class2classifiers.put(cls, eClassifiers);
        }
        eClassifiers.add(eClassifier);
    }

    @Override
    public Set<EStructuralFeature> getEStructuralFeatures(Set<EClass> receiverEClasses) {
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
        for (EClass eCls : receiverEClasses) {
            result.addAll((Collection<EStructuralFeature>)eCls.getEAllStructuralFeatures());
        }
        return result;
    }

    @Override
    public Set<EClassifier> getEClassifiers() {
        LinkedHashSet<EClassifier> result = new LinkedHashSet<EClassifier>();
        for (EPackage ePkg : this.ePackages.values()) {
            result.addAll((Collection<EClassifier>)ePkg.getEClassifiers());
        }
        return result;
    }

    @Override
    public Set<EEnumLiteral> getEEnumLiterals() {
        LinkedHashSet<EEnumLiteral> result = new LinkedHashSet<EEnumLiteral>();
        for (EPackage ePkg : this.ePackages.values()) {
            for (EClassifier eClassifier : ePkg.getEClassifiers()) {
                if (!(eClassifier instanceof EEnum)) continue;
                result.addAll((Collection<EEnumLiteral>)((EEnum)eClassifier).getELiterals());
            }
        }
        return result;
    }

    private List<EOperation> getMultiEOperation(String eOperationName, int argc) {
        Map<String, List<EOperation>> argcServices = this.eOperations.get(argc);
        if (argcServices == null) {
            return null;
        }
        return argcServices.get(eOperationName);
    }

    private List<EOperation> getOrCreateMultimethod(String eOperationName, int argc) {
        List<EOperation> result;
        Map<String, List<EOperation>> argcEOperations = this.eOperations.get(argc);
        if (argcEOperations == null) {
            argcEOperations = new HashMap<String, List<EOperation>>();
            this.eOperations.put(argc, argcEOperations);
        }
        if ((result = argcEOperations.get(eOperationName)) == null) {
            result = new ArrayList<EOperation>();
            argcEOperations.put(eOperationName, result);
        }
        return result;
    }

    @Override
    public Set<EClass> getContainingEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        for (EStructuralFeature feature : this.getContainingEStructuralFeatures(eCls)) {
            result.add(feature.getEContainingClass());
        }
        return result;
    }

    @Override
    public Set<EClass> getAllContainingEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        for (EStructuralFeature feature : this.getAllContainingEStructuralFeatures(eCls)) {
            result.add(feature.getEContainingClass());
        }
        return result;
    }

    @Override
    public Set<EStructuralFeature> getAllContainingEStructuralFeatures(EClass type) {
        Set<EStructuralFeature> result = this.allContainingFeatures.get(type);
        if (result == null) {
            result = new LinkedHashSet<EStructuralFeature>();
            this.allContainingFeatures.put(type, result);
            HashSet<EClass> knownECls = new HashSet<EClass>();
            LinkedHashSet<EStructuralFeature> previousAdded = new LinkedHashSet<EStructuralFeature>(this.getContainingEStructuralFeatures(type));
            result.addAll(previousAdded);
            while (!previousAdded.isEmpty()) {
                LinkedHashSet<EStructuralFeature> currentAdded = new LinkedHashSet<EStructuralFeature>();
                for (EStructuralFeature feature : previousAdded) {
                    EClass eContainingClass = feature.getEContainingClass();
                    if (knownECls.contains(eContainingClass)) continue;
                    for (EStructuralFeature parentFeature : this.getContainingEStructuralFeatures(eContainingClass)) {
                        if (!result.add(parentFeature)) continue;
                        knownECls.add(eContainingClass);
                        currentAdded.add(parentFeature);
                    }
                }
                previousAdded = currentAdded;
            }
        }
        return result;
    }

    @Override
    public Set<EStructuralFeature> getContainingEStructuralFeatures(EClass eCls) {
        Set<EStructuralFeature> result = this.containingFeatures.get(eCls);
        if (result == null) {
            result = new LinkedHashSet<EStructuralFeature>();
            this.containingFeatures.put(eCls, result);
            result.addAll(this.getContainingEStructuralFeaturesForOneEClassHierarchyLevel(eCls));
            for (EClass superType : eCls.getEAllSuperTypes()) {
                result.addAll(this.getContainingEStructuralFeaturesForOneEClassHierarchyLevel(superType));
            }
            for (EClass subType : this.getAllSubTypes(eCls)) {
                result.addAll(this.getContainingEStructuralFeaturesForOneEClassHierarchyLevel(subType));
            }
            result.addAll(this.getContainingEStructuralFeaturesForOneEClassHierarchyLevel(EcorePackage.eINSTANCE.getEObject()));
        }
        return result;
    }

    private Set<EStructuralFeature> getContainingEStructuralFeaturesForOneEClassHierarchyLevel(EClass eCls) {
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
        Set<EStructuralFeature> features = this.containingFeaturesForOneClassHierarchy.get(eCls);
        if (features != null) {
            result.addAll(features);
        }
        return result;
    }

    @Override
    public Set<EClass> getAllSubTypes(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EClass> types = this.subTypes.get(eCls);
        if (types != null) {
            for (EClass type : types) {
                result.add(type);
                result.addAll(this.getAllSubTypes(type));
            }
        }
        return result;
    }

    @Override
    public Set<EClass> getContainedEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        LinkedHashSet features = new LinkedHashSet(eCls.getEAllStructuralFeatures());
        for (EClass subECls : this.getAllSubTypes(eCls)) {
            features.addAll(subECls.getEStructuralFeatures());
        }
        for (EStructuralFeature feature : features) {
            if (!this.isContainingEStructuralFeature(feature) || !(feature.getEType() instanceof EClass)) continue;
            result.add((EClass)feature.getEType());
        }
        return result;
    }

    @Override
    public Set<EClass> getAllContainedEClasses(EClass eCls) {
        Set<EClass> direcltyContainedEClasses = this.getContainedEClasses(eCls);
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>(direcltyContainedEClasses);
        LinkedHashSet<EClass> added = new LinkedHashSet<EClass>(direcltyContainedEClasses);
        while (!added.isEmpty()) {
            LinkedHashSet<EClass> toDig = new LinkedHashSet<EClass>();
            for (EClass a : added) {
                for (EClass contained : this.getContainedEClasses(a)) {
                    if (!result.add(contained)) continue;
                    toDig.add(contained);
                }
            }
            added = toDig;
        }
        return result;
    }

    @Override
    public Set<EClass> getInverseEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        result.addAll(this.getInverseClassesForOneEClassHierarchyLevel(eCls));
        for (EClass superType : eCls.getEAllSuperTypes()) {
            result.addAll(this.getInverseClassesForOneEClassHierarchyLevel(superType));
        }
        for (EClass subType : this.getAllSubTypes(eCls)) {
            result.addAll(this.getInverseClassesForOneEClassHierarchyLevel(subType));
        }
        for (EClass eObjectType : this.getInverseClassesForOneEClassHierarchyLevel(EcorePackage.eINSTANCE.getEObject())) {
            result.add(eObjectType);
        }
        return result;
    }

    private Set<EClass> getInverseClassesForOneEClassHierarchyLevel(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EStructuralFeature> features = this.inverseFeatures.get(eCls);
        if (features != null) {
            for (EStructuralFeature feature : features) {
                result.add(feature.getEContainingClass());
            }
        }
        return result;
    }

    @Override
    public Set<EClass> getFollowingSiblingsEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EStructuralFeature> containingEStructuralFeatures = this.getContainingEStructuralFeatures(eCls);
        LinkedHashSet<EStructuralFeature> followingEStructuralFeatures = new LinkedHashSet<EStructuralFeature>();
        for (EStructuralFeature feature : containingEStructuralFeatures) {
            followingEStructuralFeatures.addAll(this.getFollowingSiblingEStructuralFeatures(feature));
        }
        for (EStructuralFeature feature : followingEStructuralFeatures) {
            if (!this.isContainingEStructuralFeature(feature) || !(feature.getEType() instanceof EClass)) continue;
            result.add((EClass)feature.getEType());
        }
        return result;
    }

    private Set<EStructuralFeature> getFollowingSiblingEStructuralFeatures(EStructuralFeature feature) {
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
        if (feature.isMany()) {
            result.add(feature);
        }
        boolean add = false;
        for (EStructuralFeature childFeature : feature.getEContainingClass().getEStructuralFeatures()) {
            if (add && this.isContainingEStructuralFeature(childFeature)) {
                result.add(childFeature);
            }
            boolean bl = add = add || childFeature == feature;
        }
        for (EClass eCls : this.getAllSubTypes(feature.getEContainingClass())) {
            for (EStructuralFeature childFeature : eCls.getEStructuralFeatures()) {
                if (!this.isContainingEStructuralFeature(childFeature)) continue;
                result.add(childFeature);
            }
        }
        return result;
    }

    @Override
    public Set<EClass> getPrecedingSiblingsEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EStructuralFeature> containingEStructuralFeatures = this.getContainingEStructuralFeatures(eCls);
        LinkedHashSet<EStructuralFeature> precedingEStructuralFeatures = new LinkedHashSet<EStructuralFeature>();
        for (EStructuralFeature feature : containingEStructuralFeatures) {
            precedingEStructuralFeatures.addAll(this.getPrecedingSiblingEStructuralFeatures(feature));
        }
        for (EStructuralFeature feature : precedingEStructuralFeatures) {
            if (!(feature.getEType() instanceof EClass)) continue;
            result.add((EClass)feature.getEType());
        }
        return result;
    }

    private Set<EStructuralFeature> getPrecedingSiblingEStructuralFeatures(EStructuralFeature feature) {
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
        for (EStructuralFeature childFeature : feature.getEContainingClass().getEAllStructuralFeatures()) {
            if (childFeature == feature) break;
            if (!this.isContainingEStructuralFeature(childFeature)) continue;
            result.add(childFeature);
        }
        if (feature.isMany()) {
            result.add(feature);
        }
        return result;
    }

    @Override
    public Set<EClass> getSiblingsEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EStructuralFeature> containingEStructuralFeatures = this.getContainingEStructuralFeatures(eCls);
        LinkedHashSet<EStructuralFeature> siblingEStructuralFeatures = new LinkedHashSet<EStructuralFeature>();
        for (EStructuralFeature feature : containingEStructuralFeatures) {
            siblingEStructuralFeatures.addAll(this.getSiblingEStructuralFeatures(feature));
        }
        for (EStructuralFeature feature : siblingEStructuralFeatures) {
            if (!this.isContainingEStructuralFeature(feature) || !(feature.getEType() instanceof EClass)) continue;
            result.add((EClass)feature.getEType());
        }
        return result;
    }

    private Set<EStructuralFeature> getSiblingEStructuralFeatures(EStructuralFeature feature) {
        Set<EStructuralFeature> preceding = this.getPrecedingSiblingEStructuralFeatures(feature);
        Set<EStructuralFeature> following = this.getFollowingSiblingEStructuralFeatures(feature);
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>(preceding.size() + following.size());
        result.addAll(preceding);
        result.addAll(following);
        return result;
    }

    @Override
    public Set<EPackage> getRegisteredEPackages() {
        return new LinkedHashSet<EPackage>(this.ePackages.values());
    }
}

