/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Other;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;

@ServiceProvider(value="Services available for all types")
public class AnyServices
extends AbstractServiceProvider {
    private final IReadOnlyQueryEnvironment queryEnvironment;

    public AnyServices(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    @Override
    protected IService getService(Method publicMethod) {
        Service result = "oclAsType".equals(publicMethod.getName()) ? new FilterService(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment environment, List<IType> argTypes) {
                LinkedHashSet<IType> result = new LinkedHashSet<IType>();
                Object type = argTypes.get(1).getType();
                if (type instanceof EClassifier) {
                    result.add(new EClassifierType(environment, (EClassifier)type));
                } else if (type instanceof Class) {
                    result.add(new ClassType(environment, (Class)type));
                } else if (type != null) {
                    result.add(services.nothing("Don't know what kind of type is %s", type));
                } else {
                    result.add(services.nothing("Don't know what kind of type is %s", "null"));
                }
                return result;
            }
        } : new Service(publicMethod, this);
        return result;
    }

    @Documentation(value="Indicates whether the object <code>o1</code> is the same as the object <code>o2</code>. For more information refer to the Object#equals(Object) method.", params={@Param(name="o1", value="The object to compare for equality"), @Param(name="o2", value="The reference object with which to compare")}, result="true</code> if the object <code>o1</code> is the same as the object <code>o2</code>, <code>false</code> otherwise", examples={@Example(expression="'Hello'.equals('World')", result="false"), @Example(expression="'Hello'.equals('Hello')", result="true")})
    public Boolean equals(Object o1, Object o2) {
        boolean result = o1 == null ? o2 == null : o1.equals(o2);
        return result;
    }

    @Documentation(value="Indicates whether the object <code>o1</code> is a different object from the object <code>o2</code>.", params={@Param(name="o1", value="The object to compare"), @Param(name="o2", value="The reference object with which to compare")}, result="<code>true</code> if the object <code>o1</code> is not the same as the object <code>o2</code>, <code>false</code> otherwise.", examples={@Example(expression="'Hello'.differs('World')", result="true"), @Example(expression="'Hello'.differs('Hello')", result="false")})
    public Boolean differs(Object o1, Object o2) {
        return this.equals(o1, o2) == false;
    }

    @Documentation(value="Returns the concatenation of self (as a String) and the given string \"s\".", params={@Param(name="self", value="The current object at the end of which to append \"s\"."), @Param(name="s", value="The string we want to append at the end of the current object's string representation.")}, result="The string representation of self for which we added the string \"s\".", examples={@Example(expression="42.add(' times')", result="'42 times'")})
    public String add(Object self, String s) {
        String result = s == null ? this.toString(self) : String.valueOf(this.toString(self)) + s;
        return result;
    }

    @Documentation(value="Returns the concatenation of the current string and the given object \"any\" (as a String).", params={@Param(name="self", value="The current string."), @Param(name="any", value="The object we want to append, as a string, at the end of the current string.")}, result="The current string with the object \"any\" appended (as a String).", examples={@Example(expression="'times '.add(42)", result="'times 42'")})
    public String add(String self, Object any) {
        String result = self == null ? this.toString(any) : String.valueOf(self) + this.toString(any);
        return result;
    }

    @Documentation(value="Casts the current object to the given type.", params={@Param(name="object", value="The object to cast"), @Param(name="type", value="The type to cast the object to")}, result="The current object cast to a \"type\"", examples={@Example(expression="anEPackage.oclAsType(ecore::EPackage)", result="anEPackage", others={@Other(language="Acceleo 3 (MTL)", expression="anEPackage.oclAsType(ecore::EPackage)", result="anEPackage")}), @Example(expression="anEPackage.oclAsType(ecore::EClass)", result="anEPackage", others={@Other(language="Acceleo 3 (MTL)", expression="anEPackage.oclAsType(ecore::EClass)", result="oclInvalid")})}, comment="Contrary to Acceleo 3, the type is ignored, the given object will be returned directly.")
    public Object oclAsType(Object object, Object type) {
        return object;
    }

    @Documentation(value="Evaluates to <code>true</code> if the type of the object o1 conforms to the type \"classifier\". That is, o1 is of type \"classifier\" or a subtype of \"classifier\".", params={@Param(name="object", value="The reference Object we seek to test."), @Param(name="type", value="The expected supertype classifier.")}, result="<code>true</code> if the object o1 is a kind of the classifier, <code>false</code> otherwise.", examples={@Example(expression="anEPackage.oclIsKindOf(ecore::EPackage)", result="true"), @Example(expression="anEPackage.oclIsKindOf(ecore::ENamedElement)", result="true")})
    public Boolean oclIsKindOf(Object object, Object type) {
        Boolean result;
        if (type instanceof EClass) {
            this.checkRegistered((EClassifier)((EClass)type));
            EClass eClass = (EClass)type;
            result = object instanceof EObject ? Boolean.valueOf(eClass.isSuperTypeOf(((EObject)object).eClass())) : Boolean.valueOf(false);
        } else if (type instanceof EEnum) {
            this.checkRegistered((EClassifier)((EEnum)type));
            if (object instanceof EEnumLiteral) {
                result = ((EEnumLiteral)object).getEEnum().equals(type);
            } else if (object instanceof Enumerator) {
                EEnumLiteral literal = ((EEnum)type).getEEnumLiteral(((Enumerator)object).getName());
                result = literal.getEEnum().equals(type);
            } else {
                result = false;
            }
        } else if (type instanceof EDataType) {
            Class<?> cls = this.checkRegistered((EClassifier)((EDataType)type));
            result = object != null ? Boolean.valueOf(cls.isAssignableFrom(object.getClass())) : Boolean.valueOf(false);
        } else {
            result = object != null && type instanceof Class ? Boolean.valueOf(((Class)type).isAssignableFrom(object.getClass())) : Boolean.valueOf(false);
        }
        return result;
    }

    @Documentation(value="Evaluates to <code>true</code> if the object o1 if of the type \"classifier\" but not a subtype of the \"classifier\".", params={@Param(name="object", value="The reference Object we seek to test."), @Param(name="type", value="The expected type classifier.")}, result="<code>true</code> if the object o1 is a type of the classifier, <code>false</code> otherwise.", examples={@Example(expression="anEPackage.oclIsKindOf(ecore::EPackage)", result="true"), @Example(expression="anEPackage.oclIsKindOf(ecore::ENamedElement)", result="false")})
    public Boolean oclIsTypeOf(Object object, Object type) {
        Boolean result;
        if (type instanceof EClass) {
            this.checkRegistered((EClassifier)((EClass)type));
            EClass eClass = (EClass)type;
            result = object instanceof EObject ? Boolean.valueOf(eClass == ((EObject)object).eClass()) : Boolean.valueOf(false);
        } else if (type instanceof EEnum) {
            this.checkRegistered((EClassifier)((EEnum)type));
            if (object instanceof EEnumLiteral) {
                result = ((EEnumLiteral)object).getEEnum().equals(type);
            } else if (object instanceof Enumerator) {
                EEnumLiteral literal = ((EEnum)type).getEEnumLiteral(((Enumerator)object).getName());
                result = literal.getEEnum().equals(type);
            } else {
                result = false;
            }
        } else if (type instanceof EDataType) {
            Class<?> cls = this.checkRegistered((EClassifier)((EDataType)type));
            result = object != null ? Boolean.valueOf(cls.isAssignableFrom(object.getClass())) : Boolean.valueOf(false);
        } else {
            result = object != null && type instanceof Class ? Boolean.valueOf(((Class)type).equals(object.getClass())) : Boolean.valueOf(false);
        }
        return result;
    }

    private Class<?> checkRegistered(EClassifier type) throws IllegalArgumentException {
        Class<?> result = this.queryEnvironment.getEPackageProvider().getClass(type);
        if (result == null) {
            throw new IllegalArgumentException(String.format("%s is not registered in the current environment", type));
        }
        return result;
    }

    @Documentation(value="Returns a string representation of the current object.", params={@Param(name="self", value="The current object"), @Param(name="", value="")}, result="a String representation of the given Object. For Collections, this will be the concatenation of all contained Objects' toString.", examples={@Example(expression="42.toString()", result="'42'")})
    public String toString(Object object) {
        String toString;
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Collection) {
            Iterator childrenIterator = ((Collection)object).iterator();
            while (childrenIterator.hasNext()) {
                buffer.append(this.toString(childrenIterator.next()));
            }
        } else if (object != null && !(object instanceof Nothing) && (toString = object.toString()) != null) {
            buffer.append(toString);
        }
        return buffer.toString();
    }
}

