/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.workspace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;

final class AcceleoDeltaVisitor
implements IResourceDeltaVisitor {
    private List<String> changedClasses = new ArrayList<String>();
    private List<IProject> changedProjects = new ArrayList<IProject>();

    AcceleoDeltaVisitor() {
    }

    public List<String> getChangedClasses() {
        return this.changedClasses;
    }

    public List<IProject> getChangedProjects() {
        return this.changedProjects;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta == null || (delta.getKind() & 4) == 0) {
            return false;
        }
        boolean visit = false;
        IResource resource = delta.getResource();
        if (resource != null) {
            switch (resource.getType()) {
                case 1: {
                    if ((delta.getFlags() & 0x100) == 0 || !"class".equals(resource.getFullPath().getFileExtension())) break;
                    IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)resource.getLocation().toOSString(), (int)17);
                    this.changedClasses.add(new String(reader.getClassName()).replace("/", "."));
                    break;
                }
                case 4: {
                    this.changedProjects.add((IProject)resource);
                    visit = true;
                    break;
                }
                default: {
                    visit = true;
                }
            }
        }
        return visit;
    }
}

