/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ServiceRegistrationResult {
    private final List<Method> registered = new ArrayList<Method>();
    private final Map<Method, List<Method>> duplicated = new LinkedHashMap<Method, List<Method>>();
    private final Map<Method, List<Method>> masked = new LinkedHashMap<Method, List<Method>>();
    private final Map<Method, List<Method>> isMaskedBy = new LinkedHashMap<Method, List<Method>>();

    public List<Method> getRegistered() {
        return this.registered;
    }

    public Map<Method, List<Method>> getDuplicated() {
        return this.duplicated;
    }

    public Map<Method, List<Method>> getMasked() {
        return this.masked;
    }

    public Map<Method, List<Method>> getIsMaskedBy() {
        return this.isMaskedBy;
    }

    public void merge(ServiceRegistrationResult otherResult) {
        this.registered.addAll(otherResult.registered);
        this.duplicated.putAll(otherResult.duplicated);
        this.masked.putAll(otherResult.masked);
        this.isMaskedBy.putAll(otherResult.isMaskedBy);
    }

    public void addDuplicated(Method newMethod, Method duplicatedMethod) {
        List<Method> methods = this.duplicated.get(newMethod);
        if (methods == null) {
            methods = new ArrayList<Method>();
            this.duplicated.put(newMethod, methods);
        }
        methods.add(duplicatedMethod);
    }

    public void addMasked(Method newMethod, Method maskedMethod) {
        List<Method> methods = this.masked.get(newMethod);
        if (methods == null) {
            methods = new ArrayList<Method>();
            this.masked.put(newMethod, methods);
        }
        methods.add(maskedMethod);
    }

    public void addIsMaskedBy(Method newMethod, Method isMaskedByMethod) {
        List<Method> methods = this.isMaskedBy.get(newMethod);
        if (methods == null) {
            methods = new ArrayList<Method>();
            this.isMaskedBy.put(newMethod, methods);
        }
        methods.add(isMaskedByMethod);
    }
}

