/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.query.collections.Operation;

public abstract class LazyCollection<E>
implements Collection<E> {
    static final String OPERATION_NOT_SUPPORTED_MESSAGE = "operation isn't supported in LazyList instances";
    private static final int REALIZATION_STEP_SIZE = 20;
    private int realizationStep;
    private Collection<E> realizedElements;
    private Iterator<E> iterator;
    private Iterable<E> iterable;

    public LazyCollection(Iterable<E> iterable) {
        this.iterable = iterable;
        this.iterator = iterable.iterator();
        this.realizedElements = this.createRealizedCollection();
        this.realizationStep = 20;
    }

    protected abstract Collection<E> createRealizedCollection();

    Collection<E> getRealizedElements() {
        return this.realizedElements;
    }

    public LazyCollection(Iterable<E> iterable, int step) {
        this(iterable);
        this.realizationStep = step;
    }

    protected void realize(int number) {
        while (this.sourceHasNext() && this.realizedElements.size() < number) {
            this.realizeNext();
        }
    }

    protected List<E> realizeNext() {
        int i = 0;
        ArrayList<E> result = new ArrayList<E>(this.realizationStep);
        while (this.sourceHasNext() && i < this.realizationStep) {
            E element = this.iterator.next();
            this.realizedElements.add(element);
            result.add(element);
            ++i;
        }
        return result;
    }

    protected void runFull(Operation<E> op) {
        Iterator<E> realizedIterator = this.realizedElements.iterator();
        while (realizedIterator.hasNext()) {
            op.execute(realizedIterator.next());
        }
        while (this.sourceHasNext()) {
            E element = this.iterator.next();
            this.realizedElements.add(element);
            op.execute(element);
        }
    }

    @Override
    public boolean add(E arg0) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        for (Object obj : arg0) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.realizedElements.isEmpty() && !this.sourceHasNext();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public int size() {
        while (this.sourceHasNext()) {
            this.realizeNext();
        }
        return this.realizedElements.size();
    }

    @Override
    public Object[] toArray() {
        while (this.sourceHasNext()) {
            this.realizeNext();
        }
        return this.realizedElements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        while (this.sourceHasNext()) {
            this.realizeNext();
        }
        return this.realizedElements.toArray(a);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean contains(Object arg0) {
        block1: {
            found = false;
            if (!this.realizedElements.contains(arg0)) ** GOTO lbl8
            found = true;
            break block1;
lbl-1000:
            // 1 sources

            {
                elements = this.realizeNext();
                if (!elements.contains(arg0)) continue;
                found = true;
lbl8:
                // 3 sources

                ** while (!found && this.sourceHasNext())
            }
        }
        return found;
    }

    protected boolean sourceHasNext() {
        boolean result;
        if (this.iterator != null) {
            if (this.iterator.hasNext()) {
                result = true;
            } else {
                result = false;
                this.iterable = null;
                this.iterator = null;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        Iterator<E> result = this.iterable != null ? this.iterable.iterator() : this.realizedElements.iterator();
        return result;
    }
}

