/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.LambdaType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;

public class CollectionServices
extends AbstractServiceProvider {
    @Override
    protected IService getService(Method publicMethod) {
        Service result = "filter".equals(publicMethod.getName()) ? new SecondArgumentTypeInFirstArgumentCollectionType(publicMethod, this) : ("add".equals(publicMethod.getName()) || "concat".equals(publicMethod.getName()) || "union".equals(publicMethod.getName()) ? new ReturnCollectionTypeWithFirstAndSecondArgumentRawCollectionType(publicMethod, this) : ("asSequence".equals(publicMethod.getName()) || "asSet".equals(publicMethod.getName()) || "asOrderedSet".equals(publicMethod.getName()) ? new ReturnCollectionTypeWithFirstArgumentRawCollectionType(publicMethod, this) : ("first".equals(publicMethod.getName()) || "at".equals(publicMethod.getName()) || "last".equals(publicMethod.getName()) ? new FirstArgumentRawCollectionType(publicMethod, this) : ("excluding".equals(publicMethod.getName()) || "sub".equals(publicMethod.getName()) ? new FirstCollectionTypeService(publicMethod, this) : ("reject".equals(publicMethod.getName()) ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
                LinkedHashSet<IType> result = new LinkedHashSet<IType>();
                LambdaType lambdaType = (LambdaType)argTypes.get(1);
                Object lambdaExpressionType = lambdaType.getLambdaExpressionType().getType();
                if (CollectionServices.isBooleanType(lambdaExpressionType)) {
                    if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                        result.add(new SequenceType(((ICollectionType)argTypes.get(0)).getCollectionType()));
                    } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                        result.add(new SetType(((ICollectionType)argTypes.get(0)).getCollectionType()));
                    }
                } else {
                    result.add(new NothingType("expression in a reject must return a boolean"));
                }
                return result;
            }
        } : ("select".equals(publicMethod.getName()) ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
                LinkedHashSet<IType> result = new LinkedHashSet<IType>();
                LambdaType lambdaType = (LambdaType)argTypes.get(1);
                Object lambdaExpressionType = lambdaType.getLambdaExpressionType().getType();
                if (CollectionServices.isBooleanType(lambdaExpressionType)) {
                    IType lambdaEvaluatorType = lambdaType.getLambdaEvaluatorType();
                    if (lambdaEvaluatorType instanceof EClassifierLiteralType) {
                        lambdaEvaluatorType = new EClassifierType(((EClassifierLiteralType)lambdaEvaluatorType).getType());
                    }
                    if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                        result.add(new SequenceType(lambdaEvaluatorType));
                    } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                        result.add(new SetType(lambdaEvaluatorType));
                    }
                } else {
                    result.add(new NothingType("expression in a select must return a boolean"));
                }
                return result;
            }
        } : ("collect".equals(publicMethod.getName()) ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
                LinkedHashSet<IType> result = new LinkedHashSet<IType>();
                LambdaType lambdaType = (LambdaType)argTypes.get(1);
                if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                    result.add(new SequenceType(lambdaType.getLambdaExpressionType()));
                } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                    result.add(new SetType(lambdaType.getLambdaExpressionType()));
                }
                return result;
            }
        } : ("including".equals(publicMethod.getName()) ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
                LinkedHashSet<IType> result = new LinkedHashSet<IType>();
                if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                    result.add(new SequenceType(((ICollectionType)argTypes.get(0)).getCollectionType()));
                    result.add(new SequenceType(argTypes.get(1)));
                } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                    result.add(new SetType(((ICollectionType)argTypes.get(0)).getCollectionType()));
                    result.add(new SetType(argTypes.get(1)));
                }
                return result;
            }
        } : ("sep".equals(publicMethod.getName()) ? (publicMethod.getParameterTypes().length == 2 ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
                LinkedHashSet<IType> result = new LinkedHashSet<IType>();
                result.add(argTypes.get(0));
                result.add(new SequenceType(argTypes.get(1)));
                return result;
            }
        } : (publicMethod.getParameterTypes().length == 4 ? new Service(publicMethod, this){

            @Override
            public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
                LinkedHashSet<IType> result = new LinkedHashSet<IType>();
                result.add(argTypes.get(0));
                result.add(new SequenceType(argTypes.get(1)));
                result.add(new SequenceType(argTypes.get(2)));
                result.add(new SequenceType(argTypes.get(3)));
                return result;
            }
        } : new Service(publicMethod, this))) : new Service(publicMethod, this))))))))));
        return result;
    }

    private static boolean isBooleanType(Object type) {
        return type instanceof EClassifier && (((EClassifier)type).getInstanceClass() == Boolean.class || ((EClassifier)type).getInstanceClass() == Boolean.TYPE);
    }

    public List<Object> concat(List<Object> c1, List<Object> c2) {
        ArrayList result;
        if (c1.isEmpty()) {
            result = c2;
        } else if (c2.isEmpty()) {
            result = c1;
        } else {
            result = Lists.newArrayList(c1);
            result.addAll(c2);
        }
        return result;
    }

    public List<Object> add(List<Object> l1, List<Object> l2) {
        return this.concat(l1, l2);
    }

    public List<Object> sub(List<Object> l1, List<Object> l2) {
        if (l2.isEmpty()) {
            return l1;
        }
        ArrayList result = Lists.newArrayList(l1);
        for (Object obj : l2) {
            result.remove(obj);
        }
        return result;
    }

    public Set<Object> sub(Set<Object> l1, Set<Object> l2) {
        if (l2.isEmpty()) {
            return l1;
        }
        LinkedHashSet result = Sets.newLinkedHashSet(l1);
        for (Object obj : l2) {
            result.remove(obj);
        }
        return result;
    }

    public Set<Object> add(Set<Object> l1, Set<Object> l2) {
        return Sets.union(l1, l2);
    }

    public List<Object> select(List<Object> l1, Lambda lambda) {
        ArrayList newList;
        if (lambda == null) {
            newList = Collections.emptyList();
        } else {
            newList = Lists.newArrayList();
            for (Object elt : l1) {
                try {
                    if (!Boolean.TRUE.equals(lambda.eval(new Object[]{elt}))) continue;
                    newList.add(elt);
                }
                catch (Exception exception) {}
            }
        }
        return newList;
    }

    public Set<Object> select(Set<Object> l1, Lambda lambda) {
        LinkedHashSet newSet;
        if (lambda == null) {
            newSet = Collections.emptySet();
        } else {
            newSet = Sets.newLinkedHashSet();
            for (Object elt : l1) {
                try {
                    if (!Boolean.TRUE.equals(lambda.eval(new Object[]{elt}))) continue;
                    newSet.add(elt);
                }
                catch (Exception exception) {}
            }
        }
        return newSet;
    }

    public Set<Object> reject(Set<Object> l1, Lambda lambda) {
        LinkedHashSet newSet;
        if (lambda == null) {
            newSet = Collections.emptySet();
        } else {
            newSet = Sets.newLinkedHashSet();
            for (Object elt : l1) {
                try {
                    if (!Boolean.FALSE.equals(lambda.eval(new Object[]{elt}))) continue;
                    newSet.add(elt);
                }
                catch (Exception exception) {}
            }
        }
        return newSet;
    }

    public List<Object> reject(List<Object> l1, Lambda lambda) {
        ArrayList newList;
        if (lambda == null) {
            newList = Collections.emptyList();
        } else {
            newList = Lists.newArrayList();
            for (Object elt : l1) {
                try {
                    if (!Boolean.FALSE.equals(lambda.eval(new Object[]{elt}))) continue;
                    newList.add(elt);
                }
                catch (Exception exception) {}
            }
        }
        return newList;
    }

    public Set<Object> collect(Set<Object> set, Lambda lambda) {
        LinkedHashSet result;
        if (lambda == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (Object elt : set) {
                try {
                    result.add(lambda.eval(new Object[]{elt}));
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public List<Object> collect(List<Object> list, Lambda lambda) {
        ArrayList result;
        if (lambda == null) {
            result = Collections.emptyList();
        } else {
            result = Lists.newArrayList();
            for (Object elt : list) {
                try {
                    result.add(lambda.eval(new Object[]{elt}));
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public Integer size(Collection<Object> collection) {
        return collection.size();
    }

    public Set<Object> including(Set<Object> source, Object object) {
        if (source.contains(object)) {
            return source;
        }
        LinkedHashSet result = Sets.newLinkedHashSet(source);
        result.add(object);
        return result;
    }

    public Set<Object> excluding(Set<Object> source, Object object) {
        if (!source.contains(object)) {
            return source;
        }
        LinkedHashSet result = Sets.newLinkedHashSet(source);
        result.remove(object);
        return result;
    }

    public List<Object> including(List<Object> source, Object object) {
        if (source.contains(object)) {
            return source;
        }
        ArrayList result = Lists.newArrayList(source);
        result.add(object);
        return result;
    }

    public List<Object> excluding(List<Object> source, Object object) {
        if (!source.contains(object)) {
            return source;
        }
        ArrayList result = Lists.newArrayList(source);
        result.remove(object);
        return result;
    }

    public List<Object> asSequence(Collection<Object> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return Lists.newArrayList(collection);
    }

    public Set<Object> asSet(Collection<Object> collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        return Sets.newLinkedHashSet(collection);
    }

    public Set<Object> asOrderedSet(Collection<Object> collection) {
        return this.asSet(collection);
    }

    public Object first(List<Object> list) {
        return list.get(0);
    }

    public Boolean isEmpty(Collection<Object> collection) {
        return collection.isEmpty();
    }

    public Boolean notEmpty(Collection<Object> collection) {
        return !collection.isEmpty();
    }

    public Object at(List<Object> list, Integer position) {
        return list.get(position - 1);
    }

    public Collection<Object> removeAll(Collection<Object> collection1, Collection<Object> collection2) {
        collection1.removeAll(collection2);
        return collection1;
    }

    public Set<Object> filter(Set<Object> set, EClass eClassifier) {
        LinkedHashSet result;
        if (set == null) {
            result = null;
        } else if (eClassifier == null) {
            result = Sets.newLinkedHashSet();
        } else {
            result = Sets.newLinkedHashSet();
            for (Object object : set) {
                if (!eClassifier.isInstance(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    public List<Object> filter(List<Object> list, EClassifier eClassifier) {
        ArrayList result;
        if (list == null) {
            result = null;
        } else if (eClassifier == null) {
            result = Lists.newArrayList();
        } else {
            result = Lists.newArrayList();
            for (Object object : list) {
                if (!eClassifier.isInstance(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    public List<Object> sep(Collection<Object> collection, Object separator) {
        ArrayList result;
        if (collection == null) {
            result = null;
        } else {
            result = Lists.newArrayList();
            Iterator<Object> it = collection.iterator();
            if (it.hasNext()) {
                result.add(it.next());
                while (it.hasNext()) {
                    result.add(separator);
                    result.add(it.next());
                }
            }
        }
        return result;
    }

    public List<Object> sep(Collection<Object> collection, Object prefix, Object separator, Object suffix) {
        ArrayList result = Lists.newArrayList();
        result.add(prefix);
        if (collection != null) {
            result.addAll(this.sep(collection, separator));
        }
        result.add(suffix);
        return result;
    }

    public Object last(List<Object> list) {
        return list.get(list.size() - 1);
    }

    public Boolean excludes(Collection<Object> collection, Object object) {
        return !collection.contains(object);
    }

    public Boolean includes(Collection<Object> collection, Object object) {
        return collection.contains(object);
    }

    public Set<Object> union(Set<Object> c1, Set<Object> c2) {
        return this.add(c1, c2);
    }

    public List<Object> union(List<Object> c1, List<Object> c2) {
        return this.concat(c1, c2);
    }

    private static final class FirstArgumentRawCollectionType
    extends Service {
        private FirstArgumentRawCollectionType(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            result.add(((ICollectionType)argTypes.get(0)).getCollectionType());
            return result;
        }
    }

    private static final class FirstCollectionTypeService
    extends Service {
        public FirstCollectionTypeService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(((ICollectionType)argTypes.get(0)).getCollectionType()));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(((ICollectionType)argTypes.get(0)).getCollectionType()));
            }
            return result;
        }
    }

    private static final class ReturnCollectionTypeWithFirstAndSecondArgumentRawCollectionType
    extends Service {
        private ReturnCollectionTypeWithFirstAndSecondArgumentRawCollectionType(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(((ICollectionType)argTypes.get(0)).getCollectionType()));
                result.add(new SequenceType(((ICollectionType)argTypes.get(1)).getCollectionType()));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(((ICollectionType)argTypes.get(0)).getCollectionType()));
                result.add(new SetType(((ICollectionType)argTypes.get(1)).getCollectionType()));
            }
            return result;
        }
    }

    private static final class ReturnCollectionTypeWithFirstArgumentRawCollectionType
    extends Service {
        private ReturnCollectionTypeWithFirstArgumentRawCollectionType(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(((ICollectionType)argTypes.get(0)).getCollectionType()));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(((ICollectionType)argTypes.get(0)).getCollectionType()));
            }
            return result;
        }
    }

    private static final class SecondArgumentTypeInFirstArgumentCollectionType
    extends Service {
        SecondArgumentTypeInFirstArgumentCollectionType(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            EClassifierType rawType = new EClassifierType(((EClassifierLiteralType)argTypes.get(1)).getType());
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(rawType));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(rawType));
            }
            return result;
        }
    }
}

