/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.lookup.opt;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.InvalidAcceleoPackageException;
import org.eclipse.acceleo.query.runtime.lookup.opt.InnerLookupNode;
import org.eclipse.acceleo.query.runtime.lookup.opt.LeafLookupNode;
import org.eclipse.acceleo.query.runtime.lookup.opt.LookupNode;
import org.eclipse.acceleo.query.runtime.lookup.opt.Service;

public class LookupEngine {
    private final Map<String, LookupNode> multiMethods = new HashMap<String, LookupNode>();

    public void addService(Method method, Object instance) {
        String key = method.getName() + '_' + method.getParameterTypes().length;
        LookupNode node = this.multiMethods.get(key);
        if (node == null) {
            node = method.getParameterTypes().length == 0 ? new LeafLookupNode() : new InnerLookupNode();
            this.multiMethods.put(key, node);
        }
        node.addMethod(new Service(method, instance), 0);
    }

    public IService lookup(String name, Class<?>[] argumentTypes) {
        String key = name + '_' + argumentTypes.length;
        LookupNode node = this.multiMethods.get(key);
        if (node != null) {
            return node.lookup(argumentTypes, 0);
        }
        return null;
    }

    public void addServices(Class<?> serviceClass) throws InvalidAcceleoPackageException {
    }
}

