/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.quickoutline;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringMatcher {
    private final String expression;
    private final boolean ignoreCase;
    private Pattern pattern;

    public StringMatcher(String pattern, boolean ignoreCase) {
        this.expression = this.translatePattern(pattern);
        this.ignoreCase = ignoreCase;
    }

    protected String translatePattern(String pattern) {
        Object expression = pattern.replaceAll("\\(", "\\\\(");
        expression = ((String)expression).replaceAll("\\)", "\\\\)");
        expression = ((String)expression).replaceAll("\\[", "\\\\[");
        expression = ((String)expression).replaceAll("\\]", "\\\\]");
        expression = ((String)expression).replaceAll("\\{", "\\\\{");
        expression = ((String)expression).replaceAll("\\}", "\\\\}");
        expression = ((String)expression).replaceAll("\\*", ".*");
        if (!((String)(expression = ((String)expression).replaceAll("\\?", "."))).startsWith("^")) {
            expression = "^" + (String)expression;
        }
        return expression;
    }

    protected Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = this.ignoreCase ? Pattern.compile(this.expression, 2) : Pattern.compile(this.expression);
        }
        return this.pattern;
    }

    public boolean match(String text) {
        try {
            return this.getPattern().matcher(text).find();
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }
}

