/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.AttributeTarget;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.DeviceType;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Multiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SegmentType;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.VarDeclarationImpl;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.InterfaceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public final class Annotations {
    public static AutomationSystem getAutomationSystem(Application a) {
        return (AutomationSystem)a.eContainer();
    }

    public static Algorithm getAlgorithmNamed(BaseFBType baseFBType, String name) {
        return baseFBType.getAlgorithm().stream().filter(alg -> alg.getName().equals(name)).findFirst().orElse(null);
    }

    public static boolean isResourceConnection(Connection c) {
        return c.getSourceElement() != null && c.getSourceElement().getFbNetwork() != null && c.getSourceElement().getFbNetwork().eContainer() instanceof Resource;
    }

    public static boolean isInterfaceConnection(Connection c) {
        return Annotations.isInterfaceConnection(c, null);
    }

    public static boolean isInterfaceConnection(Connection c, FBNetworkElement path) {
        EList<Connection> connections;
        boolean destinationIsInterface;
        if (c == null) {
            return false;
        }
        if (c instanceof EventConnection || c instanceof AdapterConnection) {
            return false;
        }
        BlockFBNetworkElement s = c.getSourceElement();
        BlockFBNetworkElement d = c.getDestinationElement();
        EObject container = c.eContainer().eContainer();
        boolean sourceIsInterface = s == container;
        boolean bl = destinationIsInterface = d == container;
        if (sourceIsInterface || destinationIsInterface) {
            return true;
        }
        if (s == path) {
            sourceIsInterface = false;
        } else if (s instanceof Demultiplexer) {
            connections = ((VarDeclaration)s.getInterface().getInputVars().get(0)).getInputConnections();
            sourceIsInterface = !connections.isEmpty() && Annotations.isInterfaceConnection((Connection)connections.get(0), s);
        } else if (s instanceof Multiplexer) {
            boolean bl2 = sourceIsInterface = s.getInterface().getInputVars().stream().anyMatch(v -> !v.getInputConnections().isEmpty()) && s.getInterface().getInputVars().stream().allMatch(v -> v.getInputConnections().stream().allMatch(co -> Annotations.isInterfaceConnection(co, s)));
        }
        if (d == path) {
            destinationIsInterface = false;
        } else if (d instanceof Demultiplexer) {
            destinationIsInterface = d.getInterface().getOutputVars().stream().anyMatch(v -> !v.getOutputConnections().isEmpty()) && d.getInterface().getOutputVars().stream().allMatch(v -> v.getOutputConnections().stream().allMatch(co -> Annotations.isInterfaceConnection(co, d)));
        } else if (d instanceof Multiplexer) {
            connections = ((VarDeclaration)d.getInterface().getOutputVars().get(0)).getOutputConnections();
            boolean bl3 = destinationIsInterface = !connections.isEmpty() && Annotations.isInterfaceConnection((Connection)connections.get(0), d);
        }
        return sourceIsInterface || destinationIsInterface;
    }

    public static void checkifConnectionBroken(Connection c) {
        if (!c.isResourceConnection()) {
            Resource sourceRes = c.getSourceElement() != null ? c.getSourceElement().getResource() : null;
            Resource destinationRes = c.getDestinationElement() != null ? c.getDestinationElement().getResource() : null;
            c.setBrokenConnection(sourceRes != null && !sourceRes.equals(destinationRes) || destinationRes != null && !destinationRes.equals(sourceRes));
        }
    }

    public static AutomationSystem getAutomationSystem(Device d) {
        return d.getSystemConfiguration().getAutomationSystem();
    }

    public static SystemConfiguration getSystemConfiguration(Device d) {
        return (SystemConfiguration)d.eContainer();
    }

    public static Resource getResourceNamed(Device device, String name) {
        return device.getResource().stream().filter(resource -> resource.getName().equals(name)).findFirst().orElse(null);
    }

    public static boolean isStartState(ECState ecs) {
        return ecs.getECC() != null && ecs.equals(ecs.getECC().getStart());
    }

    public static String getConditionText(ECTransition ect) {
        String expression;
        Object retVal = "";
        Event event = ect.getConditionEvent();
        if (event != null) {
            retVal = Annotations.getTransitionEventName(event);
        }
        if ((expression = ect.getConditionExpression()) != null) {
            if ("1".equals(expression)) {
                retVal = expression;
            } else if (!expression.isBlank()) {
                retVal = (String)retVal + "[" + expression + "]";
            }
        }
        return retVal;
    }

    public static String getTransitionEventName(Event event) {
        if (event.getBlockFBNetworkElement() instanceof AdapterFB) {
            return event.getBlockFBNetworkElement().getName() + "." + event.getName();
        }
        return event.getName();
    }

    public static AutomationSystem getAutomationSystem(Mapping m) {
        return m.eContainer() != null ? (AutomationSystem)m.eContainer() : null;
    }

    public static AutomationSystem getAutomationSystem(Resource r) {
        AutomationSystem system = null;
        if (r.getDevice() != null) {
            system = r.getDevice().getAutomationSystem();
        }
        return system;
    }

    public static void addConnection(FBNetwork fbn, Connection connection) {
        Annotations.addConnectionWithIndex(fbn, connection, -1);
    }

    public static void addConnectionWithIndex(FBNetwork fbn, Connection connection, int index) {
        if (connection instanceof EventConnection) {
            EventConnection evCon = (EventConnection)connection;
            if (index >= 0 && index < fbn.getEventConnections().size()) {
                fbn.getEventConnections().add(index, (Object)evCon);
            } else {
                fbn.getEventConnections().add((Object)evCon);
            }
        }
        if (connection instanceof DataConnection) {
            DataConnection dataCon = (DataConnection)connection;
            if (index >= 0 && index < fbn.getDataConnections().size()) {
                fbn.getDataConnections().add(index, (Object)dataCon);
            } else {
                fbn.getDataConnections().add((Object)dataCon);
            }
        }
        if (connection instanceof AdapterConnection) {
            AdapterConnection adpCon = (AdapterConnection)connection;
            if (index >= 0 && index < fbn.getAdapterConnections().size()) {
                fbn.getAdapterConnections().add(index, (Object)adpCon);
            } else {
                fbn.getAdapterConnections().add((Object)adpCon);
            }
        }
    }

    public static void removeConnection(FBNetwork fbn, Connection connection) {
        if (connection instanceof EventConnection) {
            fbn.getEventConnections().remove((Object)connection);
        }
        if (connection instanceof DataConnection) {
            fbn.getDataConnections().remove((Object)connection);
        }
        if (connection instanceof AdapterConnection) {
            fbn.getAdapterConnections().remove((Object)connection);
        }
    }

    public static int getConnectionIndex(FBNetwork fbn, Connection connection) {
        if (connection instanceof EventConnection) {
            return fbn.getEventConnections().indexOf((Object)connection);
        }
        if (connection instanceof DataConnection) {
            return fbn.getDataConnections().indexOf((Object)connection);
        }
        if (connection instanceof AdapterConnection) {
            return fbn.getAdapterConnections().indexOf((Object)connection);
        }
        return -1;
    }

    public static boolean isApplicationNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof Application;
    }

    public static boolean isSubApplicationNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof SubApp;
    }

    public static boolean isResourceNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof Resource;
    }

    public static boolean isCFBTypeNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof CompositeFBType;
    }

    public static AutomationSystem getAutomationSystem(FBNetwork fbn) {
        AutomationSystem system;
        EObject root = EcoreUtil.getRootContainer((EObject)fbn);
        return root instanceof AutomationSystem ? (system = (AutomationSystem)root) : null;
    }

    public static Application getApplication(FBNetwork fbn) {
        if (fbn.isApplicationNetwork()) {
            return (Application)fbn.eContainer();
        }
        if (fbn.isSubApplicationNetwork() && ((SubApp)fbn.eContainer()).getFbNetwork() != null) {
            return ((SubApp)fbn.eContainer()).getFbNetwork().getApplication();
        }
        return null;
    }

    public static FB getFBNamed(FBNetwork fbn, String name) {
        return fbn.getNetworkElements().stream().filter(FB.class::isInstance).map(FB.class::cast).filter(element -> element.getName().equals(name)).findFirst().orElse(null);
    }

    public static SubApp getSubAppNamed(FBNetwork fbn, String name) {
        return fbn.getNetworkElements().stream().filter(SubApp.class::isInstance).map(SubApp.class::cast).filter(element -> element.getName().equals(name)).findFirst().orElse(null);
    }

    public static FBNetworkElement getElementNamed(FBNetwork fbn, String name) {
        return fbn.getNetworkElements().stream().filter(element -> element.getName().equals(name)).findFirst().orElse(null);
    }

    public static Device getDeviceNamed(AutomationSystem as, String name) {
        return as.getSystemConfiguration() != null ? as.getSystemConfiguration().getDeviceNamed(name) : null;
    }

    public static Application getApplicationNamed(AutomationSystem as, String name) {
        return as.getApplication().stream().filter(element -> element.getName().equals(name)).findFirst().orElse(null);
    }

    public static boolean isArray(VarDeclaration vd) {
        return vd.getArraySize() != null && vd.getArraySize().getValue() != null && !vd.getArraySize().getValue().isBlank();
    }

    public static void setVarConfig(VarDeclarationImpl varDeclarationImpl, boolean config) {
        if (!config) {
            varDeclarationImpl.deleteAttribute("VarConfig");
        } else {
            Annotations.setVarConfig(varDeclarationImpl, Boolean.toString(config));
        }
    }

    private static void setVarConfig(VarDeclarationImpl varDeclarationImpl, String config) {
        varDeclarationImpl.setAttribute(InternalAttributeDeclarations.VAR_CONFIG, config, "");
    }

    public static boolean isVarConfig(VarDeclaration vd) {
        String configurationAttribute = vd.getAttributeValue("VarConfig");
        return "true".equals(configurationAttribute);
    }

    public static void setTarget(AttributeDeclaration attributeDeclaration, StructuredType target) {
        String targetString = target.getMemberVariables().stream().map(member -> member.getName() + ":=" + member.getValue().getValue()).collect(Collectors.joining(",", "(", ")"));
        if (!targetString.contains("FALSE")) {
            attributeDeclaration.deleteAttribute(InternalAttributeDeclarations.TARGET.getName());
        } else {
            attributeDeclaration.setAttribute(InternalAttributeDeclarations.TARGET, targetString, "");
        }
    }

    public static StructuredType getTarget(AttributeDeclaration attributeDeclaration) {
        String[] pairs;
        String targetString = attributeDeclaration.getAttributeValue(InternalAttributeDeclarations.TARGET.getName());
        if (targetString == null) {
            return null;
        }
        StructuredType structType = DataFactory.eINSTANCE.createStructuredType();
        targetString = targetString.substring(1, targetString.length() - 1);
        String[] stringArray = pairs = targetString.split(",");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] keyValue = pair.split(":=");
            if (keyValue.length == 2) {
                MemberVarDeclaration member = LibraryElementFactory.eINSTANCE.createMemberVarDeclaration();
                member.setName(keyValue[0]);
                member.setType(IecTypes.ElementaryTypes.BOOL);
                Value val = LibraryElementFactory.eINSTANCE.createValue();
                val.setValue(keyValue[1]);
                member.setValue(val);
                structType.getMemberVariables().add((Object)member);
            }
            ++n2;
        }
        if (structType.getMemberVariables().size() != ((StructuredType)InternalAttributeDeclarations.TARGET.getType()).getMemberVariables().size()) {
            ((StructuredType)InternalAttributeDeclarations.TARGET.getType()).getMemberVariables().forEach(varDecl -> {
                Optional<VarDeclaration> correctMember = structType.getMemberVariables().stream().filter(member -> member.getName().equals(varDecl.getName())).findFirst();
                if (correctMember.isEmpty()) {
                    structType.getMemberVariables().add((Object)((VarDeclaration)EcoreUtil.copy((EObject)varDecl)));
                }
            });
        }
        return structType;
    }

    public static boolean isValidObject(AttributeDeclaration attributeDeclaration, ConfigurableObject object) {
        boolean bl;
        ConfigurableObject configurableObject;
        StructuredType target = attributeDeclaration.getTarget();
        if (target == null) {
            return true;
        }
        if (object instanceof IInterfaceElement || object instanceof SubApp) {
            String key = object instanceof IInterfaceElement ? IInterfaceElement.class.getSimpleName() : SubApp.class.getSimpleName();
            Optional<VarDeclaration> correctMember = target.getMemberVariables().stream().filter(member -> member.getName().equals(key)).findFirst();
            if (correctMember.isPresent()) {
                Value val = correctMember.get().getValue();
                return Boolean.parseBoolean(val.getValue());
            }
        }
        ConfigurableObject configurableObject2 = object;
        Objects.requireNonNull(configurableObject2);
        ConfigurableObject configurableObject3 = configurableObject = configurableObject2;
        int n = 0;
        block33: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AutomationSystem.class, Application.class, GlobalConstants.class, Connection.class, Comment.class, Group.class, Link.class, ServiceSequence.class, SubAppType.class, FBType.class, DataType.class, AttributeDeclaration.class, DeviceType.class, ResourceType.class, SegmentType.class, TypedSubApp.class, UntypedSubApp.class, Device.class, Resource.class, Segment.class, FB.class, VarDeclaration.class, VarDeclaration.class, VarDeclaration.class, VarDeclaration.class, Event.class, Event.class, Event.class, AdapterDeclaration.class, AdapterDeclaration.class, AdapterDeclaration.class}, (Object)configurableObject3, n)) {
                case 0: {
                    AutomationSystem o = (AutomationSystem)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.AutomationSystem);
                    break block33;
                }
                case 1: {
                    Application o = (Application)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Application);
                    break block33;
                }
                case 2: {
                    GlobalConstants o = (GlobalConstants)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.GlobalConstant);
                    break block33;
                }
                case 3: {
                    Connection o = (Connection)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Connection);
                    break block33;
                }
                case 4: {
                    Comment o = (Comment)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Comment);
                    break block33;
                }
                case 5: {
                    Group o = (Group)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Group);
                    break block33;
                }
                case 6: {
                    Link o = (Link)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Link);
                    break block33;
                }
                case 7: {
                    ServiceSequence o = (ServiceSequence)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.ServiceSequence);
                    break block33;
                }
                case 8: {
                    SubAppType o = (SubAppType)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.SubAppType);
                    break block33;
                }
                case 9: {
                    FBType o = (FBType)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.FBType);
                    break block33;
                }
                case 10: {
                    DataType o = (DataType)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.DataType);
                    break block33;
                }
                case 11: {
                    AttributeDeclaration o = (AttributeDeclaration)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.AttributeDeclaration);
                    break block33;
                }
                case 12: {
                    DeviceType o = (DeviceType)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.DeviceType);
                    break block33;
                }
                case 13: {
                    ResourceType o = (ResourceType)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.ResourceType);
                    break block33;
                }
                case 14: {
                    SegmentType o = (SegmentType)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.SegmentType);
                    break block33;
                }
                case 15: {
                    TypedSubApp o = (TypedSubApp)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.TypedSubApp);
                    break block33;
                }
                case 16: {
                    UntypedSubApp o = (UntypedSubApp)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.UntypedSubApp);
                    break block33;
                }
                case 17: {
                    Device o = (Device)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Device);
                    break block33;
                }
                case 18: {
                    Resource o = (Resource)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Resource);
                    break block33;
                }
                case 19: {
                    Segment o = (Segment)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Segment);
                    break block33;
                }
                case 20: {
                    FB o = (FB)configurableObject;
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.FB);
                    break block33;
                }
                case 21: {
                    VarDeclaration decl = (VarDeclaration)configurableObject;
                    if (!(decl.eContainer() instanceof StructuredType)) {
                        configurableObject3 = configurableObject;
                        n = 22;
                        continue block33;
                    }
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.DataTypeMember);
                    break block33;
                }
                case 22: {
                    VarDeclaration decl = (VarDeclaration)configurableObject;
                    if (!(decl.eContainer() instanceof InterfaceList) || !(decl.eContainer().eContainer() instanceof FBType)) {
                        configurableObject3 = configurableObject;
                        n = 23;
                        continue block33;
                    }
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.TypeVarDecl);
                    break block33;
                }
                case 23: {
                    VarDeclaration decl = (VarDeclaration)configurableObject;
                    if (!(decl.eContainer() instanceof InterfaceList) || !(decl.eContainer().eContainer() instanceof UntypedSubApp)) {
                        configurableObject3 = configurableObject;
                        n = 24;
                        continue block33;
                    }
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Untyped_SubAppVarDecl);
                    break block33;
                }
                case 24: {
                    VarDeclaration decl = (VarDeclaration)configurableObject;
                    if (!(decl.eContainer() instanceof InterfaceList) || !(decl.eContainer().eContainer() instanceof FBNetworkElement)) {
                        configurableObject3 = configurableObject;
                        n = 25;
                        continue block33;
                    }
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.InstanceVarDecl);
                    break block33;
                }
                case 25: {
                    Event event = (Event)configurableObject;
                    if (event.eContainer() == null || !(event.eContainer().eContainer() instanceof FBType)) {
                        configurableObject3 = configurableObject;
                        n = 26;
                        continue block33;
                    }
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.TypeEvent);
                    break block33;
                }
                case 26: {
                    Event event = (Event)configurableObject;
                    if (event.eContainer() == null || !(event.eContainer().eContainer() instanceof UntypedSubApp)) {
                        configurableObject3 = configurableObject;
                        n = 27;
                        continue block33;
                    }
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Untyped_SubAppEvent);
                    break block33;
                }
                case 27: {
                    Event event = (Event)configurableObject;
                    if (event.eContainer() == null || !(event.eContainer().eContainer() instanceof FBNetworkElement)) {
                        configurableObject3 = configurableObject;
                        n = 28;
                        continue block33;
                    }
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.InstanceEvent);
                    break block33;
                }
                case 28: {
                    AdapterDeclaration adapter = (AdapterDeclaration)configurableObject;
                    if (adapter.eContainer() == null || !(adapter.eContainer().eContainer() instanceof FBType)) {
                        configurableObject3 = configurableObject;
                        n = 29;
                        continue block33;
                    }
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.TypeAdapter);
                    break block33;
                }
                case 29: {
                    AdapterDeclaration adapter = (AdapterDeclaration)configurableObject;
                    if (adapter.eContainer() == null || !(adapter.eContainer().eContainer() instanceof UntypedSubApp)) {
                        configurableObject3 = configurableObject;
                        n = 30;
                        continue block33;
                    }
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.Untyped_SubAppAdapter);
                    break block33;
                }
                case 30: {
                    AdapterDeclaration adapter = (AdapterDeclaration)configurableObject;
                    if (adapter.eContainer() == null || !(adapter.eContainer().eContainer() instanceof FBNetworkElement)) {
                        configurableObject3 = configurableObject;
                        n = 31;
                        continue block33;
                    }
                    bl = Annotations.getValueFromTarget(target, AttributeTarget.InstanceAdapter);
                    break block33;
                }
                default: {
                    bl = false;
                }
            }
            break;
        }
        return bl;
    }

    private static boolean getValueFromTarget(StructuredType lock, AttributeTarget target) {
        Optional<VarDeclaration> correctMember = lock.getMemberVariables().stream().filter(member -> member.getName().equals(target.name())).findFirst();
        if (correctMember.isPresent()) {
            Value val = correctMember.get().getValue();
            return Boolean.parseBoolean(val.getValue());
        }
        return true;
    }

    public static void setAttribute(ConfigurableObject object, String attributeName, DataType type, String value, String comment) {
        Attribute attribute = Annotations.getAttribute(object, attributeName);
        if (attribute == null) {
            attribute = LibraryElementFactory.eINSTANCE.createAttribute();
            attribute.setName(attributeName);
            attribute.setType(type);
            attribute.setValue(value);
            if (comment != null) {
                attribute.setComment(comment);
            }
            object.getAttributes().add((Object)attribute);
        } else {
            attribute.setValue(value);
            if (comment != null) {
                attribute.setComment(comment);
            }
        }
    }

    public static void setAttribute(ConfigurableObject object, AttributeDeclaration attributeDeclaration, String value, String comment) {
        Attribute attribute = Annotations.getAttribute(object, PackageNameHelper.getFullTypeName(attributeDeclaration));
        if (attribute == null) {
            attribute = LibraryElementFactory.eINSTANCE.createAttribute();
            attribute.setName(PackageNameHelper.getFullTypeName(attributeDeclaration));
            attribute.setAttributeDeclaration(attributeDeclaration);
            attribute.setType(attributeDeclaration.getType());
            attribute.setValue(value);
            if (comment != null) {
                attribute.setComment(comment);
            }
            object.getAttributes().add((Object)attribute);
        } else {
            attribute.setValue(value);
            if (comment != null) {
                attribute.setComment(comment);
            }
        }
    }

    public static boolean deleteAttribute(ConfigurableObject object, String attributeName) {
        if (object != null && attributeName != null) {
            List<Attribute> toDelete = object.getAttributes().stream().filter(attr -> attributeName.equals(attr.getName())).toList();
            if (toDelete.isEmpty()) {
                return false;
            }
            toDelete.forEach(attr -> {
                boolean bl = object.getAttributes().remove(attr);
            });
            return true;
        }
        return false;
    }

    public static String getAttributeValue(ConfigurableObject object, String attributeName) {
        Attribute a = Annotations.getAttribute(object, attributeName);
        return a != null ? a.getValue() : null;
    }

    public static Attribute getAttribute(ConfigurableObject object, String attributeName) {
        return attributeName != null ? (Attribute)object.getAttributes().stream().filter(attribute -> attribute.getName().equalsIgnoreCase(attributeName)).findFirst().orElse(null) : null;
    }

    public static VarDeclaration getDataSource(DataConnection dc) {
        return (VarDeclaration)dc.getSource();
    }

    public static VarDeclaration getDataDestination(DataConnection dc) {
        return (VarDeclaration)dc.getDestination();
    }

    public static Event getEventSource(EventConnection ec) {
        return (Event)ec.getSource();
    }

    public static Event getEventDestination(EventConnection ec) {
        return (Event)ec.getDestination();
    }

    public static AdapterDeclaration getAdapterSource(AdapterConnection ac) {
        return (AdapterDeclaration)ac.getSource();
    }

    public static AdapterDeclaration getAdapterDestination(AdapterConnection ac) {
        return (AdapterDeclaration)ac.getDestination();
    }

    public static AutomationSystem getAutomationSystem(SystemConfiguration sc) {
        return (AutomationSystem)sc.eContainer();
    }

    public static Segment getSegmentNamed(SystemConfiguration sc, String name) {
        return sc.getSegments().stream().filter(segment -> segment.getName().equals(name)).findFirst().orElse(null);
    }

    public static Device getDeviceNamed(SystemConfiguration sc, String name) {
        return sc.getDevices().stream().filter(device -> device.getName().equals(name)).findFirst().orElse(null);
    }

    public static boolean isResourceTypeFB() {
        return true;
    }

    public static String getTypeName(TypedConfigureableObject tco) {
        return tco.getTypeEntry() != null ? tco.getTypeEntry().getTypeName() : null;
    }

    public static LibraryElement getType(TypedConfigureableObject tco) {
        return tco.getTypeEntry() != null ? tco.getTypeEntry().getType() : null;
    }

    public static TypeLibrary getTypeLibrary(TypedConfigureableObject tco) {
        return tco.getTypeEntry() != null ? tco.getTypeEntry().getTypeLibrary() : null;
    }

    public static boolean isSocket(AdapterFB afb) {
        return !afb.isPlug();
    }

    public static FBType getType(AdapterFB afb) {
        InterfaceTypeEntry interfaceTypeEntry = afb.getTypeEntry();
        if (interfaceTypeEntry instanceof AdapterTypeEntry) {
            AdapterTypeEntry adpTypeEntry = (AdapterTypeEntry)interfaceTypeEntry;
            if (afb.getAdapterDecl() != null) {
                if (afb.isPlug()) {
                    return adpTypeEntry.getType().getPlugType();
                }
                return adpTypeEntry.getType();
            }
        }
        return null;
    }

    public static boolean isPlug(AdapterFB afb) {
        return !afb.getAdapterDecl().isIsInput();
    }

    private Annotations() {
        throw new UnsupportedOperationException("The utility class Annotations should not be instatiated");
    }
}

