/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.st;

import java.util.HashSet;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.search.IModelMatcher;
import org.eclipse.fordiac.ide.model.search.ISearchSupport;
import org.eclipse.fordiac.ide.model.search.Match;
import org.eclipse.fordiac.ide.model.search.TextMatch;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreTypeUsageCollector;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.DefaultLocationInFileProvider;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;

public abstract class StructuredTextSearchSupport
implements ISearchSupport {
    private final ILocationInFileProvider locationInFileProvider = new DefaultLocationInFileProvider();

    public Stream<Match> search(IModelMatcher matcher) {
        return this.prepare().map(EcoreUtil2::eAll).flatMap(contents -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(contents, 0), false)).filter(arg_0 -> ((IModelMatcher)matcher).matches(arg_0)).map(this::createMatch);
    }

    public Set<String> getImportedNamespaces() {
        return this.prepare().flatMap(StructuredTextSearchSupport::getImportedNamespaces).collect(Collectors.toCollection(HashSet::new));
    }

    protected abstract Stream<EObject> prepare();

    protected Match createMatch(EObject object) {
        ITextRegion iTextRegion = this.locationInFileProvider.getSignificantTextRegion(object);
        if (iTextRegion instanceof ITextRegionWithLineInformation) {
            ITextRegionWithLineInformation region = (ITextRegionWithLineInformation)iTextRegion;
            return new TextMatch(EcoreUtil.getURI((EObject)object), region.getLineNumber(), region.getOffset(), region.getLength(), StructuredTextSearchSupport.getMatchType(object));
        }
        return new Match(EcoreUtil.getURI((EObject)object), FordiacMarkerHelper.getLocation((EObject)object), StructuredTextSearchSupport.getMatchType(object));
    }

    protected static Stream<String> getImportedNamespaces(EObject object) {
        Resource resource = object.eResource();
        if (resource instanceof XtextResource) {
            XtextResource xtextResource = (XtextResource)resource;
            IResourceServiceProvider provider = xtextResource.getResourceServiceProvider();
            IQualifiedNameConverter converter = (IQualifiedNameConverter)provider.get(IQualifiedNameConverter.class);
            STCoreTypeUsageCollector collector = (STCoreTypeUsageCollector)provider.get(STCoreTypeUsageCollector.class);
            Set usedTypes = collector.includeUnresolvedReferences().collectUsedTypes(object);
            return usedTypes.stream().map(arg_0 -> ((IQualifiedNameConverter)converter).toString(arg_0));
        }
        return Stream.empty();
    }

    protected static String getMatchType(EObject object) {
        Resource resource = object.eResource();
        if (resource instanceof XtextResource) {
            XtextResource xtextResource = (XtextResource)resource;
            IResourceServiceProvider provider = xtextResource.getResourceServiceProvider();
            LanguageInfo languageInfo = (LanguageInfo)provider.get(LanguageInfo.class);
            return StructuredTextSearchSupport.getLanguagePrefix(languageInfo) + "ui." + languageInfo.getShortName().toLowerCase();
        }
        return object.eClass().getEPackage().getName();
    }

    protected static String getLanguagePrefix(LanguageInfo languageInfo) {
        String languageName = languageInfo.getLanguageName();
        int lastIndex = languageName.lastIndexOf(46);
        return languageName.substring(0, lastIndex + 1);
    }
}

