/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.model.libraryElement.HiddenElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractGoToPinHandler
extends AbstractHandler {
    protected static final int ABOVE = -1;
    protected static final int BELOW = 1;
    final int direction;

    protected AbstractGoToPinHandler(int direction) {
        this.direction = direction;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IInterfaceElement followingPin = this.getFollowingPin((ISelection)selection);
        if (followingPin != null) {
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
            HandlerHelper.selectElement((Object)followingPin, (GraphicalViewer)viewer);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        IEditorPart editor = (IEditorPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        this.setBaseEnabled(editor != null && this.getFollowingPin(selection) != null);
    }

    private IInterfaceElement getFollowingPin(ISelection selection) {
        IInterfaceElement ie = AbstractGoToPinHandler.getSelectedInterfaceElement(selection);
        if (ie != null) {
            List<IInterfaceElement> interfaceList = ie.isIsInput() ? AbstractGoToPinHandler.getAllInputs(ie) : AbstractGoToPinHandler.getAllOutputs(ie);
            return this.getFollowingPin(ie, interfaceList);
        }
        return null;
    }

    private static IInterfaceElement getSelectedInterfaceElement(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            EditPart ep;
            Object object;
            Object object2;
            IStructuredSelection structSel = (IStructuredSelection)selection;
            if (!selection.isEmpty() && structSel.size() == 1 && (object2 = structSel.getFirstElement()) instanceof EditPart && (object = (ep = (EditPart)object2).getModel()) instanceof IInterfaceElement) {
                IInterfaceElement ie = (IInterfaceElement)object;
                return ie;
            }
        }
        return null;
    }

    protected static List<IInterfaceElement> getAllInputs(IInterfaceElement ie) {
        ArrayList<IInterfaceElement> inputList = new ArrayList<IInterfaceElement>();
        InterfaceList interfaceList = (InterfaceList)ie.eContainer();
        inputList.addAll(interfaceList.getEventInputs().stream().filter(HiddenElement::isVisible).toList());
        inputList.addAll(interfaceList.getInputVars().stream().filter(HiddenElement::isVisible).toList());
        inputList.addAll(interfaceList.getInOutVars().stream().filter(HiddenElement::isVisible).toList());
        inputList.addAll(interfaceList.getSockets().stream().filter(HiddenElement::isVisible).toList());
        return inputList;
    }

    protected static List<IInterfaceElement> getAllOutputs(IInterfaceElement ie) {
        ArrayList<IInterfaceElement> outputList = new ArrayList<IInterfaceElement>();
        InterfaceList interfaceList = (InterfaceList)ie.eContainer();
        outputList.addAll(interfaceList.getEventOutputs().stream().filter(HiddenElement::isVisible).toList());
        outputList.addAll(interfaceList.getOutputVars().stream().filter(HiddenElement::isVisible).toList());
        outputList.addAll(interfaceList.getOutMappedInOutVars().stream().filter(HiddenElement::isVisible).toList());
        outputList.addAll(interfaceList.getPlugs().stream().filter(HiddenElement::isVisible).toList());
        return outputList;
    }

    private IInterfaceElement getFollowingPin(IInterfaceElement ie, List<IInterfaceElement> interfaceList) {
        if (interfaceList.size() <= 1) {
            return null;
        }
        int newIndex = interfaceList.indexOf(ie) + this.direction;
        if (newIndex < 0) {
            newIndex = interfaceList.size() - 1;
        } else if (newIndex >= interfaceList.size()) {
            newIndex = 0;
        }
        return interfaceList.get(newIndex);
    }
}

