/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.selection;

import java.util.function.Supplier;
import org.eclipse.egit.ui.internal.selection.AbstractSelectionProvider;
import org.eclipse.egit.ui.internal.selection.RepositoryVirtualNode;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;

public class RepositorySelectionProvider
extends AbstractSelectionProvider {
    private final ISelectionProvider baseProvider;
    private final Supplier<? extends Repository> repositoryProvider;
    private final ISelectionChangedListener selectionHook = event -> this.fireSelectionChanged(this.getSelectionListeners());
    private final ISelectionChangedListener postSelectionHook = event -> this.fireSelectionChanged(this.getPostSelectionListeners());

    public RepositorySelectionProvider(ISelectionProvider baseProvider, Supplier<? extends Repository> repositoryProvider) {
        this.repositoryProvider = repositoryProvider;
        this.baseProvider = baseProvider;
        baseProvider.addSelectionChangedListener(this.selectionHook);
        if (baseProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)baseProvider).addPostSelectionChangedListener(this.postSelectionHook);
        }
    }

    public ISelection getSelection() {
        Repository repository;
        ISelection selection = this.baseProvider.getSelection();
        if (selection.isEmpty() && selection instanceof IStructuredSelection && (repository = this.repositoryProvider.get()) != null) {
            return new StructuredSelection((Object)new RepositoryVirtualNode(null, repository));
        }
        return selection;
    }

    public void setSelection(ISelection selection) {
        this.baseProvider.setSelection(selection);
    }
}

