/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelListener;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.emf.SingleRecursiveContentAdapter;
import org.eclipse.fordiac.ide.model.libraryElement.provider.LibraryElementItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractSection
extends AbstractPropertySection
implements CommandExecutor {
    protected Object type;
    private CommandStack commandStack;
    private ComposedAdapterFactory adapterFactory;
    private Composite parent;
    private GraphicalAnnotationModel annotationModel;
    protected boolean blockRefresh = false;
    private final Adapter contentAdapter = new SingleRecursiveContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (!notification.isTouch()) {
                AbstractSection.this.notifiyRefresh();
            }
        }
    };
    private final GraphicalAnnotationModelListener annotationModelListener = event -> this.notifiyRefreshAnnotations();

    protected abstract EObject getType();

    protected abstract Object getInputType(Object var1);

    protected abstract void setInputCode();

    protected abstract void setInputInit();

    protected abstract void performRefresh();

    protected void performRefreshAnnotations() {
    }

    protected void setType(Object input) {
        this.removeContentAdapter();
        this.type = this.getInputType(input);
        this.addContentAdapter();
    }

    public final TypeLibrary getTypeLibrary() {
        TypeLibrary typeLib = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext(this.getType());
        if (typeLib != null) {
            return typeLib;
        }
        throw new IllegalStateException("Could not determine root element for finding the typ lib for given element: " + String.valueOf(this.getType()));
    }

    public final DataTypeLibrary getDataTypeLib() {
        return this.getTypeLibrary().getDataTypeLibrary();
    }

    protected CommandStack getCommandStack(IWorkbenchPart part, Object input) {
        return (CommandStack)part.getAdapter(CommandStack.class);
    }

    protected final void setCurrentCommandStack(IWorkbenchPart part, Object input) {
        this.commandStack = this.getCommandStack(part, input);
    }

    protected void setCurrentCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    protected CommandStack getCurrentCommandStack() {
        return this.commandStack;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object input = selection;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)selection;
            input = structSel.getFirstElement();
        }
        this.setCurrentCommandStack(part, input);
        if (this.commandStack == null) {
            this.setInputCode();
        }
        this.removeAnnotationModelListener();
        this.annotationModel = (GraphicalAnnotationModel)part.getAdapter(GraphicalAnnotationModel.class);
        this.addAnnotationModelListener();
        this.setType(input);
        this.setInputInit();
    }

    protected final void notifiyRefresh() {
        if (this.shouldRefresh()) {
            this.parent.getDisplay().asyncExec(() -> {
                if (!this.parent.isDisposed()) {
                    this.refresh();
                }
            });
        }
    }

    protected final void notifiyRefreshAnnotations() {
        if (this.shouldRefresh()) {
            this.parent.getDisplay().asyncExec(() -> {
                if (!this.parent.isDisposed()) {
                    this.refreshAnnotations();
                }
            });
        }
    }

    public final void refresh() {
        if (this.getType() != null) {
            CommandStack commandStackBuffer = this.commandStack;
            this.commandStack = null;
            this.performRefresh();
            this.commandStack = commandStackBuffer;
        }
    }

    public final void refreshAnnotations() {
        if (this.getType() != null) {
            CommandStack commandStackBuffer = this.commandStack;
            this.commandStack = null;
            this.performRefreshAnnotations();
            this.commandStack = commandStackBuffer;
        }
    }

    protected boolean shouldRefresh() {
        return this.getType() != null && this.getType().eAdapters().contains((Object)this.contentAdapter) && !this.blockRefresh;
    }

    public void dispose() {
        this.removeContentAdapter();
        this.removeAnnotationModelListener();
        super.dispose();
    }

    protected void removeContentAdapter() {
        if (this.getType() != null && this.getType().eAdapters().contains((Object)this.contentAdapter)) {
            this.getType().eAdapters().remove((Object)this.contentAdapter);
        }
    }

    protected void addContentAdapter() {
        if (this.getType() != null && !this.getType().eAdapters().contains((Object)this.contentAdapter)) {
            this.getType().eAdapters().add((Object)this.contentAdapter);
        }
    }

    protected void removeAnnotationModelListener() {
        if (this.annotationModel != null) {
            this.annotationModel.removeAnnotationModelListener(this.annotationModelListener);
        }
    }

    protected void addAnnotationModelListener() {
        if (this.annotationModel != null) {
            this.annotationModel.addAnnotationModelListener(this.annotationModelListener);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    public void executeCommand(Command cmd) {
        if (this.type != null && this.commandStack != null && cmd != null && cmd.canExecute()) {
            this.blockRefresh = true;
            this.commandStack.execute(cmd);
            this.blockRefresh = false;
        }
    }

    protected Text createGroupText(Composite group, boolean editable) {
        return this.createGroupText(group, editable, 2048);
    }

    protected Text createGroupText(Composite group, boolean editable, int style) {
        Text text = this.getWidgetFactory().createText(group, "", style);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        text.setEditable(editable);
        text.setEnabled(editable);
        return text;
    }

    protected ComposedAdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new LibraryElementItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new DataItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        }
        return this.adapterFactory;
    }

    public GraphicalAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }
}

