/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.editparts.AbstractConnectableEditPart;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;

public class ModifiedNonResizeableEditPolicy
extends NonResizableEditPolicy {
    private int arc = 6;
    private Insets insets = new Insets(2);
    private RoundedRectangle selectionFeedback;

    public ModifiedNonResizeableEditPolicy(int arc, Insets insets) {
        this.arc = arc;
        this.insets = insets;
    }

    public ModifiedNonResizeableEditPolicy() {
    }

    public void deactivate() {
        super.deactivate();
        this.removeSelectionFeedbackFigure();
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> list = new ArrayList<Handle>(1);
        list.add((Handle)new ModifiedMoveHandle(this.getHost(), this.insets, this.arc));
        this.removeSelectionFeedbackFigure();
        return list;
    }

    public void showTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        if (this.isFeedbackRequest(request) && this.selectionFeedback == null && this.handles == null) {
            this.selectionFeedback = this.createSelectionFeedbackFigure();
            if (this.selectionFeedback != null) {
                this.addFeedback((IFigure)this.selectionFeedback);
            }
        }
    }

    private boolean isFeedbackRequest(Request request) {
        return "selection".equals(request.getType()) || "selection hover".equals(request.getType()) || this.isValidConnectionRequest(request);
    }

    private boolean isValidConnectionRequest(Request request) {
        AbstractConnectableEditPart acEP;
        GraphicalEditPart graphicalEditPart = this.getHost();
        return graphicalEditPart instanceof AbstractConnectableEditPart && (acEP = (AbstractConnectableEditPart)graphicalEditPart).isConnectable() && ("Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType()) || "connection end".equals(request.getType()));
    }

    protected RoundedRectangle createSelectionFeedbackFigure() {
        return ModifiedNonResizeableEditPolicy.createSelectionFeedbackFigure((EditPart)this.getHost(), this.arc);
    }

    public static RoundedRectangle createSelectionFeedbackFigure(EditPart editPart, int arc) {
        if (editPart instanceof GraphicalEditPart) {
            GraphicalEditPart ep = (GraphicalEditPart)editPart;
            RoundedRectangle newSelFeedbackFigure = new RoundedRectangle();
            newSelFeedbackFigure.setAlpha(50);
            newSelFeedbackFigure.setOutline(false);
            newSelFeedbackFigure.setBounds(ModifiedNonResizeableEditPolicy.getSelectableFigureBounds(ep));
            newSelFeedbackFigure.setCornerDimensions(new Dimension(arc, arc));
            newSelFeedbackFigure.setForegroundColor(ModifiedMoveHandle.getSelectionColor());
            newSelFeedbackFigure.setBackgroundColor(ModifiedMoveHandle.getSelectionColor());
            return newSelFeedbackFigure;
        }
        return null;
    }

    private static Rectangle getSelectableFigureBounds(GraphicalEditPart ep) {
        return ep.getFigure().getBounds().getExpanded(2, 2);
    }

    public void eraseTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        this.removeSelectionFeedbackFigure();
    }

    private void removeSelectionFeedbackFigure() {
        if (this.selectionFeedback != null) {
            this.removeFeedback((IFigure)this.selectionFeedback);
            this.selectionFeedback = null;
        }
    }

    protected IFigure createDragSourceFeedbackFigure() {
        Figure r = new Figure();
        r.setBorder((Border)new ModifiedMoveHandle.SelectionBorder(this.arc));
        r.setBounds(this.getInitialFeedbackBounds());
        r.validate();
        this.addFeedback((IFigure)r);
        return r;
    }
}

