/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_lua.st;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.forte_lua.st.StructuredTextSupport;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STContinue;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExit;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNop;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STReturn;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStandardFunction;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInOutDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarOutputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarTempDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionSource;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@FinalFieldsConstructor
public class STFunctionSupport
extends StructuredTextSupport {
    private final STFunctionSource source;
    private CharSequence outReturn;

    public boolean prepare() {
        return true;
    }

    public CharSequence generate(Map<?, ?> options) throws ExportException {
        CharSequence _xblockexpression = null;
        this.prepare();
        _xblockexpression = this.generateStructuredTextFunctionSource(this.source);
        return _xblockexpression;
    }

    private CharSequence generateStructuredTextFunctionSource(STFunctionSource source) {
        StringBuilder _xblockexpression = null;
        StringBuilder result = new StringBuilder();
        EList _functions = source.getFunctions();
        for (STFunction function : _functions) {
            result.append(this.generateStructuredTextFunction(function));
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private CharSequence generateStructuredTextFunction(STFunction func) {
        this.outReturn = this.generateOutReturn(func);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local function func_");
        String _name = func.getName();
        _builder.append(_name);
        _builder.append("(fb, ");
        CharSequence _generateStructuredTextFunctionParameters = this.generateStructuredTextFunctionParameters(func);
        _builder.append((Object)_generateStructuredTextFunctionParameters);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("local ENV = {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("st_ret_val = nil");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateInParameterPrefix = this.generateInParameterPrefix(Iterables.filter((Iterable)func.getVarDeclarations(), STVarInputDeclarationBlock.class));
        _builder.append((Object)_generateInParameterPrefix, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateInParameterPrefix_1 = this.generateInParameterPrefix(Iterables.filter((Iterable)func.getVarDeclarations(), STVarInOutDeclarationBlock.class));
        _builder.append((Object)_generateInParameterPrefix_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateLocalVariables = this.generateLocalVariables(Iterables.filter((Iterable)func.getVarDeclarations(), STVarTempDeclarationBlock.class));
        _builder.append((Object)_generateLocalVariables, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)func.getCode());
        _builder.append((Object)_generateStatementList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return st_ret_val");
        _builder.append((Object)this.outReturn, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateStructuredTextFunctionParameters(STFunction func) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<STVarDeclaration> _structuredTextFunctionParameters = this.getStructuredTextFunctionParameters(func);
        boolean _hasElements = false;
        for (STVarDeclaration param : _structuredTextFunctionParameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append("par_");
            String _name = param.getName();
            _builder.append(_name);
        }
        return _builder;
    }

    private Iterable<STVarDeclaration> getStructuredTextFunctionParameters(STFunction func) {
        Functions.Function1 _function = it -> it.getVarDeclarations();
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)func.getVarDeclarations(), STVarInputDeclarationBlock.class), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getVarDeclarations();
        Iterable _flatMap_1 = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)func.getVarDeclarations(), STVarInOutDeclarationBlock.class), (Functions.Function1)_function_1);
        return Iterables.concat((Iterable)_flatMap, (Iterable)_flatMap_1);
    }

    private Iterable<STVarDeclaration> getStructuredTextOutParameters(STFunction func) {
        Functions.Function1 _function = it -> it.getVarDeclarations();
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)func.getVarDeclarations(), STVarInOutDeclarationBlock.class), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getVarDeclarations();
        Iterable _flatMap_1 = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)func.getVarDeclarations(), STVarOutputDeclarationBlock.class), (Functions.Function1)_function_1);
        return Iterables.concat((Iterable)_flatMap, (Iterable)_flatMap_1);
    }

    protected CharSequence generateInParameterPrefix(Iterable<? extends STVarDeclarationBlock> blocks) {
        StringConcatenation _builder = new StringConcatenation();
        for (STVarDeclarationBlock sTVarDeclarationBlock : blocks) {
            CharSequence _generateInParameterBlock = this.generateInParameterBlock(sTVarDeclarationBlock);
            _builder.append((Object)_generateInParameterBlock);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateInParameterBlock(STVarDeclarationBlock block) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)block.getVarDeclarations(), STVarDeclaration.class);
        for (STVarDeclaration variable : _filter) {
            CharSequence _generateInParameter = this.generateInParameter(variable);
            _builder.append((Object)_generateInParameter);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateInParameter(STVarDeclaration variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ENV.st_lv_");
        String _name = variable.getName();
        _builder.append(_name);
        _builder.append(" = par_");
        String _name_1 = variable.getName();
        _builder.append(_name_1);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateOutParameterSuffix(Iterable<? extends STVarDeclarationBlock> blocks) {
        StringConcatenation _builder = new StringConcatenation();
        for (STVarDeclarationBlock sTVarDeclarationBlock : blocks) {
            CharSequence _generateOutParameterBlock = this.generateOutParameterBlock(sTVarDeclarationBlock);
            _builder.append((Object)_generateOutParameterBlock);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateOutParameterBlock(STVarDeclarationBlock block) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)block.getVarDeclarations(), STVarDeclaration.class);
        for (STVarDeclaration variable : _filter) {
            CharSequence _generateOutParameter = this.generateOutParameter(variable);
            _builder.append((Object)_generateOutParameter);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateOutParameter(STVarDeclaration variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("par_");
        String _name = variable.getName();
        _builder.append(_name);
        _builder.append(" = ENV.st_lv_");
        String _name_1 = variable.getName();
        _builder.append(_name_1);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Override
    protected CharSequence _generateFeatureName(STFunction feature, boolean call) {
        if (call) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("method_");
            String _name = feature.getName();
            _builder.append(_name);
            return _builder;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("st_ret_val");
        return _builder_1;
    }

    @Override
    protected CharSequence _generateStatement(STReturn stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return st_ret_val");
        _builder.append((Object)this.outReturn);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateOutReturn(STFunction function) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<STVarDeclaration> _structuredTextOutParameters = this.getStructuredTextOutParameters(function);
        boolean _hasElements = false;
        for (STVarDeclaration param : _structuredTextOutParameters) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(", ");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateFeatureName = this.generateFeatureName((INamedElement)param, false);
            _builder.append((Object)_generateFeatureName);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Set<INamedElement> _xblockexpression = null;
        this.prepare();
        _xblockexpression = this.getContainedDependencies((EObject)this.source);
        return _xblockexpression;
    }

    @Override
    @XbaseGenerated
    protected CharSequence generateFeatureName(INamedElement feature, boolean call) {
        if (feature instanceof FB) {
            return this._generateFeatureName((FB)feature, call);
        }
        if (feature instanceof Event) {
            return this._generateFeatureName((Event)feature, call);
        }
        if (feature instanceof VarDeclaration) {
            return this._generateFeatureName((VarDeclaration)feature, call);
        }
        if (feature instanceof STMethod) {
            return this._generateFeatureName((STMethod)feature, call);
        }
        if (feature instanceof STStandardFunction) {
            return this._generateFeatureName((STStandardFunction)feature, call);
        }
        if (feature instanceof STVarDeclaration) {
            return this._generateFeatureName((STVarDeclaration)feature, call);
        }
        if (feature instanceof STFunction) {
            return this._generateFeatureName((STFunction)feature, call);
        }
        if (feature != null) {
            return this._generateFeatureName(feature, call);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(feature, call).toString());
    }

    @Override
    @XbaseGenerated
    protected CharSequence generateStatement(STStatement stmt) {
        if (stmt instanceof STCaseStatement) {
            return this._generateStatement((STCaseStatement)stmt);
        }
        if (stmt instanceof STContinue) {
            return this._generateStatement((STContinue)stmt);
        }
        if (stmt instanceof STExit) {
            return this._generateStatement((STExit)stmt);
        }
        if (stmt instanceof STExpression) {
            return this._generateStatement((STExpression)stmt);
        }
        if (stmt instanceof STForStatement) {
            return this._generateStatement((STForStatement)stmt);
        }
        if (stmt instanceof STIfStatement) {
            return this._generateStatement((STIfStatement)stmt);
        }
        if (stmt instanceof STNop) {
            return this._generateStatement((STNop)stmt);
        }
        if (stmt instanceof STRepeatStatement) {
            return this._generateStatement((STRepeatStatement)stmt);
        }
        if (stmt instanceof STReturn) {
            return this._generateStatement((STReturn)stmt);
        }
        if (stmt instanceof STWhileStatement) {
            return this._generateStatement((STWhileStatement)stmt);
        }
        if (stmt != null) {
            return this._generateStatement(stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public STFunctionSupport(STFunctionSource source) {
        this.source = source;
    }
}

