/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugElement;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public class FBNetworkElementValue
extends DeploymentDebugElement
implements IValue {
    private static final String QUALIFIED_NAME_DELIMITER = ".";
    private final FBNetworkElement element;
    private final Resource resource;
    private final String resourceRelativeName;
    private final List<IWatch> watches;

    public FBNetworkElementValue(FBNetworkElement element, DeploymentDebugDevice target) {
        this(element, element.getResource(), DeploymentDebugWatchUtils.getResourceRelativeName((INamedElement)element, element.getResource()), target);
    }

    public FBNetworkElementValue(FBNetworkElement element, Resource resource, String resourceRelativeName, DeploymentDebugDevice target) {
        super(target);
        this.element = element;
        this.resource = resource;
        this.resourceRelativeName = resourceRelativeName;
        this.watches = this.getSubElements().map(this::createSubWatch).toList();
    }

    private Stream<INamedElement> getSubElements() throws UnsupportedOperationException {
        return Stream.concat(this.element.getInterface().getAllInterfaceElements().stream(), this.getAdditionalSubElements()).sorted(Comparator.comparing(INamedElement::getName));
    }

    private Stream<? extends INamedElement> getAdditionalSubElements() throws UnsupportedOperationException {
        Stream<Object> stream;
        FBNetworkElement fBNetworkElement = this.element;
        Objects.requireNonNull(fBNetworkElement);
        FBNetworkElement fBNetworkElement2 = fBNetworkElement;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FB.class, Group.class, SubApp.class, CFBInstance.class}, (Object)fBNetworkElement2, n)) {
                case 0: {
                    FB fb = (FB)fBNetworkElement2;
                    FBType fBType = fb.getType();
                    if (!(fBType instanceof BaseFBType)) {
                        n = 1;
                        continue block6;
                    }
                    BaseFBType baseFBType = (BaseFBType)fBType;
                    stream = Stream.concat(baseFBType.getInternalVars().stream(), baseFBType.getInternalFbs().stream());
                    break block6;
                }
                case 1: {
                    Group group = (Group)fBNetworkElement2;
                    stream = group.getGroupElements().stream();
                    break block6;
                }
                case 2: {
                    SubApp subapp = (SubApp)fBNetworkElement2;
                    stream = subapp.loadSubAppNetwork().getNetworkElements().stream();
                    break block6;
                }
                case 3: {
                    CFBInstance cfbInstance = (CFBInstance)fBNetworkElement2;
                    stream = cfbInstance.loadCFBNetwork().getNetworkElements().stream().filter(Predicate.not(AdapterFB.class::isInstance));
                    break block6;
                }
                default: {
                    stream = Stream.empty();
                }
            }
            break;
        }
        return stream;
    }

    private IWatch createSubWatch(INamedElement element) throws EvaluatorException, UnsupportedOperationException {
        if (EcoreUtil.getRootContainer((EObject)element) instanceof FBType) {
            return IWatch.watchFor(element.getName(), element, this.resource, this.resourceRelativeName + QUALIFIED_NAME_DELIMITER + element.getName(), this.getDebugTarget());
        }
        return IWatch.watchFor(element.getName(), element, this.getDebugTarget());
    }

    public FBNetworkElement getElement() {
        return this.element;
    }

    public List<IWatch> getWatches() {
        return this.watches;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.element.getTypeName();
    }

    public String getValueString() throws DebugException {
        return "";
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return (IVariable[])this.watches.toArray(IVariable[]::new);
    }

    public boolean hasVariables() throws DebugException {
        return !this.watches.isEmpty();
    }

    @Override
    public DeploymentDebugDevice getDebugTarget() {
        return (DeploymentDebugDevice)super.getDebugTarget();
    }
}

