/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.figures.FBNetworkConnectionLabel;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.figures.HideableConnection;
import org.eclipse.fordiac.ide.gef.preferences.GefPreferenceConstants;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public class FBNetworkConnection
extends HideableConnection {
    private static final String THREE_DOTS = "\u2026";
    private static int maxWidth = GefPreferenceConstants.STORE.getInt("MaxHiddenConnectionLabelSize");
    private static String pinLabelStyle = GefPreferenceConstants.STORE.getString("PinLabelStyle");
    private final ConnectionEditPart connEP;

    public FBNetworkConnection(ConnectionEditPart connEP) {
        this.connEP = connEP;
        super.setModel(connEP.getModel());
    }

    public FBNetworkConnectionLabel getSourceDecoration() {
        return (FBNetworkConnectionLabel)super.getSourceDecoration();
    }

    public FBNetworkConnectionLabel getTargetDecoration() {
        return (FBNetworkConnectionLabel)super.getTargetDecoration();
    }

    static List<Connection> getHiddenConnections(EList<Connection> connections) {
        return connections.stream().filter(con -> !con.isVisible()).toList();
    }

    private boolean isInterfaceBarElement(IInterfaceElement ie) {
        FBNetworkElement fBNetworkElement = ie.getFBNetworkElement();
        if (fBNetworkElement instanceof SubApp) {
            SubApp subapp = (SubApp)fBNetworkElement;
            return subapp.getSubAppNetwork() != null && subapp.getSubAppNetwork().equals(this.getModel().getFBNetwork());
        }
        return false;
    }

    public void handleVisibilityChange(boolean hidden) {
        if (hidden) {
            this.setSourceDecoration(this.createSourceLabel());
            this.setTargetDecoration(this.createTargetLabel());
            this.updateConLabels();
        } else {
            this.setSourceDecoration(null);
            this.setTargetDecoration(null);
        }
    }

    public void paint(Graphics graphics) {
        if (this.isHidden()) {
            if (this.getSourceDecoration() != null) {
                this.getSourceDecoration().paint(graphics);
            }
            if (this.getTargetDecoration() != null) {
                this.getTargetDecoration().paint(graphics);
            }
        } else {
            if (this.getLocalForegroundColor() != null) {
                graphics.setForegroundColor(this.getLocalForegroundColor());
            }
            this.paintFigure(graphics);
            this.paintBorder(graphics);
        }
    }

    protected void outlineShape(Graphics g) {
        if (!this.isHidden()) {
            super.outlineShape(g);
        }
    }

    protected boolean shapeContainsPoint(int x, int y) {
        return !this.isHidden() && super.shapeContainsPoint(x, y);
    }

    public void updateConLabels() {
        if (this.getSourceDecoration() != null) {
            this.getSourceDecoration().getLabel().setText(this.createDestinationLabelText());
            this.updateSourceTooltip();
        }
        if (this.getTargetDecoration() != null) {
            this.getTargetDecoration().getLabel().setText(this.createSourceLabelText());
            this.updateTargetTooltip();
        }
    }

    private RotatableDecoration createTargetLabel() {
        FBNetworkConnectionLabel label = null;
        if (FBNetworkConnection.showLabel(this.getModel().getDestinationElement())) {
            label = new FBNetworkConnectionLabel(false);
            label.setBackgroundColor(this.getForegroundColor());
        }
        return label;
    }

    private RotatableDecoration createSourceLabel() {
        FBNetworkConnectionLabel label = null;
        if (FBNetworkConnection.showLabel(this.getModel().getSourceElement())) {
            label = new FBNetworkConnectionLabel(true);
            label.setBackgroundColor(this.getForegroundColor());
        }
        return label;
    }

    private static boolean showLabel(FBNetworkElement toCheck) {
        SubApp subApp;
        return !(toCheck instanceof SubApp) || !(subApp = (SubApp)toCheck).isUnfolded();
    }

    private String createSourceLabelText() {
        if (this.getModel().getSource() != null && this.getModel().getDestination() != null) {
            return this.createLabelText(this.getModel().getSource(), (EList<Connection>)this.getModel().getDestination().getInputConnections());
        }
        return "";
    }

    private String createDestinationLabelText() {
        if (this.getModel().getSource() != null && this.getModel().getDestination() != null) {
            return this.createLabelText(this.getModel().getDestination(), (EList<Connection>)this.getModel().getSource().getOutputConnections());
        }
        return "";
    }

    private void updateSourceTooltip() {
        if (this.getModel().getSource() != null && this.getModel().getDestination() != null) {
            this.getSourceDecoration().setToolTip(FBNetworkConnection.createSourceLabelToolTip((EList<Connection>)this.getModel().getSource().getOutputConnections()));
        }
    }

    private void updateTargetTooltip() {
        if (this.getModel().getSource() != null && this.getModel().getDestination() != null) {
            this.getTargetDecoration().setToolTip(this.createDstLabelToolTip((EList<Connection>)this.getModel().getDestination().getInputConnections()));
        }
    }

    private String createLabelText(IInterfaceElement ie, EList<Connection> connections) {
        List<Connection> hiddenConnections = FBNetworkConnection.getHiddenConnections(connections);
        if (hiddenConnections.size() > 1) {
            return Integer.toString(hiddenConnections.size());
        }
        if (ie != null) {
            return this.generateIEString(ie);
        }
        return "";
    }

    private String generateIEString(IInterfaceElement ie) {
        StringBuilder builder;
        block13: {
            builder = this.generateFullIEString(ie);
            if (builder.length() <= maxWidth) break block13;
            switch (pinLabelStyle) {
                case "PinLabelStyle_PinComment": {
                    if (CommentHelper.hasComment((INamedElement)ie)) {
                        builder.delete(maxWidth, builder.length());
                        builder.insert(maxWidth, THREE_DOTS);
                        break;
                    }
                    builder.delete(0, builder.length() - maxWidth);
                    builder.insert(0, THREE_DOTS);
                    break;
                }
                case "PinLabelStyle_PinName": 
                case "PinLabelStyle_SourcePinName": {
                    builder.delete(0, builder.length() - maxWidth);
                    builder.insert(0, THREE_DOTS);
                    break;
                }
            }
        }
        return builder.toString();
    }

    private static IFigure createSourceLabelToolTip(EList<Connection> connections) {
        List<Connection> hiddenConnections = FBNetworkConnection.getHiddenConnections(connections);
        if (!hiddenConnections.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            hiddenConnections.forEach(con -> {
                if (con.getDestination() != null) {
                    FBNetworkElement destinationElement = con.getDestinationElement();
                    if (destinationElement != null) {
                        builder.append(destinationElement.getName() + ".");
                    }
                    builder.append(con.getDestination().getName());
                    builder.append(System.lineSeparator());
                    if (CommentHelper.hasComment((INamedElement)con.getDestination())) {
                        builder.append(con.getDestination().getComment());
                        builder.append(System.lineSeparator());
                    }
                    if (destinationElement != null && destinationElement.isInGroup()) {
                        builder.append(destinationElement.getGroup().getName());
                        builder.append(System.lineSeparator());
                    }
                }
                builder.append(System.lineSeparator());
            });
            return new ConLabelToolTip(builder.toString().trim());
        }
        return null;
    }

    private IFigure createDstLabelToolTip(EList<Connection> connections) {
        List<Connection> hiddenConnections = FBNetworkConnection.getHiddenConnections(connections);
        if (!hiddenConnections.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            hiddenConnections.forEach(con -> {
                if (con.getSource() != null) {
                    IInterfaceElement ie = con.getSource();
                    FBNetworkElement sourceElement = ie.getFBNetworkElement();
                    if (sourceElement != null && !this.isInterfaceBarElement(ie)) {
                        builder.append(sourceElement.getName());
                        builder.append('.');
                    }
                    builder.append(ie.getName());
                    builder.append(System.lineSeparator());
                    if (CommentHelper.hasComment((INamedElement)ie)) {
                        builder.append(ie.getComment());
                        builder.append(System.lineSeparator());
                    }
                    if (sourceElement != null && sourceElement.isInGroup()) {
                        builder.append(sourceElement.getGroup().getName());
                        builder.append(System.lineSeparator());
                    }
                    builder.append(System.lineSeparator());
                }
            });
            return new ConLabelToolTip(builder.toString().trim());
        }
        return null;
    }

    private StringBuilder generateFullIEString(IInterfaceElement ie) {
        StringBuilder builder = new StringBuilder();
        if (pinLabelStyle.equals("PinLabelStyle_PinComment") && CommentHelper.hasComment((INamedElement)ie)) {
            builder.append(ie.getComment());
        } else {
            if (ie.getFBNetworkElement() != null && !this.isInterfaceBarElement(ie)) {
                builder.append(ie.getFBNetworkElement().getName());
                builder.append('.');
            }
            builder.append(ie.getName());
        }
        return builder;
    }

    int getMaxFanOutLabelWidth() {
        InterfaceEditPart source = (InterfaceEditPart)this.connEP.getSource();
        return source.getSourceConnections().stream().filter(conn -> !conn.getModel().isVisible()).mapToInt(ep -> ep.getFigure().getSourceDecoration().getLabel().getBounds().width).max().orElse(0);
    }

    private static class ConLabelToolTip
    extends Figure {
        private final TextFlow content = new TextFlow();
        private final FlowPage fp = new FlowPage();

        public ConLabelToolTip(String tooltipText) {
            this.setLayoutManager((LayoutManager)new GridLayout());
            this.content.setText(tooltipText);
            this.content.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.content, 0));
            this.fp.add((IFigure)this.content);
            this.add((IFigure)this.fp);
        }
    }
}

