/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.List;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.IContainerEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.application.figures.InstanceCommentFigure;
import org.eclipse.fordiac.ide.application.figures.SubAppForFbNetworkFigure;
import org.eclipse.fordiac.ide.application.policies.ContainerResizePolicy;
import org.eclipse.fordiac.ide.application.policies.FBAddToSubAppLayoutEditPolicy;
import org.eclipse.fordiac.ide.application.policies.FBNetworkElementNonResizeableEP;
import org.eclipse.fordiac.ide.application.utilities.ExpandedInterfacePositionMap;
import org.eclipse.fordiac.ide.gef.editparts.FigureCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.TextDirectEditManager;
import org.eclipse.fordiac.ide.gef.policies.AbstractViewRenameEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.EmptyXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SubAppForFBNetworkEditPart
extends AbstractFBNElementEditPart
implements IContainerEditPart {
    private final ExpandedInterfacePositionMap positionMap = new ExpandedInterfacePositionMap(this);

    @Override
    public Adapter createContentAdapter() {
        return new SubappContentAdapter();
    }

    @Override
    protected List<Object> getModelChildren() {
        List<Object> children = super.getModelChildren();
        if (this.getModel().isUnfolded()) {
            children.add(this.getModel().getSubAppNetwork());
        }
        return children;
    }

    protected IFigure createFigureForModel() {
        return new SubAppForFbNetworkFigure(this.getModel(), this);
    }

    @Override
    public SubAppForFbNetworkFigure getFigure() {
        return (SubAppForFbNetworkFigure)super.getFigure();
    }

    public SubApp getModel() {
        return (SubApp)super.getModel();
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        if (this.getModel().isUnfolded()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new SubappCommentRenameEditPolicy());
        } else {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FBAddToSubAppLayoutEditPolicy());
        }
    }

    @Override
    public void performRequest(Request request) {
        if (request.getType().equals("open")) {
            if (this.getModel().isUnfolded()) {
                this.performDirectEdit();
            } else {
                this.openSubAppEditor();
            }
        } else if (request.getType() == "direct edit") {
            if (this.getModel().isUnfolded()) {
                this.performDirectEdit();
            } else {
                super.performRequest(request);
            }
        } else {
            super.performRequest(request);
        }
    }

    @Override
    public void performDirectEdit() {
        if (EditorUtils.getCurrentActiveEditor().getAdapter(FBNetwork.class) != null) {
            if (this.getModel().isUnfolded()) {
                new TextDirectEditManager(this, (CellEditorLocator)new FigureCellEditorLocator((IFigure)this.getCommentFigure())){

                    protected CellEditor createCellEditorOn(Composite composite) {
                        return new TextCellEditor(composite, 66);
                    }

                    protected void initCellEditor() {
                        super.initCellEditor();
                        this.getCellEditor().setValue((Object)SubAppForFBNetworkEditPart.this.getModel().getComment());
                    }
                }.show();
            } else {
                super.performDirectEdit();
            }
        }
    }

    protected InstanceCommentFigure getCommentFigure() {
        return this.getFigure().getCommentFigure();
    }

    private void openSubAppEditor() {
        SubApp subApp = this.getModel();
        if (this.subAppIsMapped(subApp)) {
            subApp = (SubApp)subApp.getOpposite();
        }
        OpenListenerManager.openEditor((EObject)subApp);
    }

    private boolean subAppIsMapped(SubApp subApp) {
        return this.getModel().getTypeEntry() == null && subApp.getSubAppNetwork() == null && subApp.isMapped();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.updateEditPolicies();
        SubAppForFbNetworkFigure figure = this.getFigure();
        figure.updateTypeLabel(this.getModel());
        figure.updateExpandedFigure();
    }

    private void updateEditPolicies() {
        if (this.getModel().isUnfolded()) {
            if (this.getFigure().getExpandedMainFigure() == null) {
                this.installEditPolicy("DirectEditPolicy", (EditPolicy)new SubappCommentRenameEditPolicy());
                this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ContainerResizePolicy());
                this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EmptyXYLayoutEditPolicy());
            }
        } else if (this.getFigure().getExpandedMainFigure() != null) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new AbstractFBNElementEditPart.TypeDirectEditPolicy());
            this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new FBNetworkElementNonResizeableEP());
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FBAddToSubAppLayoutEditPolicy());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof UnfoldedSubappContentEditPart) {
            UnfoldedSubappContentEditPart unfoldedSubappContentEP = (UnfoldedSubappContentEditPart)childEditPart;
            IFigure contentFigure = unfoldedSubappContentEP.getFigure();
            GridData contentGridData = new GridData(1808);
            this.getFigure().getExpandedContentArea().add(contentFigure, (Object)contentGridData, -1);
            return;
        }
        if (childEditPart instanceof InterfaceEditPart) {
            InterfaceEditPart interfaceEditPart = (InterfaceEditPart)childEditPart;
            if (this.getModel().isUnfolded()) {
                if (interfaceEditPart.isInput()) {
                    this.getFigure().getExpandedInputFigure().add(interfaceEditPart.getFigure());
                    return;
                }
                this.getFigure().getExpandedOutputFigure().add(interfaceEditPart.getFigure());
                return;
            }
        }
        super.addChildVisual(childEditPart, index);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof UnfoldedSubappContentEditPart) {
            UnfoldedSubappContentEditPart unfoldedSubappContentEP = (UnfoldedSubappContentEditPart)childEditPart;
            if (this.getFigure().getExpandedContentArea() == null) return;
            this.getFigure().getExpandedContentArea().remove(unfoldedSubappContentEP.getFigure());
            return;
        }
        if (childEditPart instanceof InterfaceEditPart) {
            InterfaceEditPart interfaceEditPart = (InterfaceEditPart)childEditPart;
            if (this.getModel().isUnfolded()) {
                if (interfaceEditPart.isInput()) {
                    this.getFigure().getExpandedInputFigure().remove(interfaceEditPart.getFigure());
                    return;
                }
                this.getFigure().getExpandedOutputFigure().remove(interfaceEditPart.getFigure());
                return;
            }
        }
        super.removeChildVisual(childEditPart);
    }

    @Override
    public Rectangle getCommentBounds() {
        if (this.getFigure().getCommentFigure() != null) {
            return this.getFigure().getCommentFigure().getBounds();
        }
        return null;
    }

    @Override
    public GraphicalEditPart getContentEP() {
        return this.getChildren().stream().filter(UnfoldedSubappContentEditPart.class::isInstance).findAny().orElse(null);
    }

    protected void refreshPosition() {
        if (this.getParent() != null) {
            Position position = this.getModel().getPosition();
            Rectangle bounds = new Rectangle(position.toScreenPoint(), this.getSubappSize());
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getFigure(), (Object)bounds);
        }
    }

    private Dimension getSubappSize() {
        if (this.getModel().isUnfolded()) {
            return new Dimension(CoordinateConverter.INSTANCE.iec61499ToScreen(this.getModel().getWidth()), CoordinateConverter.INSTANCE.iec61499ToScreen(this.getModel().getHeight()));
        }
        return new Dimension(-1, -1);
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        if (key == SubApp.class) {
            return key.cast(this.getModel());
        }
        return super.getAdapter(key);
    }

    @Override
    public int getCommentWidth() {
        return this.getCommentFigure().getTextWidth();
    }

    @Override
    public int getMinHeight() {
        if (this.getModel().isUnfolded()) {
            return this.getFigure().getExpandedIOHeight();
        }
        return 0;
    }

    public ExpandedInterfacePositionMap getInterfacePositionMap() {
        return this.positionMap;
    }

    public void layoutExpandedInterface() {
        if (this.getModel().isUnfolded()) {
            Display.getDefault().asyncExec(() -> this.getFigure().layoutExpandedInterface());
        }
    }

    private class SubappCommentRenameEditPolicy
    extends AbstractViewRenameEditPolicy {
        private SubappCommentRenameEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            Object object = this.getHost().getModel();
            if (object instanceof INamedElement) {
                INamedElement namedEl = (INamedElement)object;
                String str = (String)request.getCellEditor().getValue();
                if (!InstanceCommentFigure.EMPTY_COMMENT.equals(str)) {
                    return new ResizeGroupOrSubappCommand(this.getHost(), (Command)new ChangeCommentCommand(namedEl, str));
                }
            }
            return null;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            String value = (String)request.getCellEditor().getValue();
            SubAppForFBNetworkEditPart.this.getCommentFigure().setText(value);
        }

        protected void revertOldEditValue(DirectEditRequest request) {
            SubAppForFBNetworkEditPart.this.getFigure().refreshComment();
        }
    }

    private final class SubappContentAdapter
    extends AdapterImpl {
        private SubappContentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (!notification.isTouch()) {
                Display.getDefault().execute(() -> this.handleRefresh(notification));
            }
            super.notifyChanged(notification);
        }

        protected void handleRefresh(Notification notification) {
            switch (notification.getEventType()) {
                case 3: 
                case 5: 
                case 7: {
                    this.handleAddMove(notification);
                    break;
                }
                case 4: 
                case 6: {
                    this.handleRemove(notification);
                    break;
                }
                case 1: {
                    this.handleSet(notification);
                    break;
                }
            }
            if (notification.getFeatureID(SubApp.class) == 2 && (SubappContentAdapter.isUnfoldedAttribute(notification.getOldValue()) || SubappContentAdapter.isUnfoldedAttribute(notification.getNewValue()))) {
                this.reloadInterfaceFigures();
                SubAppForFBNetworkEditPart.this.layoutExpandedInterface();
            }
            SubAppForFBNetworkEditPart.this.refreshToolTip();
            SubAppForFBNetworkEditPart.this.backgroundColorChanged((IFigure)SubAppForFBNetworkEditPart.this.getFigure());
        }

        private static boolean isUnfoldedAttribute(Object obj) {
            Attribute attr;
            return obj instanceof Attribute && (attr = (Attribute)obj).getName().equals("Unfolded");
        }

        private void reloadInterfaceFigures() {
            SubAppForFBNetworkEditPart.this.getChildren().stream().filter(InterfaceEditPart.class::isInstance).map(InterfaceEditPart.class::cast).forEach(ie -> SubAppForFBNetworkEditPart.this.addChildVisual((EditPart)ie, -1));
        }

        private void handleAddMove(Notification notification) {
            if (notification.getNewValue() instanceof IInterfaceElement) {
                SubAppForFBNetworkEditPart.this.refreshChildren();
            }
            if (LibraryElementPackage.eINSTANCE.getConfigurableObject_Attributes().equals(notification.getFeature())) {
                SubAppForFBNetworkEditPart.this.refreshVisuals();
                SubAppForFBNetworkEditPart.this.refreshChildren();
                this.refreshInterfaceEditParts();
                this.refreshRoot();
            }
            SubAppForFBNetworkEditPart.this.layoutExpandedInterface();
        }

        private void handleRemove(Notification notification) {
            if (notification.getOldValue() instanceof IInterfaceElement) {
                SubAppForFBNetworkEditPart.this.refreshChildren();
            }
            if (LibraryElementPackage.eINSTANCE.getConfigurableObject_Attributes().equals(notification.getFeature())) {
                SubAppForFBNetworkEditPart.this.refreshVisuals();
                SubAppForFBNetworkEditPart.this.refreshChildren();
                this.refreshInterfaceEditParts();
                this.refreshRoot();
            }
            SubAppForFBNetworkEditPart.this.layoutExpandedInterface();
        }

        private void handleSet(Notification notification) {
            if (LibraryElementPackage.eINSTANCE.getINamedElement_Comment().equals(notification.getFeature())) {
                SubAppForFBNetworkEditPart.this.getFigure().refreshComment();
            }
            if (LibraryElementPackage.eINSTANCE.getSubApp_Width().equals(notification.getFeature()) || LibraryElementPackage.eINSTANCE.getSubApp_Height().equals(notification.getFeature())) {
                SubAppForFBNetworkEditPart.this.refreshPosition();
            }
            SubAppForFBNetworkEditPart.this.refreshVisuals();
        }

        private void refreshRoot() {
            RootEditPart root = SubAppForFBNetworkEditPart.this.getRoot();
            if (root != null) {
                root.getChildren().forEach(EditPart::refresh);
            }
        }

        private void refreshInterfaceEditParts() {
            SubAppForFBNetworkEditPart.this.getChildren().forEach(ep -> {
                if (ep instanceof InterfaceEditPart) {
                    InterfaceEditPart iEP = (InterfaceEditPart)ep;
                    iEP.refresh();
                }
            });
        }
    }
}

