/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.editparts.IContainerEditPart;
import org.eclipse.fordiac.ide.application.editparts.InstanceComment;
import org.eclipse.fordiac.ide.application.editparts.InstanceCommentEditPart;
import org.eclipse.fordiac.ide.application.figures.InstanceCommentFigure;
import org.eclipse.fordiac.ide.application.policies.AbstractCreateInstanceDirectEditPolicy;
import org.eclipse.fordiac.ide.application.policies.FBNetworkCreateInstanceDirectEditPolicy;
import org.eclipse.fordiac.ide.application.policies.FBNetworkXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.draw2d.SingleLineBorder;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.requests.SelectionRequest;

public class FBNetworkEditPart
extends AbstractFBNetworkEditPart {
    private Adapter adapter;
    private static final int BASE_WIDTH = 400;
    private static final int BASE_HEIGHT = 200;
    private FreeformLayer contentContainer;
    private InstanceComment instanceComment;
    private Figure commentContainer;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().eAdapters().add((Object)this.getContentAdapter());
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
        }
    }

    protected Adapter getContentAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    int type = notification.getEventType();
                    switch (type) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            FBNetworkEditPart.this.refreshChildren();
                            break;
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    public void refresh() {
        super.refresh();
        for (Object ep : this.getChildren()) {
            if (!(ep instanceof IContainerEditPart)) continue;
            IContainerEditPart container = (IContainerEditPart)ep;
            GraphicalEditPart contentEP = container.getContentEP();
            container.refresh();
            if (contentEP == null) continue;
            contentEP.refresh();
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FBNetworkXYLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new FBNetworkCreateInstanceDirectEditPolicy());
    }

    protected IFigure createFigure() {
        Figure mainFigure = new Figure();
        InterfaceBarLayout mainLayout = new InterfaceBarLayout();
        mainLayout.setVerticalSpacing(-1);
        mainFigure.setLayoutManager((LayoutManager)mainLayout);
        mainFigure.setOpaque(false);
        this.contentContainer = new FreeformLayer();
        this.contentContainer.setLayoutManager((LayoutManager)new FreeformLayout());
        mainFigure.add((IFigure)this.contentContainer, (Object)BorderLayout.CENTER);
        this.createCommentContainer((IFigure)mainFigure);
        IFigure root = super.createFigure();
        root.setBorder(null);
        root.add((IFigure)mainFigure);
        root.setConstraint((IFigure)mainFigure, (Object)new Rectangle(0, 0, -1, -1));
        return root;
    }

    private void createCommentContainer(IFigure mainFigure) {
        this.commentContainer = new Figure();
        SingleLineBorder border = new SingleLineBorder(){
            private final Insets insets = new Insets(5);

            public Insets getInsets(IFigure figure) {
                return this.insets;
            }
        };
        this.commentContainer.setBorder((Border)border);
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(false);
        this.commentContainer.setOpaque(true);
        this.commentContainer.setLayoutManager((LayoutManager)layout);
        mainFigure.add((IFigure)this.commentContainer, (Object)BorderLayout.TOP);
    }

    public IFigure getContentPane() {
        if (this.contentContainer != null) {
            return this.contentContainer;
        }
        return super.getContentPane();
    }

    protected List<?> getModelChildren() {
        if (this.getModel() != null) {
            ArrayList<InstanceComment> children = new ArrayList<InstanceComment>(super.getModelChildren());
            if (this.isInstance()) {
                children.add(this.getInstanceComment());
            }
            return children;
        }
        return Collections.emptyList();
    }

    private boolean isInstance() {
        return this.getModel().eContainer() instanceof Application;
    }

    private InstanceComment getInstanceComment() {
        if (this.instanceComment == null) {
            this.instanceComment = new InstanceComment((INamedElement)((Application)this.getModel().eContainer()));
        }
        return this.instanceComment;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof InstanceCommentEditPart) {
            InstanceCommentEditPart instanceCommentEP = (InstanceCommentEditPart)childEditPart;
            InstanceCommentFigure commentFigure = instanceCommentEP.getFigure();
            commentFigure.setBorder(null);
            this.commentContainer.add((IFigure)commentFigure);
        } else {
            super.addChildVisual(childEditPart, index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof InstanceCommentEditPart) {
            InstanceCommentEditPart instanceCommentEP = (InstanceCommentEditPart)childEditPart;
            this.commentContainer.remove((IFigure)instanceCommentEP.getFigure());
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    public void performRequest(Request request) {
        if ((request.getType() == "direct edit" || request.getType() == "open") && request instanceof SelectionRequest) {
            SelectionRequest selectionRequest = (SelectionRequest)request;
            EditPolicy editPolicy = this.getEditPolicy("DirectEditPolicy");
            if (editPolicy instanceof AbstractCreateInstanceDirectEditPolicy) {
                AbstractCreateInstanceDirectEditPolicy createInstanceDEP = (AbstractCreateInstanceDirectEditPolicy)editPolicy;
                createInstanceDEP.performDirectEdit(selectionRequest);
            }
        } else {
            super.performRequest(request);
        }
    }

    public DragTracker getDragTracker(Request req) {
        return this.getParent().getDragTracker(req);
    }

    private class InterfaceBarLayout
    extends BorderLayout {
        private InterfaceBarLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            Rectangle newBounds = new Rectangle();
            newBounds.setSize(super.calculatePreferredSize(figure, wHint, hHint));
            newBounds.setLocation(this.getLocation());
            newBounds.y -= FBNetworkEditPart.this.commentContainer.getPreferredSize().height;
            if (newBounds.x > 0) {
                newBounds.x = 0;
            }
            if (newBounds.y > 0) {
                newBounds.y = 0;
            }
            FreeformLayer layer = (FreeformLayer)FBNetworkEditPart.this.getLayer("Feedback Layer");
            layer.validate();
            newBounds.union(layer.getFreeformExtent());
            layer = (FreeformLayer)FBNetworkEditPart.this.getLayer("Handle Layer");
            layer.validate();
            newBounds.union(layer.getFreeformExtent());
            Rectangle resultingBounds = this.calculateModuloExtent(newBounds);
            figure.getParent().setConstraint(figure, (Object)new Rectangle(resultingBounds.x, resultingBounds.y, -1, -1));
            return resultingBounds.getSize();
        }

        private Rectangle calculateModuloExtent(Rectangle newBounds) {
            int x = this.calcAxisOrigin(newBounds.x, 400);
            int y = this.calcAxisOrigin(newBounds.y, 200);
            int width = this.calcAxisExtent(newBounds.x, x, newBounds.width, 400);
            int height = this.calcAxisExtent(newBounds.y, y, newBounds.height, 200);
            return new Rectangle(x, y, width, height);
        }

        private int calcAxisExtent(int baseOrigin, int newOrigin, int sourceExtent, int baseUnit) {
            int startExtent = sourceExtent + baseOrigin - newOrigin;
            int newExtend = (startExtent / baseUnit + 1) * baseUnit;
            if (newExtend < 3 * baseUnit) {
                newExtend = 3 * baseUnit;
            }
            return newExtend;
        }

        private int calcAxisOrigin(int axisPos, int baseUnit) {
            if (axisPos < 0) {
                return (axisPos / baseUnit - 1) * baseUnit;
            }
            return axisPos / baseUnit * baseUnit;
        }

        private Point getLocation() {
            IFigure iFigure = FBNetworkEditPart.this.getContentPane();
            if (iFigure instanceof FreeformLayer) {
                FreeformLayer contentFreeFormLayer = (FreeformLayer)iFigure;
                return contentFreeFormLayer.getFreeformExtent().getLocation();
            }
            return FBNetworkEditPart.this.getContentPane().getBounds().getLocation();
        }
    }
}

