/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupExpandCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.UpdateColumnGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.event.ColumnGroupCollapseEvent;
import org.eclipse.nebula.widgets.nattable.group.performance.event.ColumnGroupExpandEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class ColumnGroupExpandCollapseLayer
extends AbstractColumnHideShowLayer {
    private final MutableMap<GroupModel.Group, MutableIntSet> hidden = Maps.mutable.empty();

    public ColumnGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ColumnGroupExpandCommand) {
            List<GroupModel.Group> groups = ((ColumnGroupExpandCommand)command).getGroups();
            MutableIntSet shownIndexes = IntSets.mutable.empty();
            for (GroupModel.Group group : groups) {
                if (group == null || !group.isCollapseable() || !group.isCollapsed()) continue;
                group.setCollapsed(false);
                MutableIntSet columnIndexes = (MutableIntSet)this.hidden.get((Object)group);
                this.hidden.remove((Object)group);
                shownIndexes.addAll((IntIterable)columnIndexes);
            }
            if (!shownIndexes.isEmpty()) {
                this.invalidateCache();
                this.fireLayerEvent(new ColumnGroupExpandEvent((ILayer)this, this.getColumnPositionsByIndexes(shownIndexes.toArray())));
            } else {
                this.fireLayerEvent(new VisualRefreshEvent(this));
            }
            return true;
        }
        if (command instanceof ColumnGroupCollapseCommand) {
            GroupModel groupModel = ((ColumnGroupCollapseCommand)command).getGroupModel();
            List<GroupModel.Group> groups = ((ColumnGroupCollapseCommand)command).getGroups();
            Collections.sort(groups, (o1, o2) -> o2.getVisibleStartPosition() - o1.getVisibleStartPosition());
            MutableIntSet hiddenPositions = IntSets.mutable.empty();
            MutableIntSet hiddenIndexes = IntSets.mutable.empty();
            for (GroupModel.Group group : groups) {
                if (group == null || !group.isCollapseable()) continue;
                MutableIntSet columnIndexes = IntSets.mutable.empty();
                if (!group.isCollapsed()) {
                    columnIndexes.addAll(group.getVisibleIndexes());
                    group.setCollapsed(true);
                } else if (!this.hidden.containsKey((Object)group)) {
                    int[] nArray = group.getMembers();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int member = nArray[n2];
                        int pos = groupModel.getPositionByIndex(member);
                        if (pos > -1) {
                            columnIndexes.add(member);
                        }
                        ++n2;
                    }
                }
                this.modifyForVisible(group, columnIndexes);
                hiddenPositions.addAll(this.getColumnPositionsByIndexes(columnIndexes.toArray()));
                hiddenIndexes.addAll((IntIterable)columnIndexes);
                this.hidden.put((Object)group, (Object)columnIndexes);
            }
            if (!hiddenPositions.isEmpty()) {
                this.invalidateCache();
                this.fireLayerEvent(new ColumnGroupCollapseEvent((ILayer)this, hiddenPositions.toArray(), hiddenIndexes.toArray()));
            } else {
                this.fireLayerEvent(new VisualRefreshEvent(this));
            }
            return true;
        }
        if (command instanceof UpdateColumnGroupCollapseCommand) {
            UpdateColumnGroupCollapseCommand cmd = (UpdateColumnGroupCollapseCommand)command;
            GroupModel.Group group = cmd.getGroup();
            MutableIntSet hiddenColumnIndexes = (MutableIntSet)this.hidden.get((Object)group);
            if (group.getVisibleIndexes().length + hiddenColumnIndexes.size() <= group.getOriginalSpan()) {
                MutableIntSet indexesToHide = IntSets.mutable.of(cmd.getIndexesToHide());
                MutableIntSet indexesToShow = IntSets.mutable.of(cmd.getIndexesToShow());
                indexesToHide.removeAll((IntIterable)hiddenColumnIndexes);
                this.modifyForVisible(group, indexesToHide);
                int[] hiddenPositions = this.getColumnPositionsByIndexes(indexesToHide.toArray());
                hiddenColumnIndexes.addAll((IntIterable)indexesToHide);
                hiddenColumnIndexes.removeAll((IntIterable)indexesToShow);
                this.invalidateCache();
                this.fireLayerEvent(new HideColumnPositionsEvent((ILayer)this, hiddenPositions, indexesToHide.toArray()));
            }
            return true;
        }
        return super.doCommand(command);
    }

    private void modifyForVisible(GroupModel.Group group, MutableIntSet columnIndexes) {
        int[] staticIndexes = group.getStaticIndexes();
        if (staticIndexes.length == 0) {
            columnIndexes.remove(group.getVisibleStartIndex());
        } else {
            columnIndexes.removeAll(staticIndexes);
        }
    }

    @Override
    public boolean isColumnIndexHidden(int columnIndex) {
        MutableIntSet found = (MutableIntSet)this.hidden.detect((Predicate & Serializable)indexes -> indexes.contains(columnIndex));
        return found != null;
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        MutableIntList hiddenColumnIndexes = IntLists.mutable.empty();
        for (MutableIntSet indexes : this.hidden.values()) {
            hiddenColumnIndexes.addAll((IntIterable)indexes);
        }
        return ArrayUtil.asIntegerList(hiddenColumnIndexes.distinct().toSortedArray());
    }

    @Override
    public int[] getHiddenColumnIndexesArray() {
        MutableIntList hiddenColumnIndexes = IntLists.mutable.empty();
        for (MutableIntSet indexes : this.hidden.values()) {
            hiddenColumnIndexes.addAll((IntIterable)indexes);
        }
        return hiddenColumnIndexes.distinct().toSortedArray();
    }

    @Override
    public boolean hasHiddenColumns() {
        return !this.hidden.isEmpty();
    }
}

