/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.view;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import org.eclipse.fordiac.ide.debug.EvaluatorProcess;
import org.eclipse.fordiac.ide.debug.fb.FBDebugClockMode;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchEventQueue;
import org.eclipse.fordiac.ide.model.eval.AbstractEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DebugTimeComposite {
    private static final int NUM_COLUMNS = 1;
    private static final int NUM_BUTTONS = 3;
    private EvaluatorProcess evaluator;
    private FBLaunchEventQueue eventQueue;
    private final Group debugTimeGroup;
    private Button systemTimeRadio;
    private Button incrementTimeRadio;
    private Button manualTimeRadio;
    private Text debugTimeText;

    public DebugTimeComposite(Composite parent) {
        this.debugTimeGroup = this.createDebugTimeGroup(parent);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).generateLayout((Composite)this.debugTimeGroup);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)this.debugTimeGroup);
        this.setEditPartVisible(false);
    }

    protected Group createDebugTimeGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Set Debug Time");
        Composite debugTimeSelectionComposite = this.createDebugTimeModeSelectionComposite(group);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 0).generateLayout(debugTimeSelectionComposite);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)debugTimeSelectionComposite);
        Composite debugTimeValueComposite = this.createDebugTimeValueComposite(group);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 0).generateLayout(debugTimeValueComposite);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)debugTimeValueComposite);
        this.setEditPartVisible(false);
        return group;
    }

    protected Composite createDebugTimeValueComposite(Group group) {
        Composite composite = new Composite((Composite)group, 0);
        Button setButton = new Button(composite, 8);
        setButton.setText("Set");
        setButton.setLayoutData((Object)new GridData(0x1000000, 4, true, true, 1, 1));
        this.debugTimeText = new Text(composite, 2048);
        Label debugTimeLable = new Label(composite, 0);
        this.debugTimeText.setText("");
        this.debugTimeText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        debugTimeLable.setText("ms");
        debugTimeLable.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        setButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setDebugTime(this.debugTimeText.getText())));
        return composite;
    }

    protected Composite createDebugTimeModeSelectionComposite(Group group) {
        Composite composite = new Composite((Composite)group, 0);
        this.systemTimeRadio = new Button(composite, 16);
        this.systemTimeRadio.setText("System");
        this.incrementTimeRadio = new Button(composite, 16);
        this.incrementTimeRadio.setText("Increment");
        this.manualTimeRadio = new Button(composite, 16);
        this.manualTimeRadio.setText("Manual");
        return composite;
    }

    protected void setCheckbox(String text) {
        switch (text) {
            case "System": {
                this.systemTimeRadio.setSelection(true);
                this.incrementTimeRadio.setSelection(false);
                this.manualTimeRadio.setSelection(false);
                break;
            }
            case "Increment": {
                this.systemTimeRadio.setSelection(false);
                this.incrementTimeRadio.setSelection(true);
                this.manualTimeRadio.setSelection(false);
                break;
            }
            case "Manual": {
                this.systemTimeRadio.setSelection(false);
                this.incrementTimeRadio.setSelection(false);
                this.manualTimeRadio.setSelection(true);
                break;
            }
        }
    }

    private void setDebugTime(String text) {
        if (this.manualTimeRadio.getSelection() && text != null) {
            this.manualSelection(text);
        }
        if (this.incrementTimeRadio.getSelection() && text != null) {
            this.incrementSelection(text);
        }
        if (this.systemTimeRadio.getSelection()) {
            this.systemSelection();
        }
    }

    private void systemSelection() {
        this.evaluator.getExecutor().setClock((Clock)AbstractEvaluator.MonotonicClock.UTC);
        if (this.eventQueue != null) {
            this.eventQueue.setEvaluatorProcess(this.evaluator);
            this.eventQueue.setDebugTimeValue(FBDebugClockMode.SYSTEM, Duration.ZERO);
        }
    }

    private void incrementSelection(String text) {
        try {
            long value = Long.parseLong(text);
            Duration sleepTime = Duration.of(value, ChronoUnit.MILLIS);
            if (this.eventQueue != null) {
                this.eventQueue.setEvaluatorProcess(this.evaluator);
                this.eventQueue.setDebugTimeValue(FBDebugClockMode.INCREMENT, sleepTime);
            }
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new IllegalStateException("Debug Time Value is not accepted!");
        }
    }

    private void manualSelection(String text) {
        try {
            long value = Long.parseLong(text);
            Duration manualTime = Duration.of(value, ChronoUnit.MILLIS);
            Instant instant = Instant.ofEpochSecond(manualTime.getSeconds(), manualTime.getNano());
            if (this.eventQueue != null) {
                this.eventQueue.setEvaluatorProcess(this.evaluator);
                this.eventQueue.setDebugTimeValue(FBDebugClockMode.MANUAL, manualTime);
            }
            this.evaluator.getExecutor().setClock(Clock.fixed(instant, ZoneId.systemDefault()));
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new IllegalStateException("Debug Time Value is not accepted!");
        }
    }

    public void setEditPartVisible(boolean visiblestate) {
        if (this.debugTimeGroup != null) {
            this.debugTimeGroup.setVisible(visiblestate);
        }
    }

    public void updateEditPartVisible() {
        FBLaunchEventQueue newEventQueue = DebugTimeComposite.getEventQueue(this.evaluator);
        if (this.eventQueue != newEventQueue) {
            this.eventQueue = newEventQueue;
        }
        if (this.eventQueue != null) {
            this.systemTimeRadio.setSelection(this.eventQueue.isDebugTimeSystem());
            this.incrementTimeRadio.setSelection(this.eventQueue.isDebugTimeIncremental());
            this.manualTimeRadio.setSelection(this.eventQueue.isDebugTimeManual());
            this.debugTimeText.setText(String.valueOf(this.eventQueue.getDebugTimeValue().toMillis()));
            this.eventQueue.setEvaluatorProcess(this.evaluator);
        }
    }

    public void setContent(EvaluatorProcess evaluatorprocess) {
        this.evaluator = evaluatorprocess;
        FBLaunchEventQueue newEventQueue = DebugTimeComposite.getEventQueue(this.evaluator);
        if (this.eventQueue != newEventQueue) {
            this.eventQueue = newEventQueue;
        }
    }

    private static FBLaunchEventQueue getEventQueue(EvaluatorProcess evaluator) {
        FBEvaluatorEventQueue queue;
        if (evaluator != null && (queue = ((FBEvaluator)evaluator.getEvaluator()).getEventQueue()) instanceof FBLaunchEventQueue) {
            FBLaunchEventQueue fBLaunchEventQueue = (FBLaunchEventQueue)queue;
            return fBLaunchEventQueue;
        }
        return null;
    }
}

