/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.exporter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.exporter.CppBoostTestConstants;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.IntType;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.data.UintType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class ExportServiceSequenceToCppTest {
    private List<ServiceSequence> serviceSeq;
    BasicFBType fb;

    public void exportServiceSequenceToCppTest(List<ServiceSequence> serviceSeq, FBType fb) {
        this.serviceSeq = serviceSeq;
        this.fb = (BasicFBType)fb;
        IPath projectPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String exportedTestDir = "ServiceSequenceTests";
        File directory = new File(projectPath.toString() + File.separator + "ServiceSequenceTests");
        if (!directory.exists()) {
            directory.mkdir();
        }
        Path path = Paths.get(String.valueOf(directory) + File.separator + fb.getName() + "_ServiceSeq.cpp", new String[0]);
        if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        try {
            Throwable e = null;
            Object var8_11 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                ExportServiceSequenceToCppTest.addImports(writer);
                this.addTesterGen(writer);
                this.addDataStruct(writer);
                this.addTestSuite(writer);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException ex) {
            FordiacLogHelper.logError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    private void addTestSuite(BufferedWriter writer) throws IOException {
        writer.append(MessageFormat.format("BOOST_FIXTURE_TEST_SUITE({0}TEST, {0}_TestFixture)", this.fb.getName()));
        writer.newLine();
        for (ServiceSequence sequence : this.serviceSeq) {
            writer.append(MessageFormat.format("BOOST_AUTO_TEST_CASE({0}) '{'", sequence.getName()));
            writer.newLine();
            int stateID = this.fb.getECC().getECState().indexOf(this.fb.getECC().getECState().stream().filter(state -> state.getName().equals(sequence.getStartState())).findFirst().orElse(null));
            if (stateID > 0) {
                writer.append(MessageFormat.format("setECCState(CIEC_STATE({0}));", Integer.toString(stateID)));
                writer.newLine();
            }
            for (ServiceTransaction transaction : sequence.getServiceTransaction()) {
                ExportServiceSequenceToCppTest.parseAndAddParameters(writer, transaction.getInputPrimitive().getParameters());
                int eventID = this.fb.getInterfaceList().getEventInputs().indexOf(this.fb.getInterfaceList().getEventInputs().stream().filter(event -> event.getName().equals(transaction.getInputPrimitive().getEvent())).findFirst().orElse(null));
                writer.append(MessageFormat.format("triggerEvent({0});", Integer.toString(eventID)));
                writer.newLine();
                ExportServiceSequenceToCppTest.parseAndAddOutputAsserts(writer, (List<OutputPrimitive>)transaction.getOutputPrimitive());
            }
            writer.append("}");
            writer.newLine();
        }
        writer.append("BOOST_AUTO_TEST_SUITE_END()");
    }

    private static void parseAndAddOutputAsserts(BufferedWriter writer, List<OutputPrimitive> parameters) throws IOException {
        for (OutputPrimitive primitive : parameters) {
            if (primitive.getParameters() == null || !primitive.getParameters().contains("\n")) continue;
            List<String> paramStrings = Arrays.asList(primitive.getParameters().split("\n"));
            for (String param : paramStrings) {
                param = param.replaceFirst("#", "(");
                param = param.replaceFirst(";", ")");
                param = param.replace(param.subSequence(param.indexOf("=") + 1, param.indexOf("(")), ExportServiceSequenceToCppTest.getForteDataTypeFromString(param.subSequence(param.indexOf("=") + 1, param.indexOf("(")).toString()));
                writer.append(MessageFormat.format("BOOST_TEST({0} == {1});", param.subSequence(0, param.indexOf(":")), param.subSequence(param.indexOf("=") + 1, param.length()).toString().replace("'", "\"")));
                writer.newLine();
            }
        }
    }

    private static void parseAndAddParameters(BufferedWriter writer, String parameters) throws IOException {
        if (parameters.contains("\n")) {
            List<String> paramStrings = Arrays.asList(parameters.split("\n"));
            for (String param : paramStrings) {
                param = param.replaceFirst(":=", "=");
                param = param.replaceFirst("#", "(");
                param = param.replaceFirst(";", ");");
                param = param.replace(param.subSequence(param.indexOf("=") + 1, param.indexOf("(")), ExportServiceSequenceToCppTest.getForteDataTypeFromString(param.subSequence(param.indexOf("=") + 1, param.indexOf("(")).toString()));
                writer.append(param);
                writer.newLine();
            }
        }
    }

    private static void addImports(BufferedWriter writer) throws IOException {
        writer.write(CppBoostTestConstants.TEST_INCLUDE_STRING);
    }

    private void addTesterGen(BufferedWriter writer) throws IOException {
        writer.write(MessageFormat.format("#ifdef FORTE_ENABLE_GENERATED_SOURCE_CPP\n#include \"{0}_ServiceSeq_gen.cpp\"\n#endif\n", this.fb.getName()));
        writer.newLine();
    }

    private void addDataStruct(BufferedWriter writer) throws IOException {
        EList outputData = this.fb.getOutputParameters();
        EList inputData = this.fb.getInputParameters();
        writer.append(MessageFormat.format("struct {0}_TestFixture : public CFBTestFixtureBase '{'", this.fb.getName()));
        writer.newLine();
        writer.append(MessageFormat.format(CppBoostTestConstants.TEST_FICTURE_BASE, this.fb.getName()));
        writer.newLine();
        writer.append("setInputData({");
        if (!inputData.isEmpty()) {
            writer.append(inputData.stream().map(INamedElement::getName).collect(Collectors.joining(",&", "&", "")));
        }
        writer.append("});");
        writer.newLine();
        writer.append("setOutputData({");
        if (!outputData.isEmpty()) {
            writer.append(outputData.stream().map(INamedElement::getName).collect(Collectors.joining(",&", "&", "")));
        }
        writer.append("});");
        writer.newLine();
        writer.append(CppBoostTestConstants.TEST_FICTURE_SETUP);
        writer.newLine();
        for (INamedElement varDec : inputData) {
            writer.append(ExportServiceSequenceToCppTest.getForteDataType(((VarDeclaration)varDec).getType()) + " " + varDec.getName() + ";");
            writer.newLine();
        }
        for (INamedElement varDec : outputData) {
            writer.append(ExportServiceSequenceToCppTest.getForteDataType(((VarDeclaration)varDec).getType()) + " " + varDec.getName() + ";");
            writer.newLine();
        }
        writer.append("};");
        writer.newLine();
    }

    private static String getForteDataType(Object dataType) {
        if (dataType instanceof BoolType) {
            return "CIEC_BOOL";
        }
        if (dataType instanceof IntType) {
            return "CIEC_INT";
        }
        if (dataType instanceof UintType) {
            return "CIEC_UINT";
        }
        if (dataType instanceof StringType) {
            return "CIEC_STRING";
        }
        return "";
    }

    private static String getForteDataTypeFromString(String dataType) {
        return switch (dataType.toUpperCase()) {
            case "BOOL" -> "CIEC_BOOL";
            case "UINT" -> "CIEC_UINT";
            case "INT" -> "CIEC_INT";
            case "STRING" -> "CIEC_STRING";
            default -> "";
        };
    }
}

