/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.forte_ng.ForteNgExportTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.export.language.ILanguageSupportFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class ForteLibraryElementTemplate<T extends LibraryElement>
extends ForteNgExportTemplate {
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private final T type;
    private final Map<VarDeclaration, ILanguageSupport> variableLanguageSupport;

    public ForteLibraryElementTemplate(T type, String name, Path prefix, Map<?, ?> options) {
        super(name, prefix);
        this.type = type;
        Functions.Function1 _function = it -> ILanguageSupportFactory.createLanguageSupport((String)"forte_ng", (EObject)it, (Map)options);
        this.variableLanguageSupport = IterableExtensions.toInvertedMap((Iterable)EcoreUtil2.getAllContentsOfType(type, VarDeclaration.class), (Functions.Function1)_function);
    }

    protected CharSequence getClassName() {
        return ForteNgExportUtil.generateTypeName(this.type);
    }

    protected CharSequence generateHeader() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*************************************************************************");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** FORTE Library Element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("***");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** This file was generated using the 4DIAC FORTE Export Filter V1.0.x NG!");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("***");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** Name: ");
        String _name = this.type.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*** Description: ");
        CharSequence _escapeMultilineCommentString = ForteNgExportUtil.escapeMultilineCommentString(this.type.getComment());
        _builder.append((Object)_escapeMultilineCommentString, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*** Version:");
        _builder.newLine();
        EList _versionInfo = this.type.getVersionInfo();
        for (VersionInfo info : _versionInfo) {
            _builder.append(" ");
            _builder.append("***     ");
            CharSequence _escapeMultilineCommentString_1 = ForteNgExportUtil.escapeMultilineCommentString(info.getVersion());
            _builder.append((Object)_escapeMultilineCommentString_1, " ");
            _builder.append(": ");
            CharSequence _escapeMultilineCommentString_2 = ForteNgExportUtil.escapeMultilineCommentString(info.getDate());
            _builder.append((Object)_escapeMultilineCommentString_2, " ");
            _builder.append("/");
            CharSequence _escapeMultilineCommentString_3 = ForteNgExportUtil.escapeMultilineCommentString(info.getAuthor());
            _builder.append((Object)_escapeMultilineCommentString_3, " ");
            _builder.append(" - ");
            CharSequence _escapeMultilineCommentString_4 = ForteNgExportUtil.escapeMultilineCommentString(info.getOrganization());
            _builder.append((Object)_escapeMultilineCommentString_4, " ");
            _builder.append(" - ");
            CharSequence _escapeMultilineCommentString_5 = ForteNgExportUtil.escapeMultilineCommentString(info.getRemarks());
            _builder.append((Object)_escapeMultilineCommentString_5, " ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append(" ");
        _builder.append("*************************************************************************/");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateIncludeGuardStart() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#pragma once");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateIncludeGuardEnd() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence generateVariableDeclarations(List<VarDeclaration> variables, boolean const_) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
            }
            if (const_) {
                _builder.append("static const ");
            }
            CharSequence _generateVariableTypeName = this.generateVariableTypeName(variable);
            _builder.append((Object)_generateVariableTypeName);
            _builder.append(" ");
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        return _builder;
    }

    protected CharSequence generateVariableDefinitions(List<VarDeclaration> variables, boolean const_) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
            }
            if (const_) {
                _builder.append("const ");
            }
            CharSequence _generateVariableTypeName = this.generateVariableTypeName(variable);
            _builder.append((Object)_generateVariableTypeName);
            _builder.append(" ");
            CharSequence _className = this.getClassName();
            _builder.append((Object)_className);
            _builder.append("::");
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append(" = ");
            CharSequence _generateVariableDefaultValue = this.generateVariableDefaultValue(variable);
            _builder.append((Object)_generateVariableDefaultValue);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        return _builder;
    }

    protected CharSequence generateVariableInitializer(Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append("(");
            CharSequence _generateVariableDefaultValue = this.generateVariableDefaultValue(variable);
            _builder.append((Object)_generateVariableDefaultValue);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence generateVariableInitializerFromParameters(Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append("(");
            CharSequence _generateNameAsParameter = this.generateNameAsParameter(variable);
            _builder.append((Object)_generateNameAsParameter);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence generateAdapterDeclarations(List<AdapterDeclaration> adapters) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (AdapterDeclaration adapter : adapters) {
            if (!_hasElements) {
                _hasElements = true;
            }
            CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((INamedElement)adapter.getType());
            _builder.append((Object)_generateTypeName);
            _builder.append(" ");
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)adapter);
            _builder.append((Object)_generateName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        return _builder;
    }

    protected CharSequence generateAdapterInitializer(Iterable<AdapterDeclaration> adapters) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (AdapterDeclaration adapter : adapters) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)adapter);
            _builder.append((Object)_generateName);
            _builder.append("(");
            CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(adapter.getName());
            _builder.append((Object)_fORTEStringId);
            _builder.append(", *this, ");
            boolean _isIsInput = adapter.isIsInput();
            boolean _not = !_isIsInput;
            _builder.append((Object)_not);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence generateAccessorDeclaration(String function, boolean const_) {
        return this.generateAccessorDeclaration(function, "CIEC_ANY *", const_);
    }

    protected CharSequence generateAccessorDeclaration(String function, String type, boolean const_) {
        StringConcatenation _builder = new StringConcatenation();
        if (const_) {
            _builder.append("const ");
        }
        _builder.append(type);
        _builder.append(function);
        _builder.append("(size_t)");
        if (const_) {
            _builder.append(" const");
        }
        _builder.append(" override;");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateAccessorDefinition(List<VarDeclaration> variables, String function, boolean const_) {
        return this.generateAccessorDefinition(variables, function, "CIEC_ANY *", const_);
    }

    protected CharSequence generateAccessorDefinition(List<? extends IInterfaceElement> variables, String function, String type, boolean const_) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = variables.isEmpty();
        if (_isEmpty) {
            if (const_) {
                _builder.append("const ");
            }
            _builder.append(type);
            CharSequence _className = this.getClassName();
            _builder.append((Object)_className);
            _builder.append("::");
            _builder.append(function);
            _builder.append("(size_t)");
            if (const_) {
                _builder.append(" const");
            }
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("return nullptr;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        } else {
            if (const_) {
                _builder.append("const ");
            }
            _builder.append(type);
            CharSequence _className_1 = this.getClassName();
            _builder.append((Object)_className_1);
            _builder.append("::");
            _builder.append(function);
            _builder.append("(const size_t paIndex)");
            if (const_) {
                _builder.append(" const");
            }
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("switch(paIndex) {");
            _builder.newLine();
            for (IInterfaceElement iInterfaceElement : variables) {
                _builder.append("    ");
                _builder.append("case ");
                int _indexOf = variables.indexOf(iInterfaceElement);
                _builder.append((Object)_indexOf, "    ");
                _builder.append(": return &");
                CharSequence _generateName = ForteNgExportUtil.generateName(iInterfaceElement);
                _builder.append((Object)_generateName, "    ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("return nullptr;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateNameAsParameter(VarDeclaration variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("pa");
        String _name = variable.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence generateVariableDefaultValue(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.variableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                _generate = _get.generate(CollectionLiterals.emptyMap());
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence generateVariableTypeName(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.variableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                Pair _mappedTo = Pair.of((Object)"type", (Object)Boolean.TRUE);
                _generate = _get.generate(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence generateVariableTypeNameAsParameter(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.variableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                Pair _mappedTo = Pair.of((Object)"type_param", (Object)Boolean.TRUE);
                _generate = _get.generate(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence generateVariableTypeSpec(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.variableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                Pair _mappedTo = Pair.of((Object)"type_spec", (Object)Boolean.TRUE);
                _generate = _get.generate(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getFORTENameList(List<? extends INamedElement> elements) {
        Functions.Function1 _function = it -> ForteNgExportUtil.getFORTEStringId(it.getName());
        return IterableExtensions.join((Iterable)ListExtensions.map(elements, (Functions.Function1)_function), (CharSequence)", ");
    }

    protected String getFORTETypeList(List<? extends VarDeclaration> elements) {
        Functions.Function1 _function = it -> this.generateVariableTypeSpec((VarDeclaration)it);
        return IterableExtensions.join((Iterable)ListExtensions.map(elements, (Functions.Function1)_function), (CharSequence)", ");
    }

    protected String getFORTEEventTypeList(List<? extends Event> elements) {
        Functions.Function1 _function = it -> ForteNgExportUtil.getFORTEStringId(it.getTypeName());
        return IterableExtensions.join((Iterable)ListExtensions.map(elements, (Functions.Function1)_function), (CharSequence)", ");
    }

    public List<String> getErrors() {
        List _errors = super.getErrors();
        Functions.Function1 _function = it -> it.getErrors();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.variableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_errors, (Iterable)_set));
    }

    public List<String> getWarnings() {
        List _warnings = super.getWarnings();
        Functions.Function1 _function = it -> it.getWarnings();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.variableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_warnings, (Iterable)_set));
    }

    public List<String> getInfos() {
        List _infos = super.getInfos();
        Functions.Function1 _function = it -> it.getInfos();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.variableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_infos, (Iterable)_set));
    }

    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Functions.Function1 _function = it -> it.getDependencies(options);
        return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.variableLanguageSupport.values()), (Functions.Function1)_function));
    }

    @Pure
    protected T getType() {
        return this.type;
    }
}

