/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.figures;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.figures.ECTransitionToolTipFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.figures.SplineConnection;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.preferences.FBTypeEditorPreferenceConstants;
import org.eclipse.fordiac.ide.gef.draw2d.SetableAlphaLabel;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class ECTransitionFigure
extends SplineConnection {
    private SetableAlphaLabel conditionBackground;
    private Label condition;
    private final TransitionOrderDecorator transitionOrderDecorator;
    private static final int VERTICAL_MARGIN = 2;
    private static final int HORIZONTAL_MARGIN = 4;

    public ECTransitionFigure(ECTransition ecTransition) {
        this.setAntialias(1);
        this.setForegroundColor(FBTypeEditorPreferenceConstants.getColor("ECCEditorTransitionColor"));
        this.updateBendPoints(ecTransition);
        this.transitionOrderDecorator = new TransitionOrderDecorator();
        this.setSourceDecoration(this.transitionOrderDecorator);
        this.createConditionLabel(ecTransition.getConditionText());
        this.setTargetDecoration((RotatableDecoration)ECTransitionFigure.createTargetDecorator());
        ECTransitionToolTipFigure transitionTooltip = new ECTransitionToolTipFigure();
        transitionTooltip.setVisible(true);
        this.setToolTip((IFigure)transitionTooltip);
    }

    public void setConditionText(String conditionText) {
        this.condition.setText(conditionText);
        this.conditionBackground.setText(conditionText);
    }

    public void updateBendPoints(ECTransition ecTransition) {
        ArrayList<AbsoluteBendpoint> bendPoints = new ArrayList<AbsoluteBendpoint>();
        bendPoints.add(new AbsoluteBendpoint(ecTransition.getPosition().toScreenPoint()));
        this.getConnectionRouter().setConstraint((Connection)this, bendPoints);
    }

    public void setTransitionOrder(String value) {
        this.transitionOrderDecorator.setText(value);
    }

    private static PolygonDecoration createTargetDecorator() {
        PolygonDecoration rectDec = new PolygonDecoration();
        rectDec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        rectDec.setScale(7.0, 4.0);
        rectDec.setFill(true);
        return rectDec;
    }

    private void createConditionLabel(String conditionText) {
        this.condition = new Label(conditionText);
        this.condition.setBorder((Border)new MarginBorder(2, 4, 2, 4));
        this.condition.setOpaque(false);
        this.conditionBackground = new SetableAlphaLabel();
        this.conditionBackground.setText(conditionText);
        this.conditionBackground.setBorder((Border)new MarginBorder(2, 4, 2, 4));
        this.conditionBackground.setAlpha(190);
        this.conditionBackground.setOpaque(true);
        this.add((IFigure)this.conditionBackground, new ConnectionLocator((Connection)this, 4));
        this.add((IFigure)this.condition, new ConnectionLocator((Connection)this, 4));
    }

    public ECTransitionToolTipFigure getToolTip() {
        return (ECTransitionToolTipFigure)super.getToolTip();
    }

    public Label getLabel() {
        return this.condition;
    }

    private static class TransitionOrderDecorator
    extends Ellipse
    implements RotatableDecoration {
        private static final int TRANSITON_ORDER_LABEL_FONT_SIZE = 7;
        private static final String TRANSITION_ORDER_LABEL_FONT = "TransitionOrderLabelFont";
        private final Label orderLabel;

        public TransitionOrderDecorator() {
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.setFill(true);
            this.setAntialias(1);
            this.setBackgroundColor(FBTypeEditorPreferenceConstants.getColor("ECCEditorTransitionColor"));
            this.setOutline(false);
            this.orderLabel = new Label();
            this.orderLabel.setOpaque(false);
            this.orderLabel.setForegroundColor(ColorConstants.white);
            this.orderLabel.setFont(TransitionOrderDecorator.getOrderLabelFont());
            this.add((IFigure)this.orderLabel);
        }

        private static Font getOrderLabelFont() {
            FontData[] fontData = (FontData[])JFaceResources.getFontRegistry().getFontData("org.eclipse.fordiac.ide.preferences.diagramFontDefinition").clone();
            Arrays.stream(fontData).forEach(fd -> fd.setHeight(7));
            JFaceResources.getFontRegistry().put(TRANSITION_ORDER_LABEL_FONT, fontData);
            return JFaceResources.getFont((String)TRANSITION_ORDER_LABEL_FONT);
        }

        public void setReferencePoint(Point p) {
        }

        public void setLocation(Point p) {
            p.x -= this.getSize().width() / 2;
            p.y -= this.getSize().height() / 2;
            super.setLocation(p);
        }

        public void setText(String val) {
            this.orderLabel.setText(val);
            if ("".equals(this.orderLabel.getText())) {
                this.setSize(0, 0);
            } else {
                int dim = this.orderLabel.getFont().getFontData()[0].getHeight() * 2;
                this.setSize(dim, dim);
            }
        }
    }
}

