/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.notification;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.ui.notification.JavaBuilderState;
import org.eclipse.xtext.common.types.ui.notification.NameBasedEObjectDescription;
import org.eclipse.xtext.common.types.ui.notification.NameBasedEObjectDescriptionBuilder;
import org.eclipse.xtext.common.types.ui.notification.TypeNames;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceDescription;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.ui.containers.JavaProjectsState;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;

public class DeltaConverter {
    private static final Logger LOGGER = Logger.getLogger(DeltaConverter.class);
    private final TypeURIHelper uriHelper;
    private final IQualifiedNameConverter nameConverter;
    @Inject
    private ISharedStateContributionRegistry javaProjectsStateAccess;
    private JavaProjectsState cachedState;
    private IResourceDescriptions resourceDescriptions;

    @Inject
    public DeltaConverter(IQualifiedNameConverter nameConverter, TypeURIHelper uriHelper, IResourceDescriptions resourceDescriptions) {
        this.nameConverter = nameConverter;
        this.uriHelper = uriHelper;
        this.resourceDescriptions = resourceDescriptions;
    }

    public List<IResourceDescription.Delta> convert(IJavaElementDelta delta) {
        if (delta.getFlags() == 524288 || delta.getFlags() == 540673) {
            return Collections.emptyList();
        }
        try {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)2);
            this.convertCompilationUnits(delta, result);
            return result;
        }
        catch (Throwable throwable) {
            if (throwable instanceof VirtualMachineError) {
                throw (VirtualMachineError)throwable;
            }
            if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                LOGGER.error((Object)throwable.getMessage(), throwable);
            }
            return Collections.emptyList();
        }
    }

    protected void convertCompilationUnit(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        if (delta.getKind() == 1) {
            this.convertAddedCompilationUnit(delta, result);
        } else if (delta.getKind() == 2) {
            this.convertRemovedTypes(delta, result);
        } else {
            this.convertChangedCompilationUnit(delta, result);
        }
    }

    protected void convertAddedCompilationUnit(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        ICompilationUnit compilationUnit = (ICompilationUnit)delta.getElement();
        this.convertNewTypes(compilationUnit, result);
    }

    protected void convertChangedCompilationUnit(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        block5: {
            if ((delta.getFlags() & 0x10000) != 0) {
                return;
            }
            TypeNames typeNames = this.getTypeNamesFromIndex(delta);
            ICompilationUnit compilationUnit = (ICompilationUnit)delta.getElement();
            try {
                IType[] iTypeArray = compilationUnit.getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (this.isDerived(type)) {
                        return;
                    }
                    String typeName = type.getFullyQualifiedName();
                    URI topLevelURI = this.uriHelper.createResourceURIForFQN(typeName);
                    this.convertChangedTypeAndChildren(result, typeNames, type, topLevelURI);
                    ++n2;
                }
                this.convertRemovedTypes(typeNames, result);
            }
            catch (JavaModelException e) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
    }

    private void convertChangedTypeAndChildren(List<IResourceDescription.Delta> result, TypeNames previousTypeNames, IType type, URI topLevelUri) {
        block5: {
            String typeName = type.getFullyQualifiedName();
            if (previousTypeNames.remove(typeName)) {
                this.convertChangedType(topLevelUri, type, result);
            } else {
                this.convertNewType(topLevelUri, type, result);
            }
            try {
                IType[] iTypeArray = type.getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType child = iTypeArray[n2];
                    this.convertChangedTypeAndChildren(result, previousTypeNames, child, topLevelUri);
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
    }

    @Deprecated
    protected void convertChangedType(IType type, List<IResourceDescription.Delta> result) {
        if (!this.isDerived(type)) {
            TypeResourceDescription newDescription = this.createTypeResourceDescription(type.getFullyQualifiedName());
            TypeResourceDescription oldDescription = this.createTypeResourceDescription(newDescription.getURI(), type.getFullyQualifiedName());
            result.add(this.createStructureChangeDelta(type, (IResourceDescription)oldDescription, (IResourceDescription)newDescription));
        }
    }

    protected void convertChangedType(URI topLevelUri, IType type, List<IResourceDescription.Delta> result) {
        TypeResourceDescription newDescription = this.createTypeResourceDescription(topLevelUri, type.getFullyQualifiedName());
        TypeResourceDescription oldDescription = this.createTypeResourceDescription(newDescription.getURI(), type.getFullyQualifiedName());
        result.add(this.createStructureChangeDelta(type, (IResourceDescription)oldDescription, (IResourceDescription)newDescription));
    }

    protected void convertNewTypes(ICompilationUnit compilationUnit, List<IResourceDescription.Delta> result) {
        block4: {
            try {
                IType[] iTypeArray = compilationUnit.getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (this.isDerived(type)) {
                        return;
                    }
                    String typeName = type.getFullyQualifiedName();
                    URI topLevelURI = this.uriHelper.createResourceURIForFQN(typeName);
                    this.convertNewTypeAndChildren(topLevelURI, type, result);
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
    }

    @Deprecated
    protected void convertNewType(IType type, List<IResourceDescription.Delta> result) {
        if (!this.isDerived(type)) {
            result.add(this.createContentChangeDelta(null, (IResourceDescription)this.createTypeResourceDescription(type.getFullyQualifiedName())));
        }
    }

    protected void convertNewTypeAndChildren(URI topLevelType, IType type, List<IResourceDescription.Delta> result) {
        block3: {
            this.convertNewType(topLevelType, type, result);
            try {
                IType[] iTypeArray = type.getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType child = iTypeArray[n2];
                    this.convertNewTypeAndChildren(topLevelType, child, result);
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected void convertNewType(URI topLevelType, IType type, List<IResourceDescription.Delta> result) {
        result.add(this.createContentChangeDelta(null, (IResourceDescription)this.createTypeResourceDescription(topLevelType, type.getFullyQualifiedName())));
    }

    protected void convertRemovedType(String typeName, IJavaProject project, List<IResourceDescription.Delta> result) {
        if (!this.isDerived(typeName, project)) {
            result.add(this.createContentChangeDelta((IResourceDescription)this.createTypeResourceDescription(typeName), null));
        }
    }

    protected void convertRemovedType(URI toplevelUri, String typeName, IJavaProject context, List<IResourceDescription.Delta> result) {
        if (!this.isDerived(typeName, context)) {
            result.add(this.createContentChangeDelta((IResourceDescription)this.createTypeResourceDescription(toplevelUri, typeName), null));
        }
    }

    @Deprecated
    protected TypeResourceDescription createTypeResourceDescription(String typeName) {
        URI uri = this.uriHelper.createResourceURIForFQN(typeName);
        return this.createTypeResourceDescription(uri, typeName);
    }

    protected TypeResourceDescription createTypeResourceDescription(URI uri, String qualifiedTypeName) {
        QualifiedName qualifiedName = this.nameConverter.toQualifiedName(qualifiedTypeName);
        NameBasedEObjectDescription nameBasedEObjectDescription = new NameBasedEObjectDescription(qualifiedName);
        return new TypeResourceDescription(uri, Collections.singletonList(nameBasedEObjectDescription));
    }

    protected IResourceDescription.Delta createContentChangeDelta(IResourceDescription oldDescription, IResourceDescription newDescription) {
        return new ChangedResourceDescriptionDelta(oldDescription, newDescription);
    }

    protected IResourceDescription.Delta createStructureChangeDelta(IType type, IResourceDescription oldDescription, IResourceDescription newDescription) {
        return new ChangedResourceDescriptionDelta(oldDescription, newDescription);
    }

    protected boolean isDerived(IType type) {
        return this.isDerived(type.getFullyQualifiedName(), type.getJavaProject());
    }

    protected boolean isDerived(String typeName, IJavaProject project) {
        QualifiedName qualifiedName = this.nameConverter.toQualifiedName(typeName);
        Iterable iterable = this.resourceDescriptions.getExportedObjects(TypesPackage.Literals.JVM_TYPE, qualifiedName, false);
        Iterator iterator = iterable.iterator();
        if (iterator.hasNext()) {
            if (project != null) {
                JavaProjectsState javaProjectsState = this.getJavaProjectsState();
                List visibleContainers = javaProjectsState.getVisibleContainerHandles(project.getHandleIdentifier());
                while (iterator.hasNext()) {
                    IEObjectDescription description = (IEObjectDescription)iterator.next();
                    URI resourceURI = description.getEObjectURI().trimFragment();
                    String handle = javaProjectsState.getContainerHandle(resourceURI);
                    if (!visibleContainers.contains(handle)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private JavaProjectsState getJavaProjectsState() {
        if (this.cachedState != null) {
            return this.cachedState;
        }
        this.cachedState = (JavaProjectsState)this.javaProjectsStateAccess.getSingleContributedInstance(JavaProjectsState.class);
        return this.cachedState;
    }

    @Deprecated
    protected List<IEObjectDescription> getAdditionallyExportedEObjects(IType type, IJavaElementDelta delta) {
        QualifiedName typeName = this.nameConverter.toQualifiedName(type.getFullyQualifiedName());
        NameBasedEObjectDescriptionBuilder descriptionBuilder = new NameBasedEObjectDescriptionBuilder(typeName);
        this.traverseDelta(delta, descriptionBuilder);
        return descriptionBuilder.getExported();
    }

    @Deprecated
    protected void traverseDelta(IJavaElementDelta delta, NameBasedEObjectDescriptionBuilder acceptor) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getRemovedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            if (childDelta.getElement().getElementType() != 7) {
                acceptor.accept(childDelta.getElement().getElementName());
            }
            ++n2;
        }
    }

    @Deprecated
    protected List<IEObjectDescription> getExportedEObjects(IType type) {
        QualifiedName typeName = this.nameConverter.toQualifiedName(type.getFullyQualifiedName());
        NameBasedEObjectDescriptionBuilder descriptionBuilder = new NameBasedEObjectDescriptionBuilder(typeName);
        this.traverseType(type, descriptionBuilder);
        return descriptionBuilder.getExported();
    }

    @Deprecated
    protected void traverseType(IType type, NameBasedEObjectDescriptionBuilder acceptor) {
        block7: {
            try {
                if (type.exists()) {
                    IField[] iFieldArray = type.getFields();
                    int n = iFieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField field = iFieldArray[n2];
                        if (!Flags.isSynthetic((int)field.getFlags())) {
                            String fieldName = field.getElementName();
                            acceptor.accept(fieldName);
                        }
                        ++n2;
                    }
                    iFieldArray = type.getMethods();
                    n = iFieldArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        IField method = iFieldArray[n2];
                        if (!Flags.isSynthetic((int)method.getFlags())) {
                            String methodName = method.getElementName();
                            acceptor.accept(methodName);
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                if (!LOGGER.isDebugEnabled()) break block7;
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected void convertCompilationUnits(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        IJavaElement element = delta.getElement();
        if (element.getElementType() == 5) {
            this.convertCompilationUnit(delta, result);
        }
        if (element.getElementType() < 5) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                this.convertCompilationUnits(child, result);
                ++n2;
            }
            if (element.getElementType() == 4) {
                this.convertPackageFragment(delta, result);
            }
        }
    }

    protected void convertPackageFragment(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        if (delta.getKind() == 1) {
            this.convertAddedPackageFragment(delta, result);
        } else if (delta.getKind() == 2) {
            this.convertRemovedTypes(delta, result);
        }
    }

    protected void convertAddedPackageFragment(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        block3: {
            IPackageFragment fragment = (IPackageFragment)delta.getElement();
            try {
                ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
                int n = iCompilationUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit cu = iCompilationUnitArray[n2];
                    this.convertNewTypes(cu, result);
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected void convertRemovedTypes(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        this.convertRemovedTypes(this.getTypeNamesFromIndex(delta), result);
    }

    @Deprecated
    protected void convertRemovedTypes(Collection<String> typeNames, IJavaProject project, List<IResourceDescription.Delta> result) {
        for (String typeName : typeNames) {
            this.convertRemovedType(typeName, project, result);
        }
    }

    protected void convertRemovedTypes(TypeNames typeNames, List<IResourceDescription.Delta> result) {
        for (String typeName : typeNames.getTypeNames()) {
            URI toplevelUri = this.uriHelper.createResourceURIForFQN(typeNames.getTopLevelTypeName(typeName));
            this.convertRemovedType(toplevelUri, typeName, typeNames.getProjectContext(), result);
        }
    }

    @Deprecated
    protected Collection<String> getQualifiedTypeNames(IJavaElementDelta delta) {
        return this.getQualifiedTypeNames(delta.getElement());
    }

    @Deprecated
    protected Collection<String> getQualifiedTypeNames(IJavaElement element) {
        return this.getTypeNamesFromIndex(element).getTypeNames();
    }

    protected TypeNames getTypeNamesFromIndex(IJavaElementDelta delta) {
        return this.getTypeNamesFromIndex(delta.getElement());
    }

    protected TypeNames getTypeNamesFromIndex(IJavaElement element) {
        return JavaBuilderState.getLastBuiltState(element).getQualifiedTypeNames(element);
    }

    protected URI getURIFor(IType type) {
        return this.uriHelper.createResourceURIForFQN(type.getFullyQualifiedName());
    }

    @Deprecated
    protected IType getPrimaryTypeFrom(ICompilationUnit cu) {
        block6: {
            try {
                if (cu.exists()) {
                    IType primaryType = cu.findPrimaryType();
                    if (primaryType != null) {
                        return primaryType;
                    }
                    IType[] iTypeArray = cu.getTypes();
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType type = iTypeArray[n2];
                        if (Flags.isPublic((int)type.getFlags())) {
                            return type;
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                if (!LOGGER.isDebugEnabled()) break block6;
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    @Deprecated
    protected String getExpectedPrimaryTypeNameFor(ICompilationUnit cu) {
        String fileName = cu.getElementName();
        String typeName = fileName.substring(0, fileName.lastIndexOf(46));
        IPackageFragment pkg = (IPackageFragment)cu.getParent();
        if (!pkg.isDefaultPackage()) {
            typeName = String.valueOf(pkg.getElementName()) + '.' + typeName;
        }
        return typeName;
    }

    @Deprecated
    public static class ThrowableWrapper
    implements IResourceDescription.Delta {
        private String location;
        private String eventAsString;
        private Throwable cause;

        public ThrowableWrapper(String location, String eventAsString, Throwable cause) {
            this.location = location;
            this.eventAsString = eventAsString;
            this.cause = cause;
        }

        public URI getUri() {
            return URI.createURI((String)this.location);
        }

        public IResourceDescription getOld() {
            return null;
        }

        public IResourceDescription getNew() {
            return null;
        }

        public boolean haveEObjectDescriptionsChanged() {
            return true;
        }

        public String getLocation() {
            return this.location;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return "Exception while processing " + this.eventAsString + ": " + this.cause.getMessage();
        }
    }
}

