/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.ISavingSaveable;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SaveablesCompareEditorInput;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class LocalResourceSaveableComparison
extends SaveableComparison
implements IPropertyChangeListener,
ISavingSaveable {
    private final ICompareInput input;
    private final CompareEditorInput editorInput;
    private boolean isSaving;
    private IContentChangeListener contentChangeListener;
    private ITypedElement fileElement;
    private IDocument document;

    public LocalResourceSaveableComparison(ICompareInput input, CompareEditorInput editorInput) {
        this(input, editorInput, input.getLeft());
    }

    public LocalResourceSaveableComparison(ICompareInput input, CompareEditorInput editorInput, ITypedElement fileElement) {
        this.input = input;
        this.editorInput = editorInput;
        this.fileElement = fileElement;
        this.initializeContentChangeListeners();
    }

    protected void initializeHashing() {
        Object document = this.getAdapter(IDocument.class);
        if (document != null) {
            this.document = (IDocument)document;
        }
    }

    private void initializeContentChangeListeners() {
        ITypedElement te = this.getFileElement();
        if (te instanceof IContentChangeNotifier) {
            if (this.contentChangeListener == null) {
                this.contentChangeListener = new IContentChangeListener(){

                    public void contentChanged(IContentChangeNotifier source) {
                        try {
                            if (!LocalResourceSaveableComparison.this.isSaving) {
                                LocalResourceSaveableComparison.this.performSave((IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                        catch (CoreException e) {
                            TeamUIPlugin.log(e);
                        }
                    }
                };
            }
            ((IContentChangeNotifier)te).addContentChangeListener(this.contentChangeListener);
        }
    }

    public void dispose() {
        ITypedElement left;
        ITypedElement te;
        if (this.contentChangeListener != null && (te = this.getFileElement()) instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)te).removeContentChangeListener(this.contentChangeListener);
        }
        if ((left = this.getFileElement()) instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)left).discardBuffer();
        }
        this.document = null;
    }

    private ITypedElement getFileElement() {
        return this.fileElement;
    }

    @Override
    protected void performSave(IProgressMonitor monitor) throws CoreException {
        if (this.checkForUpdateConflicts()) {
            return;
        }
        try {
            this.isSaving = true;
            monitor.beginTask(null, 100);
            this.flushViewers(Policy.subMonitorFor(monitor, 40));
            ITypedElement te = this.getFileElement();
            if (te instanceof LocalResourceTypedElement) {
                LocalResourceTypedElement lrte = (LocalResourceTypedElement)te;
                lrte.commit(Policy.subMonitorFor(monitor, 60));
            }
        }
        finally {
            this.fireInputChange();
            this.setDirty(false);
            this.isSaving = false;
            monitor.done();
        }
    }

    protected void flushViewers(IProgressMonitor monitor) throws CoreException {
        if (this.editorInput instanceof SaveablesCompareEditorInput) {
            ((SaveablesCompareEditorInput)this.editorInput).saveChanges(monitor, this);
        } else {
            this.editorInput.saveChanges(monitor);
        }
    }

    protected abstract void fireInputChange();

    private boolean checkForUpdateConflicts() {
        if (this.hasSaveConflict()) {
            if (Utils.RUNNING_TESTS) {
                return !Utils.TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE;
            }
            MessageDialog dialog = new MessageDialog(TeamUIPlugin.getStandardDisplay().getActiveShell(), TeamUIMessages.SyncInfoCompareInput_0, null, TeamUIMessages.SyncInfoCompareInput_1, 3, new String[]{TeamUIMessages.SyncInfoCompareInput_2, IDialogConstants.CANCEL_LABEL}, 0);
            int retval = dialog.open();
            switch (retval) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasSaveConflict() {
        ITypedElement left = this.getFileElement();
        if (left instanceof LocalResourceTypedElement) {
            LocalResourceTypedElement te = (LocalResourceTypedElement)left;
            return !te.isSynchronized();
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        if (this.editorInput instanceof SaveablesCompareEditorInput) {
            return ((SaveablesCompareEditorInput)this.editorInput).isSaveNeeded(this);
        }
        return this.editorInput.isSaveNeeded();
    }

    @Override
    protected void setDirty(boolean dirty) {
        if (this.editorInput instanceof SaveablesCompareEditorInput) {
            ((SaveablesCompareEditorInput)this.editorInput).setDirty(dirty, this);
            return;
        }
        this.editorInput.setDirty(dirty);
    }

    @Override
    protected void performRevert(IProgressMonitor monitor) {
        ITypedElement left = this.getFileElement();
        if (left instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)left).discardBuffer();
        }
    }

    public String getName() {
        if (this.input.getLeft() != null && this.input.getLeft().equals(this.fileElement)) {
            return this.input.getLeft().getName();
        }
        if (this.input.getRight() != null && this.input.getRight().equals(this.fileElement)) {
            return this.input.getRight().getName();
        }
        return this.input.getName();
    }

    public String getToolTipText() {
        return this.editorInput.getToolTipText();
    }

    public ImageDescriptor getImageDescriptor() {
        Image image = this.input.getImage();
        if (image != null) {
            return ImageDescriptor.createFromImage((Image)image);
        }
        return TeamUIPlugin.getImageDescriptor("eview16/synch_synch.png");
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getProperty();
        if ("DIRTY_STATE".equals(propertyName)) {
            Object source;
            boolean changed = false;
            Object newValue = e.getNewValue();
            if (newValue instanceof Boolean) {
                changed = (Boolean)newValue;
            }
            if ((source = e.getSource()) instanceof ContentMergeViewer) {
                ContentMergeViewer cmv = (ContentMergeViewer)source;
                if (this.input.getLeft() != null && this.input.getLeft().equals(this.fileElement)) {
                    if (changed && cmv.internalIsLeftDirty()) {
                        this.setDirty(changed);
                    } else if (!changed && !cmv.internalIsLeftDirty()) {
                        this.setDirty(changed);
                    }
                }
                if (this.input.getRight() != null && this.input.getRight().equals(this.fileElement)) {
                    if (changed && cmv.internalIsRightDirty()) {
                        this.setDirty(changed);
                    } else if (!changed && !cmv.internalIsRightDirty()) {
                        this.setDirty(changed);
                    }
                }
            } else {
                this.setDirty(changed);
            }
        }
    }

    public int hashCode() {
        if (this.document != null) {
            return this.document.hashCode();
        }
        return this.input.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Saveable)) {
            return false;
        }
        if (this.document != null) {
            Object otherDocument = ((Saveable)obj).getAdapter(IDocument.class);
            if (this.document == null && otherDocument == null) {
                return false;
            }
            return this.document != null && this.document.equals(otherDocument);
        }
        if (obj instanceof LocalResourceSaveableComparison) {
            LocalResourceSaveableComparison rscm = (LocalResourceSaveableComparison)((Object)obj);
            return rscm.input.equals(this.input);
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        LocalResourceTypedElement lrte;
        if (adapter == IDocument.class) {
            IDocumentProvider provider;
            IEditorInput input;
            ISharedDocumentAdapter sda;
            if (this.document != null) {
                return this.document;
            }
            if (this.fileElement instanceof LocalResourceTypedElement && (lrte = (LocalResourceTypedElement)this.fileElement).isConnected() && (sda = (ISharedDocumentAdapter)Adapters.adapt((Object)((Object)lrte), ISharedDocumentAdapter.class)) != null && (input = sda.getDocumentKey((Object)lrte)) != null && (provider = SharedDocumentAdapter.getDocumentProvider((IEditorInput)input)) != null) {
                return provider.getDocument((Object)input);
            }
        }
        if (adapter == IEditorInput.class && this.fileElement instanceof LocalResourceTypedElement) {
            lrte = (LocalResourceTypedElement)this.fileElement;
            return new FileEditorInput((IFile)lrte.getResource());
        }
        return super.getAdapter(adapter);
    }

    public ICompareInput getInput() {
        return this.input;
    }

    public boolean isConnectedToSharedDocument() {
        if (this.fileElement instanceof LocalResourceTypedElement) {
            LocalResourceTypedElement lrte = (LocalResourceTypedElement)this.fileElement;
            return lrte.isConnected();
        }
        return false;
    }

    public boolean isSaving() {
        return this.isSaving;
    }
}

