/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.correction.ChangeCorrectionProposal;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;

public class AddModuleRequiresCorrectionProposal
extends ChangeCorrectionProposal {
    private final String fChangeDescription;
    private final String fModuleName;
    private final ICompilationUnit fModuleCu;

    public AddModuleRequiresCorrectionProposal(String moduleName, String changeName, String changeDescription, ICompilationUnit moduleCu, int relevance) {
        super(changeName, null, relevance);
        this.fModuleName = moduleName;
        this.fChangeDescription = changeDescription;
        this.fModuleCu = moduleCu;
    }

    @Override
    protected Change createChange() throws CoreException {
        CompilationUnitChange addRequiresChange = this.createAddRequiresChange();
        return addRequiresChange;
    }

    @Override
    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.fChangeDescription;
    }

    private CompilationUnitChange createAddRequiresChange() throws CoreException {
        if (this.fModuleName == null || this.fModuleCu == null) {
            return null;
        }
        CompilationUnit astRoot = SharedASTProvider.getAST((ITypeRoot)this.fModuleCu, SharedASTProvider.WAIT_YES, null);
        ModuleDeclaration moduleDecl = astRoot.getModule();
        if (moduleDecl == null) {
            return null;
        }
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        CompilationUnitChange cuChange = null;
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)moduleDecl, ModuleDeclaration.MODULE_DIRECTIVES_PROPERTY);
        boolean requiresAlreadyPresent = false;
        List moduleStatements = moduleDecl.moduleStatements();
        ModuleDirective lastModuleRequiresDirective = null;
        if (moduleStatements != null) {
            for (ModuleDirective directive : moduleStatements) {
                if (!(directive instanceof RequiresDirective)) continue;
                Name name = ((RequiresDirective)directive).getName();
                if (this.fModuleName.equals(name.getFullyQualifiedName())) {
                    requiresAlreadyPresent = true;
                    break;
                }
                lastModuleRequiresDirective = directive;
            }
        }
        if (!requiresAlreadyPresent) {
            RequiresDirective exp = ast.newRequiresDirective();
            exp.setName(ast.newName(this.fModuleName));
            if (lastModuleRequiresDirective != null) {
                listRewrite.insertAfter((ASTNode)exp, lastModuleRequiresDirective, null);
            } else {
                listRewrite.insertLast((ASTNode)exp, null);
            }
            try {
                cuChange = new CompilationUnitChange(this.getName(), this.fModuleCu);
                TextEdit resultingEdits = rewrite.rewriteAST();
                TextChangeCompatibility.addTextEdit((TextChange)cuChange, (String)this.getName(), (TextEdit)resultingEdits);
            }
            catch (IllegalArgumentException e1) {
                JavaPlugin.log(e1);
            }
        }
        return cuChange;
    }

    public static List<IPackageFragment> getPackageFragmentsOfMatchingTypes(String stringPattern, int typeRule, IJavaElement javaElement) {
        int matchRule = 24;
        SearchPattern searchPattern = SearchPattern.createPattern((String)stringPattern, (int)typeRule, (int)0, (int)matchRule);
        if (searchPattern == null) {
            return null;
        }
        final ArrayList<IPackageFragment> packageFragments = new ArrayList<IPackageFragment>();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IPackageFragment) {
                    packageFragments.add((IPackageFragment)element);
                } else if (element instanceof IType) {
                    IType enclosingType = (IType)element;
                    packageFragments.add(enclosingType.getPackageFragment());
                }
            }
        };
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaElement});
        try {
            new SearchEngine().search(searchPattern, participants, scope, requestor, null);
        }
        catch (CoreException coreException) {}
        return packageFragments;
    }
}

