/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;

public class IEC_WSTRING
extends IEC_ANY {
    protected String value;

    public IEC_WSTRING() {
        this.value = "";
    }

    public IEC_WSTRING(DataInputStream in) {
        super(in);
    }

    public IEC_WSTRING(String initial) {
        this.value = initial;
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
        StringBuilder result = new StringBuilder();
        try {
            int size = in.readShort();
            int i = 0;
            while (i < size) {
                result.append(in.readChar());
                ++i;
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        this.value = result.toString();
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{85};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(myOut);
        try {
            outputStream.writeShort(this.value.length());
            outputStream.writeChars(this.value);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return myOut.toByteArray();
    }

    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean setValue(String value) {
        this.value = value;
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IEC_WSTRING) {
            return ((IEC_WSTRING)obj).value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_WSTRING)source).getValue();
            retval = true;
        }
        return retval;
    }
}

